/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.queries;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.index.firestore.FirestoreIndexValueComparator;
import com.google.cloud.datastore.core.index.firestore.ValueToFirestoreIndexValueConverter;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.JndexValue;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.emulator.impl.queries.AutoValue_IndexEntry;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

@AutoValue
public abstract class IndexEntry {
    abstract EntityRef entityRef();

    abstract List<JndexValue> indexValues();

    static IndexEntry of(EntityRef ref, List<JndexValue> indexValues) {
        return new AutoValue_IndexEntry(ref, indexValues);
    }

    static Stream<IndexEntry> createForIndex(Entity entity, IndexDef indexDef) {
        MultiValueBuilder builder = new MultiValueBuilder(entity.ref());
        for (IndexDef.PropertyDef p : indexDef.propertyDefs()) {
            Value value;
            if (p.path().isKey()) {
                builder.addValue(ValueToFirestoreIndexValueConverter.DEFAULT.convertEntityRefIgnoreThreshold(entity.ref()));
                continue;
            }
            if (p.path().isArrayElements()) {
                value = entity.get(p.path().dropLastPathSegment());
                if (value == null || value.type() != Value.Type.ARRAY || value.asArray().isEmpty()) {
                    return Stream.empty();
                }
                builder.forkValues(value.asArray().stream().map(ValueToFirestoreIndexValueConverter.DEFAULT::convertValueIgnoreThreshold).collect(ImmutableList.toImmutableList()));
                continue;
            }
            value = entity.get(p.path());
            if (value == null) {
                return Stream.empty();
            }
            builder.addValue(ValueToFirestoreIndexValueConverter.DEFAULT.convertValueIgnoreThreshold(value));
        }
        return builder.build();
    }

    static class Comparator
    implements java.util.Comparator<IndexEntry> {
        private ImmutableList<Direction> directions;

        Comparator(Iterable<Direction> directions) {
            this.directions = ImmutableList.copyOf(directions);
        }

        static Comparator fromIndexDef(IndexDef indexDef) {
            return new Comparator(indexDef.propertyDefs().stream().map(IndexDef.PropertyDef::direction).collect(ImmutableList.toImmutableList()));
        }

        @Override
        public int compare(IndexEntry left, IndexEntry right) {
            Preconditions.checkArgument(left.indexValues().size() == this.directions.size() && right.indexValues().size() == this.directions.size(), "IndexEntries must have one index value for every property def in its corresponding perfect index definition.");
            for (int i = 0; i < this.directions.size(); ++i) {
                int comparisonResult = FirestoreIndexValueComparator.INSTANCE.compare(left.indexValues().get(i), right.indexValues().get(i));
                if (comparisonResult == 0) continue;
                return this.directions.get(i) == Direction.DESCENDING ? -comparisonResult : comparisonResult;
            }
            return 0;
        }
    }

    private static final class MultiValueBuilder {
        private final EntityRef ref;
        private List<List<JndexValue>> indexEntries;

        MultiValueBuilder(EntityRef ref) {
            this.ref = ref;
            this.indexEntries = new ArrayList<List<JndexValue>>();
            this.indexEntries.add(new ArrayList());
        }

        void addValue(JndexValue value) {
            for (List<JndexValue> entries : this.indexEntries) {
                entries.add(value);
            }
        }

        void forkValues(Collection<JndexValue> values) {
            ArrayList<List<JndexValue>> newIndexEntries = new ArrayList<List<JndexValue>>(this.indexEntries.size() * values.size());
            for (List<JndexValue> oldEntry : this.indexEntries) {
                for (JndexValue value : values) {
                    ArrayList<JndexValue> newEntry = new ArrayList<JndexValue>(oldEntry);
                    newEntry.add(value);
                    newIndexEntries.add(newEntry);
                }
            }
            this.indexEntries = newIndexEntries;
        }

        Stream<IndexEntry> build() {
            return this.indexEntries.stream().map(values -> IndexEntry.of(this.ref, values));
        }
    }
}

