/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.rules;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.auth.rules.EntityToExpressionValueConverter;
import com.google.cloud.datastore.core.auth.rules.FirebaseRulesAuthorizerOptions;
import com.google.cloud.datastore.core.auth.rules.LookupsToAuthorize;
import com.google.cloud.datastore.core.auth.rules.RulesAccessCollector;
import com.google.cloud.datastore.core.auth.rules.RulesAuthorizer;
import com.google.cloud.datastore.core.auth.rules.RulesAuthorizerImpl;
import com.google.cloud.datastore.core.auth.rules.RulesExecutionTracker;
import com.google.cloud.datastore.core.auth.rules.RulesRequestContext;
import com.google.cloud.datastore.core.auth.rules.RulesStats;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.Write;
import com.google.cloud.datastore.core.util.DatastoreConsumer;
import com.google.cloud.datastore.emulator.impl.context.EmulatorAuthorization;
import com.google.cloud.datastore.emulator.impl.context.FirestoreEmulatorRequestContext;
import com.google.cloud.datastore.emulator.impl.rules.AutoValue_EmulatorRulesAuthorizer_RulesetCompilationException;
import com.google.cloud.datastore.emulator.impl.rules.EmulatorRuleClient;
import com.google.cloud.datastore.emulator.impl.rules.PermissionTrace;
import com.google.cloud.datastore.emulator.impl.rules.RuleCoverageTracker;
import com.google.cloud.datastore.emulator.impl.storage.FirestoreEmulatorLookupHandler;
import com.google.cloud.datastore.emulator.impl.storage.LocalEntityStore;
import com.google.cloud.datastore.emulator.impl.util.FirestoreEmulatorConverters;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.context.NonThrowingAutoCloseable;
import com.google.common.flogger.GoogleLogger;
import com.google.firebase.firebear.client.JwtToken;
import com.google.firebase.rules.lang.CompileResult;
import com.google.firebase.rules.lang.FirebaseRulesProtoCompiler;
import com.google.firebase.rules.runtime.auth.RulesValidatedSecurityContext;
import com.google.firebase.rules.runtime.evaluators.RuleClient;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.v1.Source;
import com.google.firebase.rules.v1.TestRulesetResponse;
import com.google.firestore.emulator.v1.RuleCoverageReport;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class EmulatorRulesAuthorizer {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/cloud/datastore/emulator/impl/rules/EmulatorRulesAuthorizer");
    private final FirestoreEmulatorConverters converters;
    private final RulesetAst rulesetAst;
    private final Source rules;
    private final RuleCoverageTracker tracker = new RuleCoverageTracker();
    private static final String DEFAULT_RELEASE_NAME = "DEFAULT_RELEASE_NAME";

    private EmulatorRulesAuthorizer(RulesetAst rulesetAst, FirestoreEmulatorConverters converters, Source rules) {
        this.converters = converters;
        this.rulesetAst = rulesetAst;
        this.rules = rules;
    }

    public static EmulatorRulesAuthorizer fromSource(Source rules, FirestoreEmulatorConverters converters) throws DatastoreException {
        return new EmulatorRulesAuthorizer(EmulatorRulesAuthorizer.compileRuleset(rules), converters, rules);
    }

    public void checkCommit(FirestoreEmulatorRequestContext context, long transaction, Write write, LocalEntityStore.ReadView currentView, Map<EntityRef, Optional<Entity>> mutationResults) throws DatastoreException {
        if (write.mutations().isEmpty() || EmulatorRulesAuthorizer.isAdmin(context.auth())) {
            return;
        }
        JwtToken jwt = context.auth().map(EmulatorAuthorization::jwt).orElse(null);
        OnestoreEntity.Reference arbitraryKey = write.mutations().stream().map(Mutation::key).findAny().get();
        DatabaseRef dbRef = DatabaseRef.createForApp(arbitraryKey.getApp(), arbitraryKey.getDatabaseId());
        RulesRequestContext fakeRequestContext = EmulatorRulesAuthorizer.makeRulesContext(dbRef, context.requestTime(), transaction, jwt);
        this.withVerboseErrors(client -> {
            RulesAuthorizer.PerEntityWriteAuthorizer perEntityWriteAuthorizer = EmulatorRulesAuthorizer.rulesAuthorizer(client).checkCommit(fakeRequestContext, write);
            Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> mutatedEntities = this.mangleMutations(mutationResults);
            FirestoreEmulatorLookupHandler lookupHandler = new FirestoreEmulatorLookupHandler(this.converters, currentView);
            for (OnestoreEntity.Reference key : mutatedEntities.keySet()) {
                perEntityWriteAuthorizer.checkAccess(lookupHandler, lookupHandler.lookup(key), mutatedEntities.get(key), mutatedEntities);
            }
        });
    }

    public void checkLookup(FirestoreEmulatorRequestContext context, @Nullable Long transaction, ImmutableSet<OnestoreEntity.Reference> keysToLookup, LocalEntityStore.ReadView currentView) throws DatastoreException {
        if (keysToLookup.isEmpty() || EmulatorRulesAuthorizer.isAdmin(context.auth())) {
            return;
        }
        JwtToken jwt = context.auth().map(EmulatorAuthorization::jwt).orElse(null);
        OnestoreEntity.Reference arbitraryKey = (OnestoreEntity.Reference)keysToLookup.stream().findAny().get();
        DatabaseRef dbRef = DatabaseRef.createForApp(arbitraryKey.getApp(), arbitraryKey.getDatabaseId());
        RulesRequestContext fakeRequestContext = EmulatorRulesAuthorizer.makeRulesContext(dbRef, context.requestTime(), transaction, jwt);
        this.withVerboseErrors(client -> {
            RulesAuthorizer.PerEntityReadAuthorizer perEntityReadAuthorizer = EmulatorRulesAuthorizer.rulesAuthorizer(client).checkAccess(fakeRequestContext, Lookup.builder().keys(keysToLookup).build());
            if (perEntityReadAuthorizer == null) {
                return;
            }
            FirestoreEmulatorLookupHandler lookupHandler = new FirestoreEmulatorLookupHandler(this.converters, currentView);
            for (OnestoreEntity.Reference key : keysToLookup) {
                perEntityReadAuthorizer.checkAccess(lookupHandler, lookupHandler.lookup(key));
            }
        });
    }

    public void checkQuery(FirestoreEmulatorRequestContext context, Query query, LocalEntityStore.ReadView currentView) throws DatastoreException {
        if (EmulatorRulesAuthorizer.isAdmin(context.auth())) {
            return;
        }
        JwtToken jwt = context.auth().map(EmulatorAuthorization::jwt).orElse(null);
        RulesRequestContext fakeRequestContext = EmulatorRulesAuthorizer.makeRulesContext(context.databaseRef(), context.requestTime(), null, jwt);
        FirestoreEmulatorLookupHandler lookupHandler = new FirestoreEmulatorLookupHandler(this.converters, currentView);
        this.withVerboseErrors(client -> EmulatorRulesAuthorizer.rulesAuthorizer(client).checkAccess(fakeRequestContext, query, lookupHandler));
    }

    private Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> mangleMutations(Map<EntityRef, Optional<Entity>> mutationResults) {
        HashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto> mangled = new HashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();
        for (Map.Entry<EntityRef, Optional<Entity>> entry : mutationResults.entrySet()) {
            OnestoreEntity.Reference key = FirestoreEmulatorConverters.toReference(entry.getKey());
            OnestoreEntity.EntityProto value = entry.getValue().map(this.converters::entityToProto).orElse(null);
            mangled.put(key, value);
        }
        return mangled;
    }

    private static boolean isAdmin(Optional<EmulatorAuthorization> auth) {
        return auth.isPresent() && auth.get().kind().equals((Object)EmulatorAuthorization.Kind.ADMIN);
    }

    private static RulesRequestContext makeRulesContext(DatabaseRef dbRef, Instant timestamp, @Nullable Long transaction, @Nullable JwtToken jwt) {
        return RulesRequestContext.builder().alreadyAuthorized(false).databaseRef(dbRef).httpRequestHeaders(ImmutableMap.of()).phaseExecutionTimer(new FakeRulesExecutionTracker()).rulesAccessCollector(new FakeRulesAccessCollector()).rulesValidatedSecurityContext(new RulesValidatedSecurityContext(null, jwt)).startTime(timestamp).stats(new FakeRulesStats()).transactionHandle(transaction).build();
    }

    private static RulesetAst compileRuleset(Source rulesetSource) throws DatastoreException {
        FirebaseRulesProtoCompiler compiler = FirebaseRulesProtoCompiler.create();
        CompileResult result = compiler.compile(rulesetSource);
        Map<TestRulesetResponse.Issue.Severity, List<TestRulesetResponse.Issue>> issuesBySeverity = result.getIssues().stream().collect(Collectors.groupingBy(TestRulesetResponse.Issue::getSeverity));
        List<TestRulesetResponse.Issue> errors = issuesBySeverity.get(TestRulesetResponse.Issue.Severity.ERROR);
        if (errors != null) {
            String message = errors.stream().map(err -> String.format("L%d:%d %s", err.getSourcePosition().getLine(), err.getSourcePosition().getColumn(), err.getDescription())).collect(Collectors.joining("\n"));
            String string = String.valueOf(message);
            throw new DatastoreException(string.length() != 0 ? "Error compiling rules:\n".concat(string) : new String("Error compiling rules:\n"), DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, RulesetCompilationException.of(errors));
        }
        for (TestRulesetResponse.Issue issue : result.getIssues()) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/cloud/datastore/emulator/impl/rules/EmulatorRulesAuthorizer", "compileRuleset", 244, "EmulatorRulesAuthorizer.java")).log(issue);
        }
        return result.getRulesetAst();
    }

    private static RulesAuthorizer rulesAuthorizer(RuleClient ruleClient) {
        return new RulesAuthorizerImpl(FirebaseRulesAuthorizerOptions.builder().build(), ruleClient, Ticker.systemTicker(), new EntityToExpressionValueConverter(), DEFAULT_RELEASE_NAME);
    }

    private void withVerboseErrors(DatastoreConsumer<RuleClient> check) throws DatastoreException {
        EmulatorRuleClient client = new EmulatorRuleClient(this.rulesetAst);
        try {
            check.accept(client);
        }
        catch (DatastoreException e) {
            throw e.getErrorCode() != DatastoreV3Pb.Error.ErrorCode.PERMISSION_DENIED ? e : EmulatorRulesAuthorizer.verboseError(e, client.permissionTraces());
        }
        finally {
            this.tracker.addResultsFrom(client);
        }
    }

    private static DatastoreException verboseError(DatastoreException cause, Collection<PermissionTrace> traces) {
        String statementsEvaluated = traces.stream().map(trace -> String.format("%s for '%s' @ L%d", trace.error().orElse("false"), trace.method(), trace.expression().getSourcePosition().getLine())).collect(Collectors.joining(", ", "\n", ""));
        String message = traces.isEmpty() ? "No matching allow statements" : statementsEvaluated;
        return DatastoreException.builder().errorCode(cause.getErrorCode()).message(message).cause(cause.getCause()).build();
    }

    public RuleCoverageReport ruleCoverageReport() {
        return this.tracker.buildReport(this.rules, this.rulesetAst);
    }

    private static final class FakeRulesStats
    implements RulesStats {
        private FakeRulesStats() {
        }

        @Override
        public void setLabel(RulesStats.RulesCategory key, RulesStats.RuleEvaluationOutcome outcome) {
        }

        @Override
        public void setRulesetId(String rulesetId) {
        }

        @Override
        public void accumulate(RulesStats.RulesCategory key, long delta) {
        }
    }

    private static final class FakeRulesAccessCollector
    implements RulesAccessCollector {
        private FakeRulesAccessCollector() {
        }

        @Override
        public void registerLookup(LookupsToAuthorize.Lookup lookup) {
        }

        @Override
        public void registerLookup(LookupsToAuthorize.Lookup lookup, long durationInMicros, boolean success) {
        }

        @Override
        public void registerFieldAccesses(Collection<List<String>> fields) {
        }

        @Override
        public RulesAccessCollector setReleaseName(String name) {
            return this;
        }

        @Override
        public RulesAccessCollector setRulesetName(String name) {
            return this;
        }
    }

    private static final class FakeRulesExecutionTracker
    implements RulesExecutionTracker {
        private FakeRulesExecutionTracker() {
        }

        @Override
        public NonThrowingAutoCloseable enter(RulesExecutionTracker.RulesPhase phase) {
            return () -> {};
        }
    }

    @AutoValue
    public static abstract class RulesetCompilationException
    extends IllegalArgumentException {
        public abstract ImmutableList<TestRulesetResponse.Issue> issues();

        public static RulesetCompilationException of(Iterable<TestRulesetResponse.Issue> issues) {
            return new AutoValue_EmulatorRulesAuthorizer_RulesetCompilationException(ImmutableList.copyOf(issues));
        }
    }
}

