/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.rules;

import com.google.cloud.datastore.emulator.impl.rules.EmulatorRuleClient;
import com.google.cloud.datastore.emulator.impl.rules.PermissionTrace;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.firebase.rules.lang.common.AbstractAstVisitor;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.v1.Source;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.firestore.emulator.v1.ExpressionReport;
import com.google.firestore.emulator.v1.RuleCoverageReport;
import com.google.firestore.emulator.v1.ValueCount;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RuleCoverageTracker {
    private final Table<Expression, ExpressionValue, Integer> underlying = HashBasedTable.create();

    void addResultsFrom(EmulatorRuleClient client) {
        for (PermissionTrace trace : client.permissionTraces()) {
            this.addAll(trace.evaluationResults());
        }
    }

    private void addAll(Map<Expression, ExpressionValue> toAdd) {
        toAdd.forEach(this::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void add(Expression expression, ExpressionValue expressionValue) {
        Preconditions.checkNotNull(expressionValue);
        Table<Expression, ExpressionValue, Integer> table = this.underlying;
        synchronized (table) {
            this.underlying.row(expression).compute(expressionValue, (k2, v2) -> (v2 == null ? 0 : v2) + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int totalEvaluationCount() {
        Table<Expression, ExpressionValue, Integer> table = this.underlying;
        synchronized (table) {
            return this.underlying.values().stream().mapToInt(Integer::intValue).sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ImmutableSet<ExpressionValue> allEvaluationResults() {
        Table<Expression, ExpressionValue, Integer> table = this.underlying;
        synchronized (table) {
            return ImmutableSet.copyOf(this.underlying.columnKeySet());
        }
    }

    RuleCoverageReport buildReport(Source source, RulesetAst rules) {
        ImmutableSet<Expression> rootExpressions = ShallowExpressionCollector.collectExpressions(rules);
        ImmutableMap<Expression, SourcePosition> positionReplacements = ReplacementCollector.collectReplacements(rules);
        ImmutableSet<ExpressionReport> children = this.buildExpressionReports(rootExpressions, positionReplacements);
        return RuleCoverageReport.newBuilder().setRules(source).addAllReport(children).build();
    }

    private ImmutableSet<ExpressionReport> buildExpressionReports(ImmutableSet<Expression> expressions, ImmutableMap<Expression, SourcePosition> positionReplacements) {
        return expressions.stream().filter(child -> !child.hasLiteral()).map(expression -> {
            ImmutableSet<ExpressionReport> children = this.buildExpressionReports(ShallowExpressionCollector.collectExpressions(expression), positionReplacements);
            ImmutableList<ValueCount> values = this.buildValueReports((Expression)expression);
            return ExpressionReport.newBuilder().setSourcePosition((SourcePosition)positionReplacements.get(expression)).addAllValues(values).addAllChildren(children).build();
        }).collect(ImmutableSet.toImmutableSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableList<ValueCount> buildValueReports(Expression expression) {
        Table<Expression, ExpressionValue, Integer> table = this.underlying;
        synchronized (table) {
            return this.underlying.row(expression).entrySet().stream().map(entry -> ValueCount.newBuilder().setValue((ExpressionValue)entry.getKey()).setCount((Integer)entry.getValue()).build()).collect(ImmutableList.toImmutableList());
        }
    }

    private static final class ShallowExpressionCollector
    extends AbstractAstVisitor {
        private final ImmutableSet.Builder<Expression> expressions = ImmutableSet.builder();

        private ShallowExpressionCollector() {
        }

        static ImmutableSet<Expression> collectExpressions(RulesetAst ast) {
            ShallowExpressionCollector collector = new ShallowExpressionCollector();
            collector.visitAst(ast);
            return collector.expressions.build();
        }

        static ImmutableSet<Expression> collectExpressions(Expression expression) {
            ShallowExpressionCollector collector = new ShallowExpressionCollector();
            collector.visitExpression(expression);
            return collector.expressions.build();
        }

        private void visitExpression(Expression expression) {
            super.visit(expression);
        }

        @Override
        protected void visit(Expression expression) {
            this.expressions.add((Object)expression);
        }
    }

    static class PositionCollector
    extends AbstractAstVisitor {
        protected final ImmutableSet.Builder<SourcePosition> positions = ImmutableSet.builder();

        private PositionCollector() {
        }

        @Override
        protected void visitIdentifier(Identifier identifier) {
            this.positions.add((Object)identifier.getSourcePosition());
            super.visitIdentifier(identifier);
        }

        @Override
        protected void visitMatchRule(MatchRule matchRule) {
            this.positions.add((Object)matchRule.getSourcePosition());
            super.visitMatchRule(matchRule);
        }

        @Override
        protected void visit(Expression expression) {
            this.positions.add((Object)expression.getSourcePosition());
            super.visit(expression);
        }
    }

    static class ReplacementCollector
    extends PositionCollector {
        private final ImmutableMap.Builder<Expression, SourcePosition> replacements = ImmutableMap.builder();

        private ReplacementCollector() {
        }

        public static ImmutableMap<Expression, SourcePosition> collectReplacements(RulesetAst ast) {
            ReplacementCollector collector = new ReplacementCollector();
            collector.visitAst(ast);
            return collector.replacements.build();
        }

        private static SourcePosition spanningPosition(ImmutableCollection<SourcePosition> allPositions) {
            SourcePosition start = allPositions.stream().min(Comparator.comparing(SourcePosition::getCurrentOffset)).get();
            int end = allPositions.stream().max(Comparator.comparing(SourcePosition::getEndOffset)).get().getEndOffset();
            return start.toBuilder().setEndOffset(end).build();
        }

        @Override
        protected void visit(Expression expression) {
            ReplacementCollector collector = new ReplacementCollector();
            collector.visitExpression(expression);
            ImmutableCollection positions = collector.positions.build();
            SourcePosition correctedPosition = ReplacementCollector.spanningPosition(positions);
            this.replacements.putAll(collector.replacements.build());
            this.replacements.put(expression, correctedPosition);
            this.positions.add(correctedPosition);
        }

        protected void visitExpression(Expression expression) {
            super.visit(expression);
        }
    }
}

