/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.storage;

import com.google.cloud.datastore.core.auth.rules.RulesAuthorizer;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.emulator.impl.storage.LocalEntityStore;
import com.google.cloud.datastore.emulator.impl.util.EntityReadResult;
import com.google.cloud.datastore.emulator.impl.util.FirestoreEmulatorConverters;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;

public class FirestoreEmulatorLookupHandler
implements RulesAuthorizer.LookupHandler {
    private final FirestoreEmulatorConverters converters;
    private final LocalEntityStore.ReadView readView;

    public FirestoreEmulatorLookupHandler(FirestoreEmulatorConverters converters, LocalEntityStore.ReadView readView) {
        this.converters = converters;
        this.readView = readView;
    }

    @Override
    public ReadResult exists(OnestoreEntity.Reference key) {
        return this.lookup(key);
    }

    @Override
    public ReadResult lookup(OnestoreEntity.Reference key) {
        return Iterables.getOnlyElement(this.batchLookup(ImmutableList.of(key)));
    }

    public ImmutableList<ReadResult> batchLookup(List<OnestoreEntity.Reference> keys) {
        ImmutableList refs = keys.stream().map(FirestoreEmulatorConverters::toEntityRef).collect(ImmutableList.toImmutableList());
        ImmutableMap<EntityRef, EntityReadResult> rows = this.readView.get(ImmutableSet.copyOf(refs));
        return refs.stream().map(ref -> this.converters.rowToReadResult((EntityReadResult)rows.get(ref))).collect(ImmutableList.toImmutableList());
    }
}

