/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.storage;

import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.emulator.impl.storage.LocalEntityStore;
import com.google.cloud.datastore.emulator.impl.storage.StoredEntity;
import com.google.cloud.datastore.emulator.impl.transactions.LockManager;
import com.google.cloud.datastore.emulator.impl.transactions.PessimisticLockManager;
import com.google.cloud.datastore.emulator.impl.util.EmulatorComparators;
import com.google.cloud.datastore.emulator.impl.util.EntityReadResult;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.time.TimeSource;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public final class FlatLocalEntityStore
implements LocalEntityStore {
    private final ConcurrentMap<EntityRef, StoredEntity.History> rows = Maps.newConcurrentMap();
    private final LockManager<EntityRef> lockManager;
    private final TimeSource clock;
    private final Duration historyThreshold;

    public FlatLocalEntityStore(TimeSource clock, Duration historyThreshold) {
        this.clock = clock;
        this.historyThreshold = historyThreshold;
        this.lockManager = PessimisticLockManager.create(EmulatorComparators.ENTITY_REF_COMPARATOR, clock);
    }

    @Override
    public LocalEntityStore.ReadView snapshot(Instant time) {
        return new HistoricalSnapshotReadView(time);
    }

    @Override
    public synchronized LocalEntityStore.ReadView read(long transaction) {
        return new StronglyConsistentReadView(transaction);
    }

    @Override
    public ImmutableMap<EntityRef, EntityReadResult> commit(long transaction, Map<EntityRef, Optional<Entity>> entitiesToPut) {
        try (LockManager.TransactionEvidence ev = this.lockManager.lockForCommit(transaction, ImmutableSet.copyOf(entitiesToPut.keySet()));){
            Instant now = this.clock.now();
            ImmutableMap<EntityRef, EntityReadResult> immutableMap = entitiesToPut.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.modifyRow((EntityRef)entry.getKey(), (Optional)entry.getValue(), now)));
            return immutableMap;
        }
    }

    private EntityReadResult modifyRow(EntityRef ref, Optional<Entity> entityToPut, Instant now) {
        StoredEntity.History history = this.historyFor(ref);
        StoredEntity prev = history.latest();
        Optional<StoredEntity> next = prev.updated(entityToPut, now);
        next.ifPresent(e -> this.rows.put(ref, history.withNewState((StoredEntity)e)));
        StoredEntity cur = next.orElse(prev);
        return EntityReadResult.builder().ref(ref).entity(cur.entity()).createdAt(cur.createdAt()).updatedAt(cur.commitTimestamp()).readAt(now).build();
    }

    private StoredEntity.History historyFor(EntityRef ref) {
        return this.rows.computeIfAbsent(ref, x -> new StoredEntity.History(this.historyThreshold));
    }

    private final class HistoricalSnapshotReadView
    implements LocalEntityStore.ReadView {
        private final Instant timestamp;

        HistoricalSnapshotReadView(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public ImmutableMap<EntityRef, EntityReadResult> get(Set<EntityRef> keys) {
            return keys.stream().collect(ImmutableMap.toImmutableMap(key -> key, key -> {
                StoredEntity row = FlatLocalEntityStore.this.historyFor(key).atInstant(this.timestamp);
                return EntityReadResult.builder().ref((EntityRef)key).entity(row.entity()).createdAt(row.createdAt()).updatedAt(row.commitTimestamp()).readAt(this.timestamp).build();
            }));
        }

        @Override
        public ImmutableMap<EntityRef, EntityReadResult> all() {
            return FlatLocalEntityStore.this.rows.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
                StoredEntity row = ((StoredEntity.History)entry.getValue()).atInstant(this.timestamp);
                return EntityReadResult.builder().ref((EntityRef)entry.getKey()).entity(row.entity()).createdAt(row.createdAt()).updatedAt(row.commitTimestamp()).readAt(this.timestamp).build();
            }));
        }

        @Override
        public void close() {
        }
    }

    private final class StronglyConsistentReadView
    implements LocalEntityStore.ReadView {
        private final long transaction;

        StronglyConsistentReadView(long transaction) {
            this.transaction = transaction;
        }

        @Override
        public ImmutableMap<EntityRef, EntityReadResult> get(Set<EntityRef> keys) {
            try (LockManager.TransactionEvidence ev = FlatLocalEntityStore.this.lockManager.lockForReads(this.transaction, ImmutableSet.copyOf(keys));){
                Instant now = FlatLocalEntityStore.this.clock.now();
                ImmutableMap<EntityRef, EntityReadResult> immutableMap = keys.stream().collect(ImmutableMap.toImmutableMap(key -> key, key -> {
                    StoredEntity row = FlatLocalEntityStore.this.historyFor(key).latest();
                    return EntityReadResult.builder().ref((EntityRef)key).entity(row.entity()).createdAt(row.createdAt()).updatedAt(row.commitTimestamp()).readAt(now).build();
                }));
                return immutableMap;
            }
        }

        @Override
        public ImmutableMap<EntityRef, EntityReadResult> all() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }
}

