/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.storage;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.emulator.impl.storage.AutoValue_StoredEntity;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.Optional;
import java.util.SortedSet;
import javax.annotation.CheckReturnValue;

@AutoValue
abstract class StoredEntity {
    StoredEntity() {
    }

    abstract Instant commitTimestamp();

    abstract Optional<Entity> entity();

    abstract Optional<Instant> createdAt();

    private static StoredEntity createPresent(Instant commitTime, Entity entity, Instant createdAt) {
        return new AutoValue_StoredEntity(commitTime, Optional.of(entity), Optional.of(createdAt));
    }

    private static StoredEntity missing(Instant commitTime) {
        return new AutoValue_StoredEntity(commitTime, Optional.empty(), Optional.empty());
    }

    final Optional<StoredEntity> updated(Optional<Entity> newEntity, Instant time) {
        if (!this.entity().isPresent() && !newEntity.isPresent()) {
            return Optional.empty();
        }
        StoredEntity next = newEntity.map(entity -> StoredEntity.createPresent(time, entity, this.createdAt().orElse(time))).orElseGet(() -> StoredEntity.missing(time));
        return Optional.of(next);
    }

    static final class History {
        private static final Comparator<StoredEntity> BY_TIMESTAMP = Comparator.comparing(StoredEntity::commitTimestamp);
        private final ImmutableSortedSet<StoredEntity> snapshots;
        private final Duration historyThreshold;

        History(Duration historyThreshold) {
            this.historyThreshold = historyThreshold;
            this.snapshots = ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(BY_TIMESTAMP).add((Object)StoredEntity.missing(Instant.EPOCH))).build();
        }

        private History(Duration historyThreshold, ImmutableSortedSet<StoredEntity> snapshots) {
            Preconditions.checkArgument(!snapshots.isEmpty());
            this.historyThreshold = historyThreshold;
            this.snapshots = snapshots;
        }

        final StoredEntity latest() {
            return this.snapshots.last();
        }

        final StoredEntity atInstant(Instant t) {
            StoredEntity storedEntity = this.snapshots.floor(StoredEntity.missing(t));
            if (storedEntity == null) {
                throw new GarbageCollectedException();
            }
            return storedEntity;
        }

        final int size() {
            return this.snapshots.size();
        }

        @CheckReturnValue
        final History withNewState(StoredEntity storedEntity) {
            Preconditions.checkArgument(storedEntity.commitTimestamp().isAfter(this.latest().commitTimestamp()));
            SortedSet recentHistory = this.snapshots.tailSet((Object)this.atInstant(storedEntity.commitTimestamp().minus(this.historyThreshold)));
            return new History(this.historyThreshold, (ImmutableSortedSet<StoredEntity>)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(BY_TIMESTAMP).addAll((Iterable)recentHistory)).add(storedEntity)).build());
        }

        static class GarbageCollectedException
        extends RuntimeException {
            GarbageCollectedException() {
            }
        }
    }
}

