/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.transactions;

import com.google.cloud.datastore.emulator.impl.transactions.LockOwnership;
import com.google.cloud.datastore.emulator.impl.transactions.LockRequest;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.time.TimeSource;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

class EntityLock {
    private final ConcurrentMap<Long, LockOwnership> readLocks = new ConcurrentHashMap<Long, LockOwnership>();
    private final ConcurrentLinkedQueue<LockRequest> queue = new ConcurrentLinkedQueue();
    private final Duration ownershipTimeout;
    private final LockOwnership commitLock;
    private final TimeSource timeSource;

    EntityLock(Duration ownershipTimeout, TimeSource timeSource) {
        this.ownershipTimeout = ownershipTimeout;
        this.commitLock = new LockOwnership(ownershipTimeout, timeSource);
        this.timeSource = timeSource;
    }

    synchronized void processLockRequests() {
        if (this.queue.isEmpty() || !this.commitLock.isPreemptable()) {
            return;
        }
        LockRequest lockRequest = this.queue.peek();
        switch (lockRequest.lockType()) {
            case READ: {
                LockOwnership readLock = this.readLocks.computeIfAbsent(lockRequest.handle(), k -> new LockOwnership(this.ownershipTimeout, this.timeSource));
                readLock.acquireOwnership(lockRequest.handle());
                this.queue.poll().waitForLockFuture().complete(() -> readLock.lock(lockRequest.handle()));
                return;
            }
            case COMMIT: {
                for (LockOwnership lock : this.readLocks.values()) {
                    if (lock.isOwnedBy(lockRequest.handle()) || lock.isPreemptable()) continue;
                    return;
                }
                if (!this.commitLock.acquireOwnership(lockRequest.handle())) {
                    return;
                }
                this.queue.poll().waitForLockFuture().complete(() -> {
                    this.commitLock.lock(lockRequest.handle());
                    if (this.readLocks.containsKey(lockRequest.handle())) {
                        ((LockOwnership)this.readLocks.get(lockRequest.handle())).releaseOwnership(lockRequest.handle());
                    }
                });
            }
        }
    }

    CompletableFuture<LockRequest.LockProvider> acquireOwnership(LockRequest.LockType lockType, long transactionHandle) {
        LockOwnership lock = this.getLock(lockType, transactionHandle);
        if (lock != null && lock.isOwnedBy(transactionHandle) && !lock.isPreemptable()) {
            return CompletableFuture.completedFuture(() -> lock.lock(transactionHandle));
        }
        LockRequest lockRequest = LockRequest.create(lockType, transactionHandle);
        this.queue.add(lockRequest);
        return lockRequest.waitForLockFuture();
    }

    void unlockLock(LockRequest.LockType lockType, long transactionHandle) {
        LockOwnership lock = this.getLock(lockType, transactionHandle);
        if (lock != null) {
            lock.unlock(transactionHandle);
        }
    }

    void releaseLock(LockRequest.LockType lockType, long transactionHandle) {
        LockOwnership lock = this.getLock(lockType, transactionHandle);
        if (lock != null) {
            lock.releaseOwnership(transactionHandle);
        }
    }

    @Nullable
    private LockOwnership getLock(LockRequest.LockType lockType, long transactionHandle) {
        return lockType == LockRequest.LockType.READ ? (LockOwnership)this.readLocks.get(transactionHandle) : this.commitLock;
    }

    @VisibleForTesting
    LockOwnership getCommitLock() {
        return this.commitLock;
    }

    @VisibleForTesting
    ConcurrentMap<Long, LockOwnership> getReadLocks() {
        return this.readLocks;
    }

    @VisibleForTesting
    ConcurrentLinkedQueue<LockRequest> getQueue() {
        return this.queue;
    }
}

