/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.transactions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.time.TimeSource;
import java.time.Duration;
import java.time.Instant;

class LockOwnership {
    private final Duration ownershipTimeout;
    private final TimeSource timeSource;
    private volatile boolean isLocked = false;
    private volatile long handle = 0L;
    private Instant ownershipAcquiredInstant = Instant.EPOCH;

    LockOwnership(Duration ownershipTimeout, TimeSource timeSource) {
        this.ownershipTimeout = ownershipTimeout;
        this.timeSource = timeSource;
    }

    public synchronized boolean acquireOwnership(long newHandle) {
        Preconditions.checkArgument(newHandle != 0L);
        if (this.isPreemptable()) {
            this.handle = newHandle;
            this.ownershipAcquiredInstant = this.timeSource.now();
        }
        return this.handle == newHandle;
    }

    public synchronized boolean releaseOwnership(long expectedOwnerHandle) {
        if (this.handle == expectedOwnerHandle) {
            this.isLocked = false;
            this.handle = 0L;
        }
        return !this.isLocked && this.handle == 0L;
    }

    public synchronized void lock(long expectedOwnerHandle) {
        Preconditions.checkState(this.isOwnedBy(expectedOwnerHandle));
        Preconditions.checkState(!this.isPreemptable());
        this.isLocked = true;
    }

    public synchronized void unlock(long expectedOwnerHandle) {
        Preconditions.checkState(this.isOwnedBy(expectedOwnerHandle));
        this.isLocked = false;
    }

    public boolean isOwnedBy(long expectedOwnerHandle) {
        return this.handle != 0L && this.handle == expectedOwnerHandle;
    }

    public boolean isPreemptable() {
        return this.handle == 0L || !this.isLocked && this.timeSource.now().isAfter(this.ownershipAcquiredInstant.plus(this.ownershipTimeout));
    }

    @VisibleForTesting
    synchronized void expire() {
        this.ownershipAcquiredInstant = Instant.EPOCH;
    }
}

