/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.transactions;

import com.google.cloud.datastore.emulator.impl.transactions.LockManager;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.time.TimeSource;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;

public class OptimisticLockManager<K>
implements LockManager<K> {
    private static final Duration IDLE_GRACE_PERIOD = Duration.ofSeconds(30L);
    private static final Duration IDLE_TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration MAX_DURATION = Duration.ofSeconds(60L);
    private final Map<K, Instant> lastWritten = Maps.newHashMap();
    private final Set<K> activelyBeingWritten = Sets.newHashSet();
    private final Map<Long, View<K>> views = Maps.newHashMap();
    private final Set<Long> deadTransactions = Sets.newHashSet();
    private final TimeSource clock;

    public OptimisticLockManager(TimeSource clock) {
        this.clock = clock;
    }

    @Override
    public LockManager.TransactionEvidence lockForReads(long transactionId, ImmutableSet<K> additionalKeys) {
        return this.readLock(transactionId, additionalKeys);
    }

    @Override
    public LockManager.TransactionEvidence lockForCommit(long transactionId, ImmutableSet<K> keysToWrite) {
        return this.writeLock(transactionId, keysToWrite);
    }

    private synchronized ReadEvidence readLock(long transactionId, ImmutableSet<K> additionalKeys) {
        if (this.deadTransactions.contains(transactionId)) {
            throw new LockManager.TransactionExpiredException();
        }
        Instant now = this.clock.now();
        View view = this.views.computeIfAbsent(transactionId, x -> View.create(now));
        if (view.isExpired(now)) {
            this.expireAndThrow(transactionId);
        }
        view.add(additionalKeys, now);
        return new ReadEvidence();
    }

    private synchronized WriteEvidence writeLock(long transactionId, ImmutableSet<K> keysToWrite) {
        if (this.deadTransactions.contains(transactionId)) {
            throw new LockManager.TransactionExpiredException(String.format("Transaction %d is already expired", transactionId));
        }
        Instant now = this.clock.now();
        View view = this.views.computeIfAbsent(transactionId, x -> View.create(now));
        if (view.isExpired(now) || view.isConflicted(this.lastWritten, this.activelyBeingWritten)) {
            this.expireAndThrow(transactionId);
        }
        this.activelyBeingWritten.addAll(keysToWrite);
        return new WriteEvidence(transactionId, keysToWrite);
    }

    private synchronized void releaseWriteLock(long transactionId, Set<K> keysWritten) {
        this.views.remove(transactionId);
        this.deadTransactions.add(transactionId);
        Instant now = this.clock.now();
        this.activelyBeingWritten.removeAll(keysWritten);
        for (K key : keysWritten) {
            this.lastWritten.put(key, now);
        }
    }

    private synchronized void expireAndThrow(long transactionId) {
        this.views.remove(transactionId);
        this.deadTransactions.add(transactionId);
        throw new LockManager.TransactionExpiredException();
    }

    private static class View<K> {
        private final Instant createdAt;
        private Instant lastActivityAt;
        private final Map<K, Instant> firstSeen = Maps.newHashMap();

        private View(Instant now) {
            this.createdAt = now;
            this.lastActivityAt = now;
        }

        static <K> View<K> create(Instant now) {
            return new View<K>(now);
        }

        private void add(Iterable<K> keys, Instant now) {
            this.lastActivityAt = now;
            for (K k : keys) {
                this.firstSeen.putIfAbsent(k, now);
            }
        }

        private boolean isExpired(Instant now) {
            return Duration.between(this.createdAt, now).compareTo(MAX_DURATION) > 0 || Duration.between(this.createdAt, now).compareTo(IDLE_GRACE_PERIOD) > 0 && Duration.between(this.lastActivityAt, now).compareTo(IDLE_TIMEOUT) > 0;
        }

        private boolean isConflicted(Map<K, Instant> lastWritten, Set<K> activelyBeingWritten) {
            return this.hasBeenOverwritten(lastWritten) || this.isActivelyBeingWritten(activelyBeingWritten);
        }

        private boolean isActivelyBeingWritten(Set<K> activelyBeingWritten) {
            return !Sets.intersection(this.firstSeen.keySet(), activelyBeingWritten).isEmpty();
        }

        private boolean hasBeenOverwritten(Map<K, Instant> lastWritten) {
            return this.firstSeen.entrySet().stream().anyMatch(entry -> {
                Instant readAt = (Instant)entry.getValue();
                Instant writtenAt = (Instant)lastWritten.get(entry.getKey());
                return writtenAt != null && !writtenAt.isBefore(readAt);
            });
        }
    }

    private class WriteEvidence
    implements LockManager.TransactionEvidence {
        long transactionId;
        Set<K> keys;

        WriteEvidence(long transactionId, Set<K> keys) {
            this.transactionId = transactionId;
            this.keys = keys;
        }

        @Override
        public void close() {
            OptimisticLockManager.this.releaseWriteLock(this.transactionId, this.keys);
        }
    }

    private static class ReadEvidence
    implements LockManager.TransactionEvidence {
        private ReadEvidence() {
        }

        @Override
        public void close() {
        }
    }
}

