/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.transactions;

import com.google.cloud.datastore.emulator.impl.transactions.EntityLock;
import com.google.cloud.datastore.emulator.impl.transactions.LockManager;
import com.google.cloud.datastore.emulator.impl.transactions.LockRequest;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.common.time.TimeSource;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PessimisticLockManager<K>
implements LockManager<K> {
    static final Duration DEFAULT_ACQUIRE_TIMEOUT = Duration.ofSeconds(30L);
    static final Duration DEFAULT_PROCESSING_INTERVAL = Duration.ofMillis(10L);
    private static final Duration DEFAULT_OWNERSHIP_TIMEOUT = Duration.ofSeconds(30L);
    private final ConcurrentMap<Long, ConcurrentMap<K, LockRequest.LockType>> txnToUsage = new ConcurrentHashMap<Long, ConcurrentMap<K, LockRequest.LockType>>();
    private final Map<K, EntityLock> locks = new ConcurrentHashMap<K, EntityLock>();
    private final Comparator<K> keyComparator;
    private final TimeSource timeSource;
    private final Duration acquireTimeout;

    public static <K extends Comparable<K>> PessimisticLockManager<K> create(TimeSource timeSource) {
        return PessimisticLockManager.create(timeSource, DEFAULT_ACQUIRE_TIMEOUT);
    }

    public static <K extends Comparable<K>> PessimisticLockManager<K> create(TimeSource timeSource, Duration acquireTimeout) {
        return new PessimisticLockManager(Comparator.naturalOrder(), timeSource, acquireTimeout, DEFAULT_PROCESSING_INTERVAL);
    }

    public static <K extends Comparable<K>> PessimisticLockManager<K> create(TimeSource timeSource, Duration acquireTimeout, Duration lockProcessingInterval) {
        return new PessimisticLockManager(Comparator.naturalOrder(), timeSource, acquireTimeout, lockProcessingInterval);
    }

    public static <K> PessimisticLockManager<K> create(Comparator<K> comparator, TimeSource timeSource) {
        return new PessimisticLockManager<K>(comparator, timeSource, DEFAULT_ACQUIRE_TIMEOUT, DEFAULT_PROCESSING_INTERVAL);
    }

    private PessimisticLockManager(Comparator<K> keyComparator, TimeSource timeSource, Duration acquireTimeout, Duration lockProcessingInterval) {
        this.keyComparator = keyComparator;
        this.timeSource = timeSource;
        this.acquireTimeout = acquireTimeout;
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                for (EntityLock lock : PessimisticLockManager.this.locks.values()) {
                    lock.processLockRequests();
                }
            }
        }, 0L, lockProcessingInterval.toMillis());
    }

    private SortedSet<K> getAllKeysForTransaction(LockRequest.LockType lockType, long transactionHandle, ImmutableSet<K> additionalKeys) {
        ConcurrentMap allKeys = this.txnToUsage.computeIfAbsent(transactionHandle, handle -> new ConcurrentHashMap());
        additionalKeys.forEach(key -> {
            LockRequest.LockType origLockType = (LockRequest.LockType)((Object)((Object)allKeys.get(key)));
            if (origLockType == null || origLockType == LockRequest.LockType.READ && lockType == LockRequest.LockType.COMMIT) {
                allKeys.put(key, lockType);
            }
        });
        return ImmutableSortedSet.copyOf(this.keyComparator, allKeys.keySet());
    }

    private LockManager.TransactionEvidence lock(LockRequest.LockType lockType, long transactionHandle, ImmutableSet<K> additionalKeys) {
        Duration totalTimeSpent = Duration.ZERO;
        TransactionEvidenceBuilder builder = new TransactionEvidenceBuilder(lockType, transactionHandle);
        for (Object key : this.getAllKeysForTransaction(lockType, transactionHandle, additionalKeys)) {
            EntityLock lock = this.locks.computeIfAbsent(key, k -> new EntityLock(DEFAULT_OWNERSHIP_TIMEOUT, this.timeSource));
            builder.addLock(lock);
            try {
                Instant startTime = this.timeSource.now();
                lock.acquireOwnership(lockType, transactionHandle).get(this.acquireTimeout.minus(totalTimeSpent).toMillis(), TimeUnit.MILLISECONDS).lock();
                totalTimeSpent = totalTimeSpent.plus(Duration.between(this.timeSource.now(), startTime));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                builder.releaseAll();
                throw new LockManager.TransactionExpiredException();
            }
        }
        return builder.build();
    }

    @Override
    public LockManager.TransactionEvidence lockForReads(long transactionHandle, ImmutableSet<K> additionalKeys) {
        return this.lock(LockRequest.LockType.READ, transactionHandle, additionalKeys);
    }

    @Override
    public LockManager.TransactionEvidence lockForCommit(long transactionHandle, ImmutableSet<K> additionalKeys) {
        return this.lock(LockRequest.LockType.COMMIT, transactionHandle, additionalKeys);
    }

    @VisibleForTesting
    Map<K, EntityLock> getLocks() {
        return this.locks;
    }

    static class TransactionEvidenceBuilder {
        final LockRequest.LockType lockType;
        final long transactionHandle;
        final Set<EntityLock> locksAcquired = Sets.newHashSet();

        TransactionEvidenceBuilder(LockRequest.LockType lockType, long transactionHandle) {
            this.lockType = lockType;
            this.transactionHandle = transactionHandle;
        }

        void addLock(EntityLock lock) {
            this.locksAcquired.add(lock);
        }

        void releaseAll() {
            for (EntityLock lock : this.locksAcquired) {
                lock.releaseLock(this.lockType, this.transactionHandle);
            }
        }

        LockManager.TransactionEvidence build() {
            return () -> {
                for (EntityLock lock : this.locksAcquired) {
                    switch (this.lockType) {
                        case READ: {
                            lock.unlockLock(LockRequest.LockType.READ, this.transactionHandle);
                            break;
                        }
                        case COMMIT: {
                            lock.releaseLock(LockRequest.LockType.COMMIT, this.transactionHandle);
                        }
                    }
                }
            };
        }
    }
}

