/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.util;

import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.emulator.impl.util.EntityReadResult;
import java.time.Instant;
import java.util.Optional;

final class AutoValue_EntityReadResult
extends EntityReadResult {
    private final EntityRef ref;
    private final Optional<Entity> entity;
    private final Optional<Instant> createdAt;
    private final Instant updatedAt;
    private final Instant readAt;

    private AutoValue_EntityReadResult(EntityRef ref, Optional<Entity> entity, Optional<Instant> createdAt, Instant updatedAt, Instant readAt) {
        this.ref = ref;
        this.entity = entity;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.readAt = readAt;
    }

    @Override
    public EntityRef ref() {
        return this.ref;
    }

    @Override
    public Optional<Entity> entity() {
        return this.entity;
    }

    @Override
    public Optional<Instant> createdAt() {
        return this.createdAt;
    }

    @Override
    public Instant updatedAt() {
        return this.updatedAt;
    }

    @Override
    public Instant readAt() {
        return this.readAt;
    }

    public String toString() {
        String string = String.valueOf(this.ref);
        String string2 = String.valueOf(this.entity);
        String string3 = String.valueOf(this.createdAt);
        String string4 = String.valueOf(this.updatedAt);
        String string5 = String.valueOf(this.readAt);
        return new StringBuilder(64 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("EntityReadResult{ref=").append(string).append(", entity=").append(string2).append(", createdAt=").append(string3).append(", updatedAt=").append(string4).append(", readAt=").append(string5).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EntityReadResult) {
            EntityReadResult that = (EntityReadResult)o;
            return this.ref.equals(that.ref()) && this.entity.equals(that.entity()) && this.createdAt.equals(that.createdAt()) && this.updatedAt.equals(that.updatedAt()) && this.readAt.equals(that.readAt());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.ref.hashCode();
        h$ *= 1000003;
        h$ ^= this.entity.hashCode();
        h$ *= 1000003;
        h$ ^= this.createdAt.hashCode();
        h$ *= 1000003;
        h$ ^= this.updatedAt.hashCode();
        h$ *= 1000003;
        return h$ ^= this.readAt.hashCode();
    }

    @Override
    public EntityReadResult.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends EntityReadResult.Builder {
        private EntityRef ref;
        private Optional<Entity> entity = Optional.empty();
        private Optional<Instant> createdAt = Optional.empty();
        private Instant updatedAt;
        private Instant readAt;

        Builder() {
        }

        private Builder(EntityReadResult source) {
            this.ref = source.ref();
            this.entity = source.entity();
            this.createdAt = source.createdAt();
            this.updatedAt = source.updatedAt();
            this.readAt = source.readAt();
        }

        @Override
        public EntityReadResult.Builder ref(EntityRef ref) {
            if (ref == null) {
                throw new NullPointerException("Null ref");
            }
            this.ref = ref;
            return this;
        }

        @Override
        public EntityReadResult.Builder entity(Optional<Entity> entity) {
            if (entity == null) {
                throw new NullPointerException("Null entity");
            }
            this.entity = entity;
            return this;
        }

        @Override
        public EntityReadResult.Builder createdAt(Optional<Instant> createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("Null createdAt");
            }
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public EntityReadResult.Builder updatedAt(Instant updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("Null updatedAt");
            }
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public EntityReadResult.Builder readAt(Instant readAt) {
            if (readAt == null) {
                throw new NullPointerException("Null readAt");
            }
            this.readAt = readAt;
            return this;
        }

        @Override
        public EntityReadResult build() {
            String missing = "";
            if (this.ref == null) {
                missing = String.valueOf(missing).concat(" ref");
            }
            if (this.updatedAt == null) {
                missing = String.valueOf(missing).concat(" updatedAt");
            }
            if (this.readAt == null) {
                missing = String.valueOf(missing).concat(" readAt");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_EntityReadResult(this.ref, this.entity, this.createdAt, this.updatedAt, this.readAt);
        }
    }
}

