/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Set;

public final class BiSetMultimap<K, V> {
    private final SetMultimap<K, V> forward = HashMultimap.create();
    private final SetMultimap<V, K> reverse = HashMultimap.create();

    public ImmutableSet<V> getByKey(K key) {
        return ImmutableSet.copyOf(this.forward.get((Object)key));
    }

    public ImmutableSet<K> getByValue(V value) {
        return ImmutableSet.copyOf(this.reverse.get((Object)value));
    }

    public ImmutableSet<V> getByKeys(Set<K> keys) {
        return keys.stream().flatMap(key -> this.forward.get(key).stream()).collect(ImmutableSet.toImmutableSet());
    }

    public ImmutableSet<K> getByValues(Set<V> values) {
        return values.stream().flatMap(value -> this.reverse.get(value).stream()).collect(ImmutableSet.toImmutableSet());
    }

    public void addEntry(K key, V value) {
        this.forward.put(key, value);
        this.reverse.put(value, key);
    }

    public void addKeysByValue(V value, Set<K> keys) {
        for (K key : keys) {
            this.addEntry(key, value);
        }
    }

    public ImmutableSet<V> removeByKey(K key) {
        Collection removedValues = this.forward.removeAll(key);
        for (Object value : removedValues) {
            this.reverse.remove(value, key);
        }
        return ImmutableSet.copyOf(removedValues);
    }

    public ImmutableSet<K> removeByValue(V value) {
        Collection removedKeys = this.reverse.removeAll(value);
        for (Object key : removedKeys) {
            this.forward.remove(key, value);
        }
        return ImmutableSet.copyOf(removedKeys);
    }
}

