/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.util;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.Condition;
import com.google.cloud.datastore.core.rep.ConditionVisitor;
import com.google.cloud.datastore.emulator.impl.util.AutoValue_ConditionVisitorBuilder_ConditionMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.function.Consumer;

public final class ConditionVisitorBuilder {
    private static final ImmutableSet<Condition.Op> ALL_OPS = ImmutableSet.copyOf(Condition.Op.values());
    private final ImmutableList.Builder<ConditionMatcher<?>> matchers = ImmutableList.builder();
    private Consumer<Condition> catchall = c -> {};

    public <T extends Condition> ConditionVisitorBuilder match(Class<T> clazz, Consumer<T> consumer) {
        this.matchers.add((Object)ConditionMatcher.of(clazz, ALL_OPS, consumer));
        return this;
    }

    public <T extends Condition> ConditionVisitorBuilder match(Class<T> clazz, Iterable<Condition.Op> ops, Consumer<T> consumer) {
        this.matchers.add((Object)ConditionMatcher.of(clazz, ImmutableSet.copyOf(ops), consumer));
        return this;
    }

    public <T extends Condition> ConditionVisitorBuilder match(Class<T> clazz, Condition.Op op, Consumer<T> consumer) {
        this.matchers.add((Object)ConditionMatcher.of(clazz, ImmutableSet.of(op), consumer));
        return this;
    }

    public ConditionVisitorBuilder orElse(Consumer<Condition> consumer) {
        this.catchall = consumer;
        return this;
    }

    public ConditionVisitor build() {
        return new ConditionVisitorImpl((ImmutableList)this.matchers.build(), this.catchall);
    }

    @AutoValue
    static abstract class ConditionMatcher<T extends Condition> {
        ConditionMatcher() {
        }

        abstract Class<T> clazz();

        abstract ImmutableSet<Condition.Op> ops();

        abstract Consumer<T> consumer();

        static <T extends Condition> ConditionMatcher<T> of(Class<T> clazz, ImmutableSet<Condition.Op> ops, Consumer<T> consumer) {
            return new AutoValue_ConditionVisitorBuilder_ConditionMatcher<T>(clazz, ops, consumer);
        }

        boolean match(Condition condition) {
            if (this.ops().contains((Object)condition.op()) && this.clazz().isAssignableFrom(condition.getClass())) {
                this.consumer().accept((Condition)this.clazz().cast(condition));
                return true;
            }
            return false;
        }
    }

    private static final class ConditionVisitorImpl
    extends ConditionVisitor {
        private final ImmutableList<ConditionMatcher<?>> matchers;
        private final Consumer<Condition> catchall;

        private ConditionVisitorImpl(ImmutableList<ConditionMatcher<?>> matchers, Consumer<Condition> catchall) {
            this.matchers = matchers;
            this.catchall = catchall;
        }

        @Override
        protected boolean visit(Condition condition) {
            for (ConditionMatcher conditionMatcher : this.matchers) {
                if (!conditionMatcher.match(condition)) continue;
                return false;
            }
            this.catchall.accept(condition);
            return false;
        }
    }
}

