/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.util;

import com.google.cloud.datastore.core.index.firestore.FirestoreIndexValueComparator;
import com.google.cloud.datastore.core.index.firestore.ValueToFirestoreIndexValueConverter;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.common.collect.Comparators;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Comparator;

public class EmulatorComparators {
    private static final Comparator<OnestoreEntity.Path.Element> MISMATCHED_ID_COMPARATOR = (p1, p2) -> {
        if (!p1.hasId() && p2.hasId() && !p1.hasName()) {
            return -1;
        }
        if (!p2.hasId() && p1.hasId() && !p2.hasName()) {
            return 1;
        }
        if (p1.hasId() && !p2.hasId()) {
            return -1;
        }
        if (!p1.hasId() && p2.hasId()) {
            return 1;
        }
        return 0;
    };
    private static final Comparator<OnestoreEntity.Path.Element> ELEMENT_COMPARATOR = Comparator.comparing(e -> e.getType()).thenComparing(MISMATCHED_ID_COMPARATOR).thenComparing(e -> e.getId()).thenComparing(e -> e.getName());
    public static final Comparator<OnestoreEntity.Path> PATH_COMPARATOR = Comparator.comparing(p -> p.elements(), Comparators.lexicographical(ELEMENT_COMPARATOR));
    public static final Comparator<OnestoreEntity.Reference> KEY_COMPARATOR = Comparator.comparing(o -> o.getApp()).thenComparing(o -> o.getDatabaseId()).thenComparing(o -> o.getNameSpace()).thenComparing(o -> o.getPath(), PATH_COMPARATOR);
    public static final Comparator<OnestoreEntity.EntityProto> ENTITY_KEY_COMPARATOR = Comparator.comparing(value -> value.getKey(), KEY_COMPARATOR);
    public static final Comparator<EntityRef> ENTITY_REF_COMPARATOR = Comparator.comparing(ValueToFirestoreIndexValueConverter.DEFAULT::convertEntityRefIgnoreThreshold, FirestoreIndexValueComparator.INSTANCE);
}

