/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.util;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.appengv3.LocalTransactionConverter;
import com.google.cloud.datastore.core.appengv3.UserValueObfuscator;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3EntityFromRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3EntityToRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefFromRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefToRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ToRepConverter;
import com.google.cloud.datastore.core.appengv3.validator.EntityV3Validator;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import com.google.cloud.datastore.core.exception.CanonicalErrorCodeTranslator;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.exception.ProblemCode;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1AppIdResolver;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1EntityFromRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1EntityToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1KeystoreClient;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1PropertyPathToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1QueryToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ResourceNameParser;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ResourceRefFromRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ResourceRefToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1TransformationToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.NewFirestoreV1RequestToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.NewFirestoreV1ResponseFromRepConverter;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.order.FirestoreValueOrder;
import com.google.cloud.datastore.core.rep.DatabaseIndexGroup;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.EntityRefProblem;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.core.rep.Write;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.cloud.datastore.core.rep.converter.PropertyPathToMaskConverter;
import com.google.cloud.datastore.core.rep.converter.UserIdObfuscator;
import com.google.cloud.datastore.core.rep.proto.QueryResumeToken;
import com.google.cloud.datastore.core.rep.validator.PropertyPathValidator;
import com.google.cloud.datastore.emulator.impl.util.EntityReadResult;
import com.google.cloud.datastore.internal.InternalHeader;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.GetOrListDocumentsRequest;
import com.google.firestore.v1.GetOrListDocumentsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.Target;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.WriteRequest;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.JavaTimeConversions;
import com.google.rpc.Status;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.time.Instant;
import javax.annotation.Nullable;

public final class FirestoreEmulatorConverters {
    private static final DatastoreCustomizableConfigPb.DatastoreCustomizableConfig CUSTOMIZABLE_CONFIG = null;
    private static final UserIdObfuscator NOOP_OBFUSCATOR = new UserIdObfuscator(){

        @Override
        public String obfuscate(long internalId) {
            return Long.toString(internalId);
        }

        @Override
        public long unobfuscate(String externalId) throws InvalidConversionException {
            return Long.parseLong(externalId);
        }
    };
    private static final FirestoreV1KeystoreClient TRIVIAL_KEYSTORE_CLIENT = new FirestoreV1KeystoreClient(){

        @Override
        public byte[] encrypt(QueryResumeToken token) throws DatastoreException {
            return token.toByteArray();
        }

        @Override
        public QueryResumeToken decryptQueryResumeToken(byte[] encrypted) throws DatastoreException {
            try {
                return QueryResumeToken.parseFrom(encrypted);
            }
            catch (InvalidProtocolBufferException e) {
                throw DatastoreException.builder().cause(e).build();
            }
        }
    };
    private final NewFirestoreV1RequestToRepConverter reqToRepConverter;
    private final NewFirestoreV1ResponseFromRepConverter responseFromRepConverter;
    private final FirestoreV1EntityToRepConverter entityToRepConverter;
    private final FirestoreV1EntityFromRepConverter entityFromRepConverter;
    private final FirestoreV1PropertyPathToRepConverter propertyPathToRepConverter;
    private final FirestoreV1ResourceRefToRepConverter resourceRefToRepConverter = new FirestoreV1ResourceRefToRepConverter(false, true);
    private final AppEngV3EntityFromRepConverter v3EntityFromRepConverter;
    private final AppEngV3EntityToRepConverter v3EntityToRepConverter;

    public static Status toStatus(DatastoreException exception) {
        return Status.newBuilder().setCode(CanonicalErrorCodeTranslator.getCanonicalCode(exception).getNumber()).setMessage(exception.getMessage()).build();
    }

    public static void checkMutation(Mutation mutation, boolean entityExists, long persistedVersion) throws DatastoreException {
        OnestoreEntity.Reference key = mutation.key();
        if (mutation.baseVersion() != null) {
            long baseVersion = mutation.baseVersion();
            if (baseVersion == 0L) {
                DatastoreExceptionHelper.checkRequest(mutation.op() != Mutation.Op.UPDATE, "Cannot update an entity with a base version set to zero: %s", key);
            } else {
                DatastoreExceptionHelper.checkRequest(mutation.op() != Mutation.Op.INSERT, "Cannot insert an entity with a base version greater than zero: %s", key);
            }
            if (entityExists && baseVersion > persistedVersion) {
                EntityRef ref = AppEngV3ResourceRefToRepConverter.convertValidEntityRef(key, CUSTOMIZABLE_CONFIG);
                throw DatastoreExceptionHelper.badRequest("Invalid base version, it is greater than the stored version: %s", key).withProblem(EntityRefProblem.create(ProblemCode.WRITE_PRECONDITION_FAILED_FUTURE_BASE_VERSION, ref));
            }
            if (mutation.conflictResolutionStrategy() == Mutation.ConflictResolutionStrategy.FAIL && mutation.conflictsWith(persistedVersion)) {
                throw DatastoreExceptionHelper.failedPrecondition("the stored version (%d) does not match the required base version (%d)", persistedVersion, baseVersion).withProblemCode(ProblemCode.WRITE_PRECONDITION_FAILED_PAST_BASE_VERSION);
            }
        }
        if (!entityExists) {
            if (mutation.op() == Mutation.Op.UPDATE || mutation.op() == Mutation.Op.DELETE_MUST_EXIST) {
                EntityRef ref = AppEngV3ResourceRefToRepConverter.convertValidEntityRef(key, CUSTOMIZABLE_CONFIG);
                throw DatastoreExceptionHelper.notFound("no entity to update: %s", key).withProblem(EntityRefProblem.create(ProblemCode.WRITE_PRECONDITION_FAILED_NOT_FOUND, ref));
            }
        } else {
            if (mutation.op() == Mutation.Op.DELETE_MUST_NOT_EXIST) {
                throw FirestoreEmulatorConverters.alreadyExists(key);
            }
            if (mutation.op() == Mutation.Op.INSERT) {
                if (!mutation.allocateKey()) {
                    throw FirestoreEmulatorConverters.alreadyExists(key);
                }
                if (!mutation.autoIdInserted()) {
                    throw FirestoreEmulatorConverters.insertAutoIdCollision(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, key);
                }
                throw FirestoreEmulatorConverters.insertAutoIdCollision(DatastoreV3Pb.Error.ErrorCode.INTERNAL_ERROR, key);
            }
        }
    }

    public static long toMicroseconds(Instant timestamp) {
        try {
            return ConverterHelper.timestampsToMicroseconds(JavaTimeConversions.toProtoTimestamp(timestamp));
        }
        catch (InvalidConversionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Instant toInstant(long microseconds) {
        try {
            Timestamp timestamp = ConverterHelper.microsecondsToTimestamp(microseconds);
            return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
        }
        catch (InvalidConversionException e) {
            throw new RuntimeException(e);
        }
    }

    public FirestoreEmulatorConverters(Config.DatastoreConfig config) {
        this.v3EntityFromRepConverter = new AppEngV3EntityFromRepConverter(new EntityV3Validator(Preconditions.checkNotNull(config), UserValueObfuscator.IDENTITY));
        AppEngV3ResourceRefToRepConverter v3ResourceRefToRepConverter = new AppEngV3ResourceRefToRepConverter(config);
        AppEngV3EntityToRepConverter appEngV3EntityToRepConverter = new AppEngV3EntityToRepConverter(config, UserValueObfuscator.IDENTITY, v3ResourceRefToRepConverter);
        this.entityToRepConverter = new FirestoreV1EntityToRepConverter(this.resourceRefToRepConverter, this.v3EntityFromRepConverter, NOOP_OBFUSCATOR);
        AppEngV3ToRepConverter v3ToRepConverter = new AppEngV3ToRepConverter(config, UserValueObfuscator.IDENTITY, v3ResourceRefToRepConverter, appEngV3EntityToRepConverter);
        FirestoreV1PropertyPathToRepConverter propertyPathToRepConverter = new FirestoreV1PropertyPathToRepConverter(new PropertyPathToMaskConverter(new PropertyPathValidator(Preconditions.checkNotNull(config))));
        FirestoreV1TransformationToRepConverter transformationToRepConverter = new FirestoreV1TransformationToRepConverter(FirestoreValueOrder.INSTANCE, propertyPathToRepConverter, this.entityToRepConverter, true);
        FirestoreV1QueryToRepConverter queryToRepConverter = new FirestoreV1QueryToRepConverter(propertyPathToRepConverter, this.entityToRepConverter, this.resourceRefToRepConverter);
        this.reqToRepConverter = new NewFirestoreV1RequestToRepConverter(this.entityToRepConverter, this.resourceRefToRepConverter, propertyPathToRepConverter, transformationToRepConverter, this.v3EntityFromRepConverter, v3ToRepConverter, queryToRepConverter, TRIVIAL_KEYSTORE_CLIENT);
        this.v3EntityToRepConverter = new AppEngV3EntityToRepConverter(Preconditions.checkNotNull(config), UserValueObfuscator.IDENTITY, new AppEngV3ResourceRefToRepConverter(Preconditions.checkNotNull(config)));
        this.entityFromRepConverter = new FirestoreV1EntityFromRepConverter(this.v3EntityToRepConverter);
        this.responseFromRepConverter = new NewFirestoreV1ResponseFromRepConverter(this.entityFromRepConverter, FirestoreV1ResourceRefFromRepConverter.INSTANCE, TRIVIAL_KEYSTORE_CLIENT);
        this.propertyPathToRepConverter = new FirestoreV1PropertyPathToRepConverter(new PropertyPathToMaskConverter(new PropertyPathValidator(config)));
    }

    public OnestoreEntity.EntityProto entityToProto(Entity entity) {
        return this.v3EntityFromRepConverter.convertEntityUnchecked(entity);
    }

    public Entity protoToEntity(OnestoreEntity.EntityProto entityProto) {
        return this.v3EntityToRepConverter.convertEntityUnchecked(entityProto, CUSTOMIZABLE_CONFIG);
    }

    public Write toWrite(CreateDocumentRequest request) throws DatastoreException {
        if (!request.getDocument().getName().isEmpty()) {
            throw new ValidationException("document.name must not be set");
        }
        if (request.getCollectionId().isEmpty()) {
            throw new DatastoreException("collectionId is the empty string.", DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, null);
        }
        return this.reqToRepConverter.toWrite(InternalHeader.ApiVersion.FIRESTORE_V1, ProjectIdAppIdResolver.IDENTITY, DatabaseIndexGroup.NO_INDEXES, request);
    }

    public Write toWrite(UpdateDocumentRequest request) throws DatastoreException {
        return this.reqToRepConverter.toWrite(InternalHeader.ApiVersion.FIRESTORE_V1, ProjectIdAppIdResolver.IDENTITY, DatabaseIndexGroup.NO_INDEXES, request);
    }

    public Write toWrite(DeleteDocumentRequest request) throws InvalidConversionException {
        return this.reqToRepConverter.toWrite(ProjectIdAppIdResolver.IDENTITY, request);
    }

    public Write toWrite(CommitRequest request, Timestamp requestTime) throws InvalidConversionException {
        return this.reqToRepConverter.toWrite(InternalHeader.ApiVersion.FIRESTORE_V1, ProjectIdAppIdResolver.IDENTITY, DatabaseIndexGroup.NO_INDEXES, request, requestTime);
    }

    public Write toWrite(WriteRequest writeRequest, Timestamp requestTime) throws InvalidConversionException {
        return this.toWrite(CommitRequest.newBuilder().setDatabase(writeRequest.getDatabase()).addAllWrites(writeRequest.getWritesList()).build(), requestTime);
    }

    public Lookup toLookup(GetDocumentRequest request) throws InvalidConversionException {
        return this.reqToRepConverter.toLookup(InternalHeader.ApiVersion.FIRESTORE_V1, ProjectIdAppIdResolver.IDENTITY, request);
    }

    public Lookup toLookup(BatchGetDocumentsRequest request) throws InvalidConversionException {
        return this.reqToRepConverter.toStreamingBatchGetLookup(InternalHeader.ApiVersion.FIRESTORE_V1, FirestoreV1AppIdResolver.IDENTITY, request);
    }

    public Query toListDocumentsQuery(ListDocumentsRequest request) throws DatastoreException {
        return this.reqToRepConverter.toListDocumentsQuery(InternalHeader.ApiVersion.FIRESTORE_V1BETA1, FirestoreV1AppIdResolver.IDENTITY, request, 0L);
    }

    public Query toQuery(RunQueryRequest request, long newTransactionId) throws DatastoreException {
        return this.reqToRepConverter.toQuery(InternalHeader.ApiVersion.FIRESTORE_V1BETA1, FirestoreV1AppIdResolver.IDENTITY, request, newTransactionId);
    }

    public Query toQuery(Target.QueryTarget queryTarget) throws DatastoreException {
        return this.reqToRepConverter.toQuery(InternalHeader.ApiVersion.FIRESTORE_V1BETA1, FirestoreV1AppIdResolver.IDENTITY, queryTarget.getParent(), queryTarget.getStructuredQuery());
    }

    public static EntityRef toEntityRef(OnestoreEntity.Reference key) {
        return AppEngV3ResourceRefToRepConverter.convertValidEntityRef(key, CUSTOMIZABLE_CONFIG);
    }

    public EntityRef toEntityRef(String documentName) throws InvalidConversionException {
        return this.resourceRefToRepConverter.convertEntityRefServiceRelative(ProjectIdAppIdResolver.IDENTITY, documentName);
    }

    public EntityRef toEntityRef(CreateDocumentRequest request) throws DatastoreException {
        return this.reqToRepConverter.constructNewEntityRef(InternalHeader.ApiVersion.FIRESTORE_V1, ProjectIdAppIdResolver.IDENTITY, request);
    }

    public static OnestoreEntity.Reference toReference(EntityRef ref) {
        return AppEngV3ResourceRefFromRepConverter.INSTANCE.convertEntityRef(ref);
    }

    public static String toDocumentName(EntityRef ref) throws InvalidConversionException {
        return FirestoreV1ResourceRefFromRepConverter.INSTANCE.convertEntityRefServiceRelative(ref);
    }

    public EntityRef parseParent(String parentName) throws DatastoreException {
        return this.reqToRepConverter.parseParent(InternalHeader.ApiVersion.FIRESTORE_V1BETA1, FirestoreV1AppIdResolver.IDENTITY, parentName);
    }

    public Document toDocument(ReadResult readResult) {
        try {
            return this.entityFromRepConverter.convertEntityProtoToDocument(readResult.entity(), readResult.createVersion(), readResult.updateVersion(), CUSTOMIZABLE_CONFIG);
        }
        catch (InvalidConversionException e) {
            throw new IllegalStateException(e);
        }
    }

    public DatabaseRef toDatabaseRef(String resourceName) throws InvalidConversionException {
        FirestoreV1ResourceNameParser parser = new FirestoreV1ResourceNameParser(false, "Database Name", resourceName);
        return this.resourceRefToRepConverter.parseDatabaseRef(ProjectIdAppIdResolver.IDENTITY, parser);
    }

    public ByteString toTransactionBytes(long handle) {
        return new LocalTransactionConverter().toTransactionBytes(handle);
    }

    public BatchGetDocumentsResponse toBatchGetDocumentResponse(ReadResult readResult) {
        try {
            return this.responseFromRepConverter.toBatchGetDocumentsResponse(readResult, CUSTOMIZABLE_CONFIG);
        }
        catch (DatastoreException e) {
            throw new IllegalStateException(e);
        }
    }

    private static DatastoreException insertAutoIdCollision(DatastoreV3Pb.Error.ErrorCode errorCode, @Nullable OnestoreEntity.Reference key) {
        String string = String.valueOf(key != null ? key : "unknown key");
        String message = new StringBuilder(72 + String.valueOf(string).length()).append("the id allocated for a new entity was already in use, please try again: ").append(string).toString();
        return new DatastoreException(message, errorCode, null);
    }

    private static DatastoreException alreadyExists(OnestoreEntity.Reference key) {
        EntityRef ref = FirestoreEmulatorConverters.toEntityRef(key);
        return DatastoreExceptionHelper.alreadyExists("entity already exists: %s", key).withProblem(EntityRefProblem.create(ProblemCode.WRITE_PRECONDITION_FAILED_ALREADY_EXISTS, ref));
    }

    public ReadResult rowToReadResult(EntityReadResult result) {
        long version = FirestoreEmulatorConverters.toMicroseconds(result.updatedAt());
        long readVersion = FirestoreEmulatorConverters.toMicroseconds(result.readAt());
        return result.entity().map(e -> {
            long createVersion = FirestoreEmulatorConverters.toMicroseconds(result.createdAt().get());
            return ReadResult.create(this.entityToProto((Entity)e), null, createVersion, version, readVersion);
        }).orElseGet(() -> ReadResult.createMissing(FirestoreEmulatorConverters.toReference(result.ref()), version, readVersion));
    }

    @Nullable
    public ListDocumentsRequest toListDocumentsRequest(GetOrListDocumentsRequest request) {
        int numSlashes = CharMatcher.is('/').countIn(request.getName());
        if (numSlashes % 2 == 0) {
            return null;
        }
        int lastSlashIdx = request.getName().lastIndexOf(47);
        String parent = request.getName().substring(0, lastSlashIdx);
        String collectionId = request.getName().substring(lastSlashIdx + 1);
        return ListDocumentsRequest.newBuilder().setParent(parent).setCollectionId(collectionId).setMask(request.getMask()).setOrderBy(request.getOrderBy()).build();
    }

    public GetDocumentRequest toGetDocumentRequest(GetOrListDocumentsRequest request) {
        GetDocumentRequest.Builder builder = GetDocumentRequest.newBuilder();
        builder.setName(request.getName());
        if (request.hasMask()) {
            builder.setMask(request.getMask());
        }
        return builder.build();
    }

    public GetOrListDocumentsResponse toGetOrListDocumentsResponse(ListDocumentsResponse response) {
        return GetOrListDocumentsResponse.newBuilder().addAllDocuments(response.getDocumentsList()).build();
    }

    public GetOrListDocumentsResponse toGetOrListDocumentsResponse(Document document) {
        return GetOrListDocumentsResponse.newBuilder().setName(document.getName()).putAllFields(document.getFieldsMap()).setCreateTime(document.getCreateTime()).setUpdateTime(document.getUpdateTime()).build();
    }
}

