/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.util;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.emulator.impl.util.FirestoreEmulatorConverters;
import com.google.cloud.datastore.emulator.impl.util.StreamTransportClosedException;
import com.google.common.flogger.GoogleLogger;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;

public class WrappedStreamObserver<T>
implements StreamObserver<T> {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/cloud/datastore/emulator/impl/util/WrappedStreamObserver");
    private final StreamObserver<T> underlying;

    public WrappedStreamObserver(StreamObserver<T> underlying) {
        this.underlying = underlying;
    }

    @Override
    public void onNext(T value) {
        try {
            this.underlying.onNext(value);
        }
        catch (IllegalStateException closed) {
            throw new StreamTransportClosedException(closed);
        }
    }

    @Override
    public void onError(Throwable t) {
        ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(t)).withInjectedLogSite("com/google/cloud/datastore/emulator/impl/util/WrappedStreamObserver", "onError", 35, "WrappedStreamObserver.java")).log("operation failed.");
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/cloud/datastore/emulator/impl/util/WrappedStreamObserver", "onError", 36, "WrappedStreamObserver.java")).log("operation failed: %s", t.getMessage());
        if (t instanceof DatastoreException) {
            DatastoreException e = (DatastoreException)t;
            this.underlying.onError(new StatusException(Status.fromCodeValue(FirestoreEmulatorConverters.toStatus(e).getCode()).withDescription(e.getMessage())));
        } else {
            this.underlying.onError(t);
        }
    }

    @Override
    public void onCompleted() {
        this.underlying.onCompleted();
    }
}

