/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.watch;

import com.google.common.base.Preconditions;
import com.google.common.time.TimeSource;
import java.time.Duration;
import java.time.Instant;

public class IncreasingTimeSource
implements TimeSource {
    private final TimeSource timeSource;
    private final Duration offsetOnCollision;
    private Instant lastTime = null;

    public IncreasingTimeSource(TimeSource timeSource, Duration offsetOnCollision) {
        Preconditions.checkArgument(offsetOnCollision.toNanos() > 0L);
        this.timeSource = timeSource;
        this.offsetOnCollision = offsetOnCollision;
    }

    @Override
    public synchronized Instant now() {
        Instant now = this.timeSource.now();
        if (this.lastTime != null && !now.isAfter(this.lastTime)) {
            now = this.lastTime.plus(this.offsetOnCollision);
        }
        this.lastTime = now;
        return now;
    }
}

