/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.internal;

import com.google.apphosting.base.DatastorePb;
import com.google.cloud.datastore.internal.DatastoreInternalProto;
import com.google.cloud.datastore.internal.InternalHeaderOrBuilder;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MutableMessage;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilder;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class InternalHeader
extends GeneratedMessage
implements InternalHeaderOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    private int authOverrideCase_ = 0;
    private Object authOverride_;
    public static final int APP_SERVER_REQUESTING_APP_ID_FIELD_NUMBER = 2;
    private volatile Object appServerRequestingAppId_;
    public static final int RESOLVED_TARGET_APP_ID_FIELD_NUMBER = 13;
    private volatile Object resolvedTargetAppId_;
    public static final int REQUESTING_PROJECT_NUMBER_FIELD_NUMBER = 4;
    private volatile Object requestingProjectNumber_;
    public static final int REQUESTING_VERSION_ID_FIELD_NUMBER = 5;
    private volatile Object requestingVersionId_;
    public static final int API_SETTINGS_FIELD_NUMBER = 3;
    private DatastorePb.DatastoreApiSettings apiSettings_;
    public static final int TARGET_API_SETTINGS_FIELD_NUMBER = 15;
    private DatastorePb.DatastoreApiSettings targetApiSettings_;
    public static final int REQUESTING_API_SETTINGS_FIELD_NUMBER = 16;
    private DatastorePb.DatastoreApiSettings requestingApiSettings_;
    public static final int TRUSTED_FIELD_NUMBER = 6;
    private boolean trusted_;
    public static final int MARK_CHANGES_FIELD_NUMBER = 7;
    private boolean markChanges_;
    public static final int PREAUTHORIZATION_FIELD_NUMBER = 10;
    public static final int CLIENT_API_VERSION_FIELD_NUMBER = 11;
    private int clientApiVersion_;
    public static final int TAGS_FIELD_NUMBER = 12;
    private List<Integer> tags_;
    private static final Internal.ListAdapter.Converter<Integer, LogsTags> tags_converter_ = new Internal.ListAdapter.Converter<Integer, LogsTags>(){

        @Override
        public LogsTags convert(Integer from) {
            LogsTags result = LogsTags.forNumber(from);
            return result == null ? LogsTags.UNRECOGNIZED : result;
        }
    };
    private int tagsMemoizedSerializedSize;
    public static final int REQUEST_OPTIONS_FIELD_NUMBER = 14;
    private List<Integer> requestOptions_;
    private static final Internal.ListAdapter.Converter<Integer, DatastoreRequestOptions> requestOptions_converter_ = new Internal.ListAdapter.Converter<Integer, DatastoreRequestOptions>(){

        @Override
        public DatastoreRequestOptions convert(Integer from) {
            DatastoreRequestOptions result = DatastoreRequestOptions.forNumber(from);
            return result == null ? DatastoreRequestOptions.UNRECOGNIZED : result;
        }
    };
    private int requestOptionsMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final InternalHeader DEFAULT_INSTANCE = new InternalHeader();
    private static final Parser<InternalHeader> PARSER = new AbstractParser<InternalHeader>(){

        @Override
        public InternalHeader parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            if (usingExperimentalRuntime) {
                InternalHeader msg = new InternalHeader();
                msg.mergeFromInternal(input, extensionRegistry);
                msg.makeImmutableInternal();
                return msg;
            }
            return new InternalHeader(input, extensionRegistry);
        }
    };

    private InternalHeader(GeneratedMessage.Builder<?> builder) {
        super(builder);
    }

    private InternalHeader() {
        this.appServerRequestingAppId_ = "";
        this.resolvedTargetAppId_ = "";
        this.requestingProjectNumber_ = "";
        this.requestingVersionId_ = "";
        this.clientApiVersion_ = 0;
        this.tags_ = Collections.emptyList();
        this.requestOptions_ = Collections.emptyList();
    }

    @Override
    protected Object newInstance(GeneratedMessage.UnusedPrivateParameter unused) {
        return new InternalHeader();
    }

    @Override
    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private InternalHeader(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block24: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block24;
                    }
                    case 18: {
                        String s = input.readStringRequireUtf8();
                        this.appServerRequestingAppId_ = s;
                        continue block24;
                    }
                    case 26: {
                        DatastorePb.DatastoreApiSettings.Builder subBuilder = null;
                        if (this.apiSettings_ != null) {
                            subBuilder = this.apiSettings_.toBuilder();
                        }
                        this.apiSettings_ = (DatastorePb.DatastoreApiSettings)input.readMessage(DatastorePb.DatastoreApiSettings.parser(), extensionRegistry);
                        if (subBuilder == null) continue block24;
                        subBuilder.mergeFrom(this.apiSettings_);
                        this.apiSettings_ = subBuilder.buildPartial();
                        continue block24;
                    }
                    case 34: {
                        String s = input.readStringRequireUtf8();
                        this.requestingProjectNumber_ = s;
                        continue block24;
                    }
                    case 42: {
                        String s = input.readStringRequireUtf8();
                        this.requestingVersionId_ = s;
                        continue block24;
                    }
                    case 48: {
                        this.trusted_ = input.readBool();
                        continue block24;
                    }
                    case 56: {
                        this.markChanges_ = input.readBool();
                        continue block24;
                    }
                    case 80: {
                        int rawValue = input.readEnum();
                        this.authOverrideCase_ = 10;
                        this.authOverride_ = rawValue;
                        continue block24;
                    }
                    case 88: {
                        int rawValue;
                        this.clientApiVersion_ = rawValue = input.readEnum();
                        continue block24;
                    }
                    case 96: {
                        int rawValue = input.readEnum();
                        if ((mutable_bitField0_ & 0x800) == 0) {
                            this.tags_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= 0x800;
                        }
                        this.tags_.add(rawValue);
                        continue block24;
                    }
                    case 98: {
                        int rawValue;
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            rawValue = input.readEnum();
                            if ((mutable_bitField0_ & 0x800) == 0) {
                                this.tags_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= 0x800;
                            }
                            this.tags_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block24;
                    }
                    case 106: {
                        String s = input.readStringRequireUtf8();
                        this.resolvedTargetAppId_ = s;
                        continue block24;
                    }
                    case 112: {
                        int rawValue = input.readEnum();
                        if ((mutable_bitField0_ & 0x1000) == 0) {
                            this.requestOptions_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= 0x1000;
                        }
                        this.requestOptions_.add(rawValue);
                        continue block24;
                    }
                    case 114: {
                        int rawValue;
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            rawValue = input.readEnum();
                            if ((mutable_bitField0_ & 0x1000) == 0) {
                                this.requestOptions_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= 0x1000;
                            }
                            this.requestOptions_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block24;
                    }
                    case 122: {
                        DatastorePb.DatastoreApiSettings.Builder subBuilder = null;
                        if (this.targetApiSettings_ != null) {
                            subBuilder = this.targetApiSettings_.toBuilder();
                        }
                        this.targetApiSettings_ = (DatastorePb.DatastoreApiSettings)input.readMessage(DatastorePb.DatastoreApiSettings.parser(), extensionRegistry);
                        if (subBuilder == null) continue block24;
                        subBuilder.mergeFrom(this.targetApiSettings_);
                        this.targetApiSettings_ = subBuilder.buildPartial();
                        continue block24;
                    }
                    case 130: {
                        DatastorePb.DatastoreApiSettings.Builder subBuilder = null;
                        if (this.requestingApiSettings_ != null) {
                            subBuilder = this.requestingApiSettings_.toBuilder();
                        }
                        this.requestingApiSettings_ = (DatastorePb.DatastoreApiSettings)input.readMessage(DatastorePb.DatastoreApiSettings.parser(), extensionRegistry);
                        if (subBuilder == null) continue block24;
                        subBuilder.mergeFrom(this.requestingApiSettings_);
                        this.requestingApiSettings_ = subBuilder.buildPartial();
                        continue block24;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage(this);
        }
        finally {
            if ((mutable_bitField0_ & 0x800) != 0) {
                this.tags_ = Collections.unmodifiableList(this.tags_);
            }
            if ((mutable_bitField0_ & 0x1000) != 0) {
                this.requestOptions_ = Collections.unmodifiableList(this.requestOptions_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return DatastoreInternalProto.internal_static_cloud_datastore_internal_InternalHeader_descriptor;
    }

    @Override
    protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return DatastoreInternalProto.internal_static_cloud_datastore_internal_InternalHeader_fieldAccessorTable.ensureFieldAccessorsInitialized(InternalHeader.class, Builder.class);
    }

    @Override
    public AuthOverrideCase getAuthOverrideCase() {
        return AuthOverrideCase.forNumber(this.authOverrideCase_);
    }

    @Override
    public String getAppServerRequestingAppId() {
        Object ref = this.appServerRequestingAppId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.appServerRequestingAppId_ = s;
        return s;
    }

    @Override
    public ByteString getAppServerRequestingAppIdBytes() {
        Object ref = this.appServerRequestingAppId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.appServerRequestingAppId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getResolvedTargetAppId() {
        Object ref = this.resolvedTargetAppId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resolvedTargetAppId_ = s;
        return s;
    }

    @Override
    public ByteString getResolvedTargetAppIdBytes() {
        Object ref = this.resolvedTargetAppId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.resolvedTargetAppId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getRequestingProjectNumber() {
        Object ref = this.requestingProjectNumber_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.requestingProjectNumber_ = s;
        return s;
    }

    @Override
    public ByteString getRequestingProjectNumberBytes() {
        Object ref = this.requestingProjectNumber_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.requestingProjectNumber_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getRequestingVersionId() {
        Object ref = this.requestingVersionId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.requestingVersionId_ = s;
        return s;
    }

    @Override
    public ByteString getRequestingVersionIdBytes() {
        Object ref = this.requestingVersionId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.requestingVersionId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasApiSettings() {
        return this.apiSettings_ != null;
    }

    @Override
    public DatastorePb.DatastoreApiSettings getApiSettings() {
        return this.apiSettings_ == null ? DatastorePb.DatastoreApiSettings.getDefaultInstance() : this.apiSettings_;
    }

    @Override
    public DatastorePb.DatastoreApiSettingsOrBuilder getApiSettingsOrBuilder() {
        return this.getApiSettings();
    }

    @Override
    public boolean hasTargetApiSettings() {
        return this.targetApiSettings_ != null;
    }

    @Override
    public DatastorePb.DatastoreApiSettings getTargetApiSettings() {
        return this.targetApiSettings_ == null ? DatastorePb.DatastoreApiSettings.getDefaultInstance() : this.targetApiSettings_;
    }

    @Override
    public DatastorePb.DatastoreApiSettingsOrBuilder getTargetApiSettingsOrBuilder() {
        return this.getTargetApiSettings();
    }

    @Override
    public boolean hasRequestingApiSettings() {
        return this.requestingApiSettings_ != null;
    }

    @Override
    public DatastorePb.DatastoreApiSettings getRequestingApiSettings() {
        return this.requestingApiSettings_ == null ? DatastorePb.DatastoreApiSettings.getDefaultInstance() : this.requestingApiSettings_;
    }

    @Override
    public DatastorePb.DatastoreApiSettingsOrBuilder getRequestingApiSettingsOrBuilder() {
        return this.getRequestingApiSettings();
    }

    @Override
    public boolean getTrusted() {
        return this.trusted_;
    }

    @Override
    public boolean getMarkChanges() {
        return this.markChanges_;
    }

    @Override
    public int getPreauthorizationValue() {
        if (this.authOverrideCase_ == 10) {
            return (Integer)this.authOverride_;
        }
        return 0;
    }

    @Override
    public Preauthorization getPreauthorization() {
        if (this.authOverrideCase_ == 10) {
            Preauthorization result = Preauthorization.forNumber((Integer)this.authOverride_);
            return result == null ? Preauthorization.UNRECOGNIZED : result;
        }
        return Preauthorization.NOT_PREAUTHORIZED;
    }

    @Override
    public int getClientApiVersionValue() {
        return this.clientApiVersion_;
    }

    @Override
    public ApiVersion getClientApiVersion() {
        ApiVersion result = ApiVersion.forNumber(this.clientApiVersion_);
        return result == null ? ApiVersion.UNRECOGNIZED : result;
    }

    @Override
    public List<LogsTags> getTagsList() {
        return new Internal.ListAdapter<Integer, LogsTags>(this.tags_, tags_converter_);
    }

    @Override
    public int getTagsCount() {
        return this.tags_.size();
    }

    @Override
    public LogsTags getTags(int index) {
        return tags_converter_.convert(this.tags_.get(index));
    }

    @Override
    public List<Integer> getTagsValueList() {
        return this.tags_;
    }

    @Override
    public int getTagsValue(int index) {
        return this.tags_.get(index);
    }

    @Override
    public List<DatastoreRequestOptions> getRequestOptionsList() {
        return new Internal.ListAdapter<Integer, DatastoreRequestOptions>(this.requestOptions_, requestOptions_converter_);
    }

    @Override
    public int getRequestOptionsCount() {
        return this.requestOptions_.size();
    }

    @Override
    public DatastoreRequestOptions getRequestOptions(int index) {
        return requestOptions_converter_.convert(this.requestOptions_.get(index));
    }

    @Override
    public List<Integer> getRequestOptionsValueList() {
        return this.requestOptions_;
    }

    @Override
    public int getRequestOptionsValue(int index) {
        return this.requestOptions_.get(index);
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (usingExperimentalRuntime) {
            this.writeToInternal(output);
            return;
        }
        this.getSerializedSize();
        if (!this.getAppServerRequestingAppIdBytes().isEmpty()) {
            GeneratedMessage.writeString(output, 2, this.appServerRequestingAppId_);
        }
        if (this.apiSettings_ != null) {
            output.writeMessage(3, (MessageLite)this.getApiSettings());
        }
        if (!this.getRequestingProjectNumberBytes().isEmpty()) {
            GeneratedMessage.writeString(output, 4, this.requestingProjectNumber_);
        }
        if (!this.getRequestingVersionIdBytes().isEmpty()) {
            GeneratedMessage.writeString(output, 5, this.requestingVersionId_);
        }
        if (this.trusted_) {
            output.writeBool(6, this.trusted_);
        }
        if (this.markChanges_) {
            output.writeBool(7, this.markChanges_);
        }
        if (this.authOverrideCase_ == 10) {
            output.writeEnum(10, (Integer)this.authOverride_);
        }
        if (this.clientApiVersion_ != ApiVersion.API_VERSION_UNSPECIFIED.getNumber()) {
            output.writeEnum(11, this.clientApiVersion_);
        }
        if (this.getTagsList().size() > 0) {
            output.writeUInt32NoTag(98);
            output.writeUInt32NoTag(this.tagsMemoizedSerializedSize);
        }
        for (i = 0; i < this.tags_.size(); ++i) {
            output.writeEnumNoTag(this.tags_.get(i));
        }
        if (!this.getResolvedTargetAppIdBytes().isEmpty()) {
            GeneratedMessage.writeString(output, 13, this.resolvedTargetAppId_);
        }
        if (this.getRequestOptionsList().size() > 0) {
            output.writeUInt32NoTag(114);
            output.writeUInt32NoTag(this.requestOptionsMemoizedSerializedSize);
        }
        for (i = 0; i < this.requestOptions_.size(); ++i) {
            output.writeEnumNoTag(this.requestOptions_.get(i));
        }
        if (this.targetApiSettings_ != null) {
            output.writeMessage(15, (MessageLite)this.getTargetApiSettings());
        }
        if (this.requestingApiSettings_ != null) {
            output.writeMessage(16, (MessageLite)this.getRequestingApiSettings());
        }
        this.unknownFields.writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        if (usingExperimentalRuntime) {
            this.memoizedSize = this.getSerializedSizeInternal();
            return this.memoizedSize;
        }
        size = 0;
        if (!this.getAppServerRequestingAppIdBytes().isEmpty()) {
            size += GeneratedMessage.computeStringSize(2, this.appServerRequestingAppId_);
        }
        if (this.apiSettings_ != null) {
            size += CodedOutputStream.computeMessageSize(3, (MessageLite)this.getApiSettings());
        }
        if (!this.getRequestingProjectNumberBytes().isEmpty()) {
            size += GeneratedMessage.computeStringSize(4, this.requestingProjectNumber_);
        }
        if (!this.getRequestingVersionIdBytes().isEmpty()) {
            size += GeneratedMessage.computeStringSize(5, this.requestingVersionId_);
        }
        if (this.trusted_) {
            size += CodedOutputStream.computeBoolSize(6, this.trusted_);
        }
        if (this.markChanges_) {
            size += CodedOutputStream.computeBoolSize(7, this.markChanges_);
        }
        if (this.authOverrideCase_ == 10) {
            size += CodedOutputStream.computeEnumSize(10, (Integer)this.authOverride_);
        }
        if (this.clientApiVersion_ != ApiVersion.API_VERSION_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize(11, this.clientApiVersion_);
        }
        int dataSize = 0;
        for (i = 0; i < this.tags_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag(this.tags_.get(i));
        }
        size += dataSize;
        if (!this.getTagsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        this.tagsMemoizedSerializedSize = dataSize;
        if (!this.getResolvedTargetAppIdBytes().isEmpty()) {
            size += GeneratedMessage.computeStringSize(13, this.resolvedTargetAppId_);
        }
        dataSize = 0;
        for (i = 0; i < this.requestOptions_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag(this.requestOptions_.get(i));
        }
        size += dataSize;
        if (!this.getRequestOptionsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        this.requestOptionsMemoizedSerializedSize = dataSize;
        if (this.targetApiSettings_ != null) {
            size += CodedOutputStream.computeMessageSize(15, (MessageLite)this.getTargetApiSettings());
        }
        if (this.requestingApiSettings_ != null) {
            size += CodedOutputStream.computeMessageSize(16, (MessageLite)this.getRequestingApiSettings());
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InternalHeader)) {
            return super.equals(obj);
        }
        InternalHeader other = (InternalHeader)obj;
        if (!this.getAppServerRequestingAppId().equals(other.getAppServerRequestingAppId())) {
            return false;
        }
        if (!this.getResolvedTargetAppId().equals(other.getResolvedTargetAppId())) {
            return false;
        }
        if (!this.getRequestingProjectNumber().equals(other.getRequestingProjectNumber())) {
            return false;
        }
        if (!this.getRequestingVersionId().equals(other.getRequestingVersionId())) {
            return false;
        }
        if (this.hasApiSettings() != other.hasApiSettings()) {
            return false;
        }
        if (this.hasApiSettings() && !this.getApiSettings().equals((Object)other.getApiSettings())) {
            return false;
        }
        if (this.hasTargetApiSettings() != other.hasTargetApiSettings()) {
            return false;
        }
        if (this.hasTargetApiSettings() && !this.getTargetApiSettings().equals((Object)other.getTargetApiSettings())) {
            return false;
        }
        if (this.hasRequestingApiSettings() != other.hasRequestingApiSettings()) {
            return false;
        }
        if (this.hasRequestingApiSettings() && !this.getRequestingApiSettings().equals((Object)other.getRequestingApiSettings())) {
            return false;
        }
        if (this.getTrusted() != other.getTrusted()) {
            return false;
        }
        if (this.getMarkChanges() != other.getMarkChanges()) {
            return false;
        }
        if (this.clientApiVersion_ != other.clientApiVersion_) {
            return false;
        }
        if (!this.tags_.equals(other.tags_)) {
            return false;
        }
        if (!this.requestOptions_.equals(other.requestOptions_)) {
            return false;
        }
        if (!this.getAuthOverrideCase().equals(other.getAuthOverrideCase())) {
            return false;
        }
        switch (this.authOverrideCase_) {
            case 10: {
                if (this.getPreauthorizationValue() == other.getPreauthorizationValue()) break;
                return false;
            }
        }
        return this.unknownFields.equals(other.unknownFields);
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + InternalHeader.getDescriptor().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getAppServerRequestingAppId().hashCode();
        hash = 37 * hash + 13;
        hash = 53 * hash + this.getResolvedTargetAppId().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getRequestingProjectNumber().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getRequestingVersionId().hashCode();
        if (this.hasApiSettings()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getApiSettings().hashCode();
        }
        if (this.hasTargetApiSettings()) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getTargetApiSettings().hashCode();
        }
        if (this.hasRequestingApiSettings()) {
            hash = 37 * hash + 16;
            hash = 53 * hash + this.getRequestingApiSettings().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + Internal.hashBoolean(this.getTrusted());
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashBoolean(this.getMarkChanges());
        hash = 37 * hash + 11;
        hash = 53 * hash + this.clientApiVersion_;
        if (this.getTagsCount() > 0) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.tags_.hashCode();
        }
        if (this.getRequestOptionsCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.requestOptions_.hashCode();
        }
        switch (this.authOverrideCase_) {
            case 10: {
                hash = 37 * hash + 10;
                hash = 53 * hash + this.getPreauthorizationValue();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    @Override
    protected MutableMessage internalMutableDefault() {
        return MutableDefaultLoader.get();
    }

    public static InternalHeader parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static InternalHeader parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static InternalHeader parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static InternalHeader parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static InternalHeader parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static InternalHeader parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static InternalHeader parseFrom(InputStream input) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static InternalHeader parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static InternalHeader parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static InternalHeader parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static InternalHeader parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static InternalHeader parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return InternalHeader.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InternalHeader prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static InternalHeader getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<InternalHeader> parser() {
        return PARSER;
    }

    public Parser<InternalHeader> getParserForType() {
        return PARSER;
    }

    @Override
    public InternalHeader getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessage.Builder<Builder>
    implements InternalHeaderOrBuilder {
        private int authOverrideCase_ = 0;
        private Object authOverride_;
        private int bitField0_;
        private Object appServerRequestingAppId_ = "";
        private Object resolvedTargetAppId_ = "";
        private Object requestingProjectNumber_ = "";
        private Object requestingVersionId_ = "";
        private DatastorePb.DatastoreApiSettings apiSettings_;
        private SingleFieldBuilder<DatastorePb.DatastoreApiSettings, DatastorePb.DatastoreApiSettings.Builder, DatastorePb.DatastoreApiSettingsOrBuilder> apiSettingsBuilder_;
        private DatastorePb.DatastoreApiSettings targetApiSettings_;
        private SingleFieldBuilder<DatastorePb.DatastoreApiSettings, DatastorePb.DatastoreApiSettings.Builder, DatastorePb.DatastoreApiSettingsOrBuilder> targetApiSettingsBuilder_;
        private DatastorePb.DatastoreApiSettings requestingApiSettings_;
        private SingleFieldBuilder<DatastorePb.DatastoreApiSettings, DatastorePb.DatastoreApiSettings.Builder, DatastorePb.DatastoreApiSettingsOrBuilder> requestingApiSettingsBuilder_;
        private boolean trusted_;
        private boolean markChanges_;
        private int clientApiVersion_ = 0;
        private List<Integer> tags_ = Collections.emptyList();
        private List<Integer> requestOptions_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return DatastoreInternalProto.internal_static_cloud_datastore_internal_InternalHeader_descriptor;
        }

        @Override
        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return DatastoreInternalProto.internal_static_cloud_datastore_internal_InternalHeader_fieldAccessorTable.ensureFieldAccessorsInitialized(InternalHeader.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessage.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        @Override
        public Builder clear() {
            super.clear();
            this.appServerRequestingAppId_ = "";
            this.resolvedTargetAppId_ = "";
            this.requestingProjectNumber_ = "";
            this.requestingVersionId_ = "";
            if (this.apiSettingsBuilder_ == null) {
                this.apiSettings_ = null;
            } else {
                this.apiSettings_ = null;
                this.apiSettingsBuilder_ = null;
            }
            if (this.targetApiSettingsBuilder_ == null) {
                this.targetApiSettings_ = null;
            } else {
                this.targetApiSettings_ = null;
                this.targetApiSettingsBuilder_ = null;
            }
            if (this.requestingApiSettingsBuilder_ == null) {
                this.requestingApiSettings_ = null;
            } else {
                this.requestingApiSettings_ = null;
                this.requestingApiSettingsBuilder_ = null;
            }
            this.trusted_ = false;
            this.markChanges_ = false;
            this.clientApiVersion_ = 0;
            this.tags_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFF7FF;
            this.requestOptions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFEFFF;
            this.authOverrideCase_ = 0;
            this.authOverride_ = null;
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return DatastoreInternalProto.internal_static_cloud_datastore_internal_InternalHeader_descriptor;
        }

        @Override
        public InternalHeader getDefaultInstanceForType() {
            return InternalHeader.getDefaultInstance();
        }

        @Override
        public InternalHeader build() {
            InternalHeader result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public InternalHeader buildPartial() {
            InternalHeader result = new InternalHeader(this);
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            result.appServerRequestingAppId_ = this.appServerRequestingAppId_;
            result.resolvedTargetAppId_ = this.resolvedTargetAppId_;
            result.requestingProjectNumber_ = this.requestingProjectNumber_;
            result.requestingVersionId_ = this.requestingVersionId_;
            if (this.apiSettingsBuilder_ == null) {
                result.apiSettings_ = this.apiSettings_;
            } else {
                result.apiSettings_ = this.apiSettingsBuilder_.build();
            }
            if (this.targetApiSettingsBuilder_ == null) {
                result.targetApiSettings_ = this.targetApiSettings_;
            } else {
                result.targetApiSettings_ = this.targetApiSettingsBuilder_.build();
            }
            if (this.requestingApiSettingsBuilder_ == null) {
                result.requestingApiSettings_ = this.requestingApiSettings_;
            } else {
                result.requestingApiSettings_ = this.requestingApiSettingsBuilder_.build();
            }
            result.trusted_ = this.trusted_;
            result.markChanges_ = this.markChanges_;
            if (this.authOverrideCase_ == 10) {
                result.authOverride_ = this.authOverride_;
            }
            result.clientApiVersion_ = this.clientApiVersion_;
            if ((this.bitField0_ & 0x800) != 0) {
                this.tags_ = Collections.unmodifiableList(this.tags_);
                this.bitField0_ &= 0xFFFFF7FF;
            }
            result.tags_ = this.tags_;
            if ((this.bitField0_ & 0x1000) != 0) {
                this.requestOptions_ = Collections.unmodifiableList(this.requestOptions_);
                this.bitField0_ &= 0xFFFFEFFF;
            }
            result.requestOptions_ = this.requestOptions_;
            result.bitField0_ = to_bitField0_;
            result.authOverrideCase_ = this.authOverrideCase_;
            this.onBuilt();
            return result;
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof InternalHeader) {
                return this.mergeFrom((InternalHeader)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(InternalHeader other) {
            if (other == InternalHeader.getDefaultInstance()) {
                return this;
            }
            if (!other.getAppServerRequestingAppId().isEmpty()) {
                this.appServerRequestingAppId_ = other.appServerRequestingAppId_;
                this.onChanged();
            }
            if (!other.getResolvedTargetAppId().isEmpty()) {
                this.resolvedTargetAppId_ = other.resolvedTargetAppId_;
                this.onChanged();
            }
            if (!other.getRequestingProjectNumber().isEmpty()) {
                this.requestingProjectNumber_ = other.requestingProjectNumber_;
                this.onChanged();
            }
            if (!other.getRequestingVersionId().isEmpty()) {
                this.requestingVersionId_ = other.requestingVersionId_;
                this.onChanged();
            }
            if (other.hasApiSettings()) {
                this.mergeApiSettings(other.getApiSettings());
            }
            if (other.hasTargetApiSettings()) {
                this.mergeTargetApiSettings(other.getTargetApiSettings());
            }
            if (other.hasRequestingApiSettings()) {
                this.mergeRequestingApiSettings(other.getRequestingApiSettings());
            }
            if (other.getTrusted()) {
                this.setTrusted(other.getTrusted());
            }
            if (other.getMarkChanges()) {
                this.setMarkChanges(other.getMarkChanges());
            }
            if (other.clientApiVersion_ != 0) {
                this.setClientApiVersionValue(other.getClientApiVersionValue());
            }
            if (!other.tags_.isEmpty()) {
                if (this.tags_.isEmpty()) {
                    this.tags_ = other.tags_;
                    this.bitField0_ &= 0xFFFFF7FF;
                } else {
                    this.ensureTagsIsMutable();
                    this.tags_.addAll(other.tags_);
                }
                this.onChanged();
            }
            if (!other.requestOptions_.isEmpty()) {
                if (this.requestOptions_.isEmpty()) {
                    this.requestOptions_ = other.requestOptions_;
                    this.bitField0_ &= 0xFFFFEFFF;
                } else {
                    this.ensureRequestOptionsIsMutable();
                    this.requestOptions_.addAll(other.requestOptions_);
                }
                this.onChanged();
            }
            switch (other.getAuthOverrideCase()) {
                case PREAUTHORIZATION: {
                    this.setPreauthorizationValue(other.getPreauthorizationValue());
                    break;
                }
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            InternalHeader parsedMessage = null;
            try {
                parsedMessage = (InternalHeader)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (InternalHeader)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public AuthOverrideCase getAuthOverrideCase() {
            return AuthOverrideCase.forNumber(this.authOverrideCase_);
        }

        public Builder clearAuthOverride() {
            this.authOverrideCase_ = 0;
            this.authOverride_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public String getAppServerRequestingAppId() {
            Object ref = this.appServerRequestingAppId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.appServerRequestingAppId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAppServerRequestingAppIdBytes() {
            Object ref = this.appServerRequestingAppId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.appServerRequestingAppId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAppServerRequestingAppId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.appServerRequestingAppId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearAppServerRequestingAppId() {
            this.appServerRequestingAppId_ = InternalHeader.getDefaultInstance().getAppServerRequestingAppId();
            this.onChanged();
            return this;
        }

        public Builder setAppServerRequestingAppIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InternalHeader.checkByteStringIsUtf8(value);
            this.appServerRequestingAppId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getResolvedTargetAppId() {
            Object ref = this.resolvedTargetAppId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resolvedTargetAppId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResolvedTargetAppIdBytes() {
            Object ref = this.resolvedTargetAppId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.resolvedTargetAppId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResolvedTargetAppId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resolvedTargetAppId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearResolvedTargetAppId() {
            this.resolvedTargetAppId_ = InternalHeader.getDefaultInstance().getResolvedTargetAppId();
            this.onChanged();
            return this;
        }

        public Builder setResolvedTargetAppIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InternalHeader.checkByteStringIsUtf8(value);
            this.resolvedTargetAppId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getRequestingProjectNumber() {
            Object ref = this.requestingProjectNumber_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.requestingProjectNumber_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRequestingProjectNumberBytes() {
            Object ref = this.requestingProjectNumber_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.requestingProjectNumber_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRequestingProjectNumber(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.requestingProjectNumber_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearRequestingProjectNumber() {
            this.requestingProjectNumber_ = InternalHeader.getDefaultInstance().getRequestingProjectNumber();
            this.onChanged();
            return this;
        }

        public Builder setRequestingProjectNumberBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InternalHeader.checkByteStringIsUtf8(value);
            this.requestingProjectNumber_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getRequestingVersionId() {
            Object ref = this.requestingVersionId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.requestingVersionId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRequestingVersionIdBytes() {
            Object ref = this.requestingVersionId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.requestingVersionId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRequestingVersionId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.requestingVersionId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearRequestingVersionId() {
            this.requestingVersionId_ = InternalHeader.getDefaultInstance().getRequestingVersionId();
            this.onChanged();
            return this;
        }

        public Builder setRequestingVersionIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InternalHeader.checkByteStringIsUtf8(value);
            this.requestingVersionId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasApiSettings() {
            return this.apiSettingsBuilder_ != null || this.apiSettings_ != null;
        }

        @Override
        public DatastorePb.DatastoreApiSettings getApiSettings() {
            if (this.apiSettingsBuilder_ == null) {
                return this.apiSettings_ == null ? DatastorePb.DatastoreApiSettings.getDefaultInstance() : this.apiSettings_;
            }
            return this.apiSettingsBuilder_.getMessage();
        }

        public Builder setApiSettings(DatastorePb.DatastoreApiSettings value) {
            if (this.apiSettingsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.apiSettings_ = value;
                this.onChanged();
            } else {
                this.apiSettingsBuilder_.setMessage(value);
            }
            return this;
        }

        public Builder setApiSettings(DatastorePb.DatastoreApiSettings.Builder builderForValue) {
            if (this.apiSettingsBuilder_ == null) {
                this.apiSettings_ = builderForValue.build();
                this.onChanged();
            } else {
                this.apiSettingsBuilder_.setMessage(builderForValue.build());
            }
            return this;
        }

        public Builder mergeApiSettings(DatastorePb.DatastoreApiSettings value) {
            if (this.apiSettingsBuilder_ == null) {
                this.apiSettings_ = this.apiSettings_ != null ? DatastorePb.DatastoreApiSettings.newBuilder((DatastorePb.DatastoreApiSettings)this.apiSettings_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.apiSettingsBuilder_.mergeFrom(value);
            }
            return this;
        }

        public Builder clearApiSettings() {
            if (this.apiSettingsBuilder_ == null) {
                this.apiSettings_ = null;
                this.onChanged();
            } else {
                this.apiSettings_ = null;
                this.apiSettingsBuilder_ = null;
            }
            return this;
        }

        public DatastorePb.DatastoreApiSettings.Builder getApiSettingsBuilder() {
            this.onChanged();
            return this.getApiSettingsFieldBuilder().getBuilder();
        }

        @Override
        public DatastorePb.DatastoreApiSettingsOrBuilder getApiSettingsOrBuilder() {
            if (this.apiSettingsBuilder_ != null) {
                return this.apiSettingsBuilder_.getMessageOrBuilder();
            }
            return this.apiSettings_ == null ? DatastorePb.DatastoreApiSettings.getDefaultInstance() : this.apiSettings_;
        }

        private SingleFieldBuilder<DatastorePb.DatastoreApiSettings, DatastorePb.DatastoreApiSettings.Builder, DatastorePb.DatastoreApiSettingsOrBuilder> getApiSettingsFieldBuilder() {
            if (this.apiSettingsBuilder_ == null) {
                this.apiSettingsBuilder_ = new SingleFieldBuilder(this.getApiSettings(), this.getParentForChildren(), this.isClean());
                this.apiSettings_ = null;
            }
            return this.apiSettingsBuilder_;
        }

        @Override
        public boolean hasTargetApiSettings() {
            return this.targetApiSettingsBuilder_ != null || this.targetApiSettings_ != null;
        }

        @Override
        public DatastorePb.DatastoreApiSettings getTargetApiSettings() {
            if (this.targetApiSettingsBuilder_ == null) {
                return this.targetApiSettings_ == null ? DatastorePb.DatastoreApiSettings.getDefaultInstance() : this.targetApiSettings_;
            }
            return this.targetApiSettingsBuilder_.getMessage();
        }

        public Builder setTargetApiSettings(DatastorePb.DatastoreApiSettings value) {
            if (this.targetApiSettingsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.targetApiSettings_ = value;
                this.onChanged();
            } else {
                this.targetApiSettingsBuilder_.setMessage(value);
            }
            return this;
        }

        public Builder setTargetApiSettings(DatastorePb.DatastoreApiSettings.Builder builderForValue) {
            if (this.targetApiSettingsBuilder_ == null) {
                this.targetApiSettings_ = builderForValue.build();
                this.onChanged();
            } else {
                this.targetApiSettingsBuilder_.setMessage(builderForValue.build());
            }
            return this;
        }

        public Builder mergeTargetApiSettings(DatastorePb.DatastoreApiSettings value) {
            if (this.targetApiSettingsBuilder_ == null) {
                this.targetApiSettings_ = this.targetApiSettings_ != null ? DatastorePb.DatastoreApiSettings.newBuilder((DatastorePb.DatastoreApiSettings)this.targetApiSettings_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.targetApiSettingsBuilder_.mergeFrom(value);
            }
            return this;
        }

        public Builder clearTargetApiSettings() {
            if (this.targetApiSettingsBuilder_ == null) {
                this.targetApiSettings_ = null;
                this.onChanged();
            } else {
                this.targetApiSettings_ = null;
                this.targetApiSettingsBuilder_ = null;
            }
            return this;
        }

        public DatastorePb.DatastoreApiSettings.Builder getTargetApiSettingsBuilder() {
            this.onChanged();
            return this.getTargetApiSettingsFieldBuilder().getBuilder();
        }

        @Override
        public DatastorePb.DatastoreApiSettingsOrBuilder getTargetApiSettingsOrBuilder() {
            if (this.targetApiSettingsBuilder_ != null) {
                return this.targetApiSettingsBuilder_.getMessageOrBuilder();
            }
            return this.targetApiSettings_ == null ? DatastorePb.DatastoreApiSettings.getDefaultInstance() : this.targetApiSettings_;
        }

        private SingleFieldBuilder<DatastorePb.DatastoreApiSettings, DatastorePb.DatastoreApiSettings.Builder, DatastorePb.DatastoreApiSettingsOrBuilder> getTargetApiSettingsFieldBuilder() {
            if (this.targetApiSettingsBuilder_ == null) {
                this.targetApiSettingsBuilder_ = new SingleFieldBuilder(this.getTargetApiSettings(), this.getParentForChildren(), this.isClean());
                this.targetApiSettings_ = null;
            }
            return this.targetApiSettingsBuilder_;
        }

        @Override
        public boolean hasRequestingApiSettings() {
            return this.requestingApiSettingsBuilder_ != null || this.requestingApiSettings_ != null;
        }

        @Override
        public DatastorePb.DatastoreApiSettings getRequestingApiSettings() {
            if (this.requestingApiSettingsBuilder_ == null) {
                return this.requestingApiSettings_ == null ? DatastorePb.DatastoreApiSettings.getDefaultInstance() : this.requestingApiSettings_;
            }
            return this.requestingApiSettingsBuilder_.getMessage();
        }

        public Builder setRequestingApiSettings(DatastorePb.DatastoreApiSettings value) {
            if (this.requestingApiSettingsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.requestingApiSettings_ = value;
                this.onChanged();
            } else {
                this.requestingApiSettingsBuilder_.setMessage(value);
            }
            return this;
        }

        public Builder setRequestingApiSettings(DatastorePb.DatastoreApiSettings.Builder builderForValue) {
            if (this.requestingApiSettingsBuilder_ == null) {
                this.requestingApiSettings_ = builderForValue.build();
                this.onChanged();
            } else {
                this.requestingApiSettingsBuilder_.setMessage(builderForValue.build());
            }
            return this;
        }

        public Builder mergeRequestingApiSettings(DatastorePb.DatastoreApiSettings value) {
            if (this.requestingApiSettingsBuilder_ == null) {
                this.requestingApiSettings_ = this.requestingApiSettings_ != null ? DatastorePb.DatastoreApiSettings.newBuilder((DatastorePb.DatastoreApiSettings)this.requestingApiSettings_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.requestingApiSettingsBuilder_.mergeFrom(value);
            }
            return this;
        }

        public Builder clearRequestingApiSettings() {
            if (this.requestingApiSettingsBuilder_ == null) {
                this.requestingApiSettings_ = null;
                this.onChanged();
            } else {
                this.requestingApiSettings_ = null;
                this.requestingApiSettingsBuilder_ = null;
            }
            return this;
        }

        public DatastorePb.DatastoreApiSettings.Builder getRequestingApiSettingsBuilder() {
            this.onChanged();
            return this.getRequestingApiSettingsFieldBuilder().getBuilder();
        }

        @Override
        public DatastorePb.DatastoreApiSettingsOrBuilder getRequestingApiSettingsOrBuilder() {
            if (this.requestingApiSettingsBuilder_ != null) {
                return this.requestingApiSettingsBuilder_.getMessageOrBuilder();
            }
            return this.requestingApiSettings_ == null ? DatastorePb.DatastoreApiSettings.getDefaultInstance() : this.requestingApiSettings_;
        }

        private SingleFieldBuilder<DatastorePb.DatastoreApiSettings, DatastorePb.DatastoreApiSettings.Builder, DatastorePb.DatastoreApiSettingsOrBuilder> getRequestingApiSettingsFieldBuilder() {
            if (this.requestingApiSettingsBuilder_ == null) {
                this.requestingApiSettingsBuilder_ = new SingleFieldBuilder(this.getRequestingApiSettings(), this.getParentForChildren(), this.isClean());
                this.requestingApiSettings_ = null;
            }
            return this.requestingApiSettingsBuilder_;
        }

        @Override
        public boolean getTrusted() {
            return this.trusted_;
        }

        public Builder setTrusted(boolean value) {
            this.trusted_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearTrusted() {
            this.trusted_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getMarkChanges() {
            return this.markChanges_;
        }

        public Builder setMarkChanges(boolean value) {
            this.markChanges_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearMarkChanges() {
            this.markChanges_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getPreauthorizationValue() {
            if (this.authOverrideCase_ == 10) {
                return (Integer)this.authOverride_;
            }
            return 0;
        }

        public Builder setPreauthorizationValue(int value) {
            this.authOverrideCase_ = 10;
            this.authOverride_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public Preauthorization getPreauthorization() {
            if (this.authOverrideCase_ == 10) {
                Preauthorization result = Preauthorization.forNumber((Integer)this.authOverride_);
                return result == null ? Preauthorization.UNRECOGNIZED : result;
            }
            return Preauthorization.NOT_PREAUTHORIZED;
        }

        public Builder setPreauthorization(Preauthorization value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.authOverrideCase_ = 10;
            this.authOverride_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPreauthorization() {
            if (this.authOverrideCase_ == 10) {
                this.authOverrideCase_ = 0;
                this.authOverride_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public int getClientApiVersionValue() {
            return this.clientApiVersion_;
        }

        public Builder setClientApiVersionValue(int value) {
            this.clientApiVersion_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public ApiVersion getClientApiVersion() {
            ApiVersion result = ApiVersion.forNumber(this.clientApiVersion_);
            return result == null ? ApiVersion.UNRECOGNIZED : result;
        }

        public Builder setClientApiVersion(ApiVersion value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.clientApiVersion_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearClientApiVersion() {
            this.clientApiVersion_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureTagsIsMutable() {
            if ((this.bitField0_ & 0x800) == 0) {
                this.tags_ = new ArrayList<Integer>(this.tags_);
                this.bitField0_ |= 0x800;
            }
        }

        @Override
        public List<LogsTags> getTagsList() {
            return new Internal.ListAdapter(this.tags_, tags_converter_);
        }

        @Override
        public int getTagsCount() {
            return this.tags_.size();
        }

        @Override
        public LogsTags getTags(int index) {
            return (LogsTags)tags_converter_.convert(this.tags_.get(index));
        }

        public Builder setTags(int index, LogsTags value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTagsIsMutable();
            this.tags_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addTags(LogsTags value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTagsIsMutable();
            this.tags_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllTags(Iterable<? extends LogsTags> values) {
            this.ensureTagsIsMutable();
            for (LogsTags logsTags : values) {
                this.tags_.add(logsTags.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearTags() {
            this.tags_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getTagsValueList() {
            return Collections.unmodifiableList(this.tags_);
        }

        @Override
        public int getTagsValue(int index) {
            return this.tags_.get(index);
        }

        public Builder setTagsValue(int index, int value) {
            this.ensureTagsIsMutable();
            this.tags_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addTagsValue(int value) {
            this.ensureTagsIsMutable();
            this.tags_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllTagsValue(Iterable<Integer> values) {
            this.ensureTagsIsMutable();
            for (int value : values) {
                this.tags_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureRequestOptionsIsMutable() {
            if ((this.bitField0_ & 0x1000) == 0) {
                this.requestOptions_ = new ArrayList<Integer>(this.requestOptions_);
                this.bitField0_ |= 0x1000;
            }
        }

        @Override
        public List<DatastoreRequestOptions> getRequestOptionsList() {
            return new Internal.ListAdapter(this.requestOptions_, requestOptions_converter_);
        }

        @Override
        public int getRequestOptionsCount() {
            return this.requestOptions_.size();
        }

        @Override
        public DatastoreRequestOptions getRequestOptions(int index) {
            return (DatastoreRequestOptions)requestOptions_converter_.convert(this.requestOptions_.get(index));
        }

        public Builder setRequestOptions(int index, DatastoreRequestOptions value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRequestOptionsIsMutable();
            this.requestOptions_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addRequestOptions(DatastoreRequestOptions value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRequestOptionsIsMutable();
            this.requestOptions_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllRequestOptions(Iterable<? extends DatastoreRequestOptions> values) {
            this.ensureRequestOptionsIsMutable();
            for (DatastoreRequestOptions datastoreRequestOptions : values) {
                this.requestOptions_.add(datastoreRequestOptions.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearRequestOptions() {
            this.requestOptions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFEFFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getRequestOptionsValueList() {
            return Collections.unmodifiableList(this.requestOptions_);
        }

        @Override
        public int getRequestOptionsValue(int index) {
            return this.requestOptions_.get(index);
        }

        public Builder setRequestOptionsValue(int index, int value) {
            this.ensureRequestOptionsIsMutable();
            this.requestOptions_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addRequestOptionsValue(int value) {
            this.ensureRequestOptionsIsMutable();
            this.requestOptions_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllRequestOptionsValue(Iterable<Integer> values) {
            this.ensureRequestOptionsIsMutable();
            for (int value : values) {
                this.requestOptions_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }
    }

    private static final class MutableDefaultLoader {
        private static final Object defaultOrRuntimeException;

        private MutableDefaultLoader() {
        }

        public static MutableMessage get() {
            if (defaultOrRuntimeException instanceof RuntimeException) {
                throw (RuntimeException)defaultOrRuntimeException;
            }
            return (MutableMessage)defaultOrRuntimeException;
        }

        static {
            Object local;
            try {
                local = InternalHeader.internalMutableDefault("com.google.cloud.datastore.internal.proto1api.InternalHeader");
            }
            catch (RuntimeException e) {
                local = e;
            }
            defaultOrRuntimeException = local;
        }
    }

    public static enum AuthOverrideCase implements Internal.EnumLite
    {
        PREAUTHORIZATION(10),
        AUTHOVERRIDE_NOT_SET(0);

        private final int value;

        private AuthOverrideCase(int value) {
            this.value = value;
        }

        public static AuthOverrideCase forNumber(int value) {
            switch (value) {
                case 10: {
                    return PREAUTHORIZATION;
                }
                case 0: {
                    return AUTHOVERRIDE_NOT_SET;
                }
            }
            return null;
        }

        @Override
        public int getNumber() {
            return this.value;
        }
    }

    public static enum DatastoreRequestOptions implements ProtocolMessageEnum
    {
        DATASTORE_REQUEST_OPTIONS_UNKNOWN(0),
        INCLUDES_COMPOSITE_INDEXES(1),
        UNRECOGNIZED(-1);

        public static final int DATASTORE_REQUEST_OPTIONS_UNKNOWN_VALUE = 0;
        public static final int INCLUDES_COMPOSITE_INDEXES_VALUE = 1;
        private static final Internal.EnumLiteMap<DatastoreRequestOptions> internalValueMap;
        private static final DatastoreRequestOptions[] VALUES;
        private final int value;

        @Override
        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        public static DatastoreRequestOptions forNumber(int value) {
            switch (value) {
                case 0: {
                    return DATASTORE_REQUEST_OPTIONS_UNKNOWN;
                }
                case 1: {
                    return INCLUDES_COMPOSITE_INDEXES;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<DatastoreRequestOptions> internalGetValueMap() {
            return internalValueMap;
        }

        @Override
        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            return DatastoreRequestOptions.getDescriptor().getValues().get(this.ordinal());
        }

        @Override
        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return DatastoreRequestOptions.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return InternalHeader.getDescriptor().getEnumTypes().get(3);
        }

        public static DatastoreRequestOptions valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != DatastoreRequestOptions.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private DatastoreRequestOptions(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<DatastoreRequestOptions>(){

                @Override
                public DatastoreRequestOptions findValueByNumber(int number) {
                    return DatastoreRequestOptions.forNumber(number);
                }
            };
            VALUES = DatastoreRequestOptions.values();
        }
    }

    public static enum LogsTags implements ProtocolMessageEnum
    {
        UNKNOWN(0),
        THIRD_PARTY(1),
        UNRECOGNIZED(-1);

        public static final int UNKNOWN_VALUE = 0;
        public static final int THIRD_PARTY_VALUE = 1;
        private static final Internal.EnumLiteMap<LogsTags> internalValueMap;
        private static final LogsTags[] VALUES;
        private final int value;

        @Override
        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        public static LogsTags forNumber(int value) {
            switch (value) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return THIRD_PARTY;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<LogsTags> internalGetValueMap() {
            return internalValueMap;
        }

        @Override
        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            return LogsTags.getDescriptor().getValues().get(this.ordinal());
        }

        @Override
        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return LogsTags.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return InternalHeader.getDescriptor().getEnumTypes().get(2);
        }

        public static LogsTags valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != LogsTags.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private LogsTags(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<LogsTags>(){

                @Override
                public LogsTags findValueByNumber(int number) {
                    return LogsTags.forNumber(number);
                }
            };
            VALUES = LogsTags.values();
        }
    }

    public static enum ApiVersion implements ProtocolMessageEnum
    {
        API_VERSION_UNSPECIFIED(0),
        V1BETA3(1),
        V1(2),
        FIRESTORE_V1ALPHA1(3),
        FIRESTORE_V1BETA1(4),
        FIRESTORE_V1(5),
        UNRECOGNIZED(-1);

        public static final int API_VERSION_UNSPECIFIED_VALUE = 0;
        public static final int V1BETA3_VALUE = 1;
        public static final int V1_VALUE = 2;
        public static final int FIRESTORE_V1ALPHA1_VALUE = 3;
        public static final int FIRESTORE_V1BETA1_VALUE = 4;
        public static final int FIRESTORE_V1_VALUE = 5;
        private static final Internal.EnumLiteMap<ApiVersion> internalValueMap;
        private static final ApiVersion[] VALUES;
        private final int value;

        @Override
        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        public static ApiVersion forNumber(int value) {
            switch (value) {
                case 0: {
                    return API_VERSION_UNSPECIFIED;
                }
                case 1: {
                    return V1BETA3;
                }
                case 2: {
                    return V1;
                }
                case 3: {
                    return FIRESTORE_V1ALPHA1;
                }
                case 4: {
                    return FIRESTORE_V1BETA1;
                }
                case 5: {
                    return FIRESTORE_V1;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ApiVersion> internalGetValueMap() {
            return internalValueMap;
        }

        @Override
        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            return ApiVersion.getDescriptor().getValues().get(this.ordinal());
        }

        @Override
        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ApiVersion.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return InternalHeader.getDescriptor().getEnumTypes().get(1);
        }

        public static ApiVersion valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ApiVersion.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ApiVersion(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ApiVersion>(){

                @Override
                public ApiVersion findValueByNumber(int number) {
                    return ApiVersion.forNumber(number);
                }
            };
            VALUES = ApiVersion.values();
        }
    }

    public static enum Preauthorization implements ProtocolMessageEnum
    {
        NOT_PREAUTHORIZED(0),
        PREAUTHORIZED(1),
        PREAUTHORIZED_LEGACY(2),
        PREAUTHORIZED_INTERNAL(3),
        UNRECOGNIZED(-1);

        public static final int NOT_PREAUTHORIZED_VALUE = 0;
        public static final int PREAUTHORIZED_VALUE = 1;
        public static final int PREAUTHORIZED_LEGACY_VALUE = 2;
        public static final int PREAUTHORIZED_INTERNAL_VALUE = 3;
        private static final Internal.EnumLiteMap<Preauthorization> internalValueMap;
        private static final Preauthorization[] VALUES;
        private final int value;

        @Override
        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        public static Preauthorization forNumber(int value) {
            switch (value) {
                case 0: {
                    return NOT_PREAUTHORIZED;
                }
                case 1: {
                    return PREAUTHORIZED;
                }
                case 2: {
                    return PREAUTHORIZED_LEGACY;
                }
                case 3: {
                    return PREAUTHORIZED_INTERNAL;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Preauthorization> internalGetValueMap() {
            return internalValueMap;
        }

        @Override
        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            return Preauthorization.getDescriptor().getValues().get(this.ordinal());
        }

        @Override
        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Preauthorization.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return InternalHeader.getDescriptor().getEnumTypes().get(0);
        }

        public static Preauthorization valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Preauthorization.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Preauthorization(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Preauthorization>(){

                @Override
                public Preauthorization findValueByNumber(int number) {
                    return Preauthorization.forNumber(number);
                }
            };
            VALUES = Preauthorization.values();
        }
    }
}

