/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Set;

@GoogleInternal
@GwtIncompatible
public abstract class AsyncCacheLoader<K, V> {
    protected AsyncCacheLoader() {
    }

    protected abstract ListenableFuture<V> load(K var1);

    protected Map<K, ListenableFuture<V>> loadAll(Set<? extends K> keys) {
        Preconditions.checkNotNull(keys);
        return ImmutableMap.of();
    }

    public static <K, V> AsyncCacheLoader<K, V> from(AsyncFunction<K, V> function) {
        return new AsyncFunctionToCacheLoader<K, V>(function);
    }

    private static final class AsyncFunctionToCacheLoader<K, V>
    extends AsyncCacheLoader<K, V> {
        final AsyncFunction<K, V> computingFunction;

        AsyncFunctionToCacheLoader(AsyncFunction<K, V> computingFunction) {
            this.computingFunction = Preconditions.checkNotNull(computingFunction);
        }

        @Override
        protected ListenableFuture<V> load(K key) {
            Preconditions.checkNotNull(key);
            try {
                return this.computingFunction.apply(key);
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture(e);
            }
        }
    }
}

