/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.context;

import com.google.common.base.Preconditions;
import com.google.common.context.ContextBuilder;
import com.google.common.context.ContextImpl;
import com.google.monitoring.census.TagSet;
import com.google.security.context.SecurityContext;
import com.google.tracing.GenericContext;
import com.google.tracing.TraceContext;
import javax.annotation.Nullable;
import org.joda.time.Instant;

public abstract class Context {
    public abstract SecurityContext getSecurityContext();

    public abstract TraceContext getTraceContext();

    @Deprecated
    @Nullable
    public abstract Instant getDeadline();

    public abstract TagSet getCensusHandle();

    public static ContextBuilder newBuilder(Context base) {
        return new ContextImpl.GenericContextBuilder(Preconditions.checkNotNull(base));
    }

    public static Context getCurrentContext() {
        return ContextImpl.currentContext();
    }

    public static Context getBackgroundContext() {
        return ContextImpl.backgroundContext;
    }

    abstract GenericContext asGenericContext();

    static {
        TraceContext.nullContext();
    }
}

