/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.context;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.context.Context;
import com.google.common.context.ContextAsyncFunction;
import com.google.common.context.ContextCallable;
import com.google.common.context.ContextFunction;
import com.google.common.context.ContextRunnable;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.tracing.GenericContextCallback;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ContextPropagation {
    private ContextPropagation() {
    }

    public static Runnable propagating(Runnable runnable) {
        return new ContextRunnable(runnable);
    }

    public static <T> Callable<T> propagating(Callable<T> callable) {
        return new ContextCallable<T>(callable);
    }

    public static <I, O> Function<I, O> propagating(Function<I, O> function) {
        return new ContextFunction<I, O>(function);
    }

    public static <I, O> AsyncFunction<I, O> propagating(AsyncFunction<I, O> function) {
        return new ContextAsyncFunction<I, O>(function);
    }

    public static <V> ListenableFuture<V> propagating(ListenableFuture<V> future) {
        return new PropagatingFuture<V>(future);
    }

    public static Executor propagating(Executor executor) {
        return new PropagatingExecutor(executor);
    }

    public static ExecutorService propagating(ExecutorService executorService) {
        if (executorService instanceof ListeningExecutorService) {
            return ContextPropagation.propagating((ListeningExecutorService)executorService);
        }
        if (executorService instanceof ScheduledExecutorService) {
            return ContextPropagation.propagating((ScheduledExecutorService)executorService);
        }
        return new PropagatingExecutorService(executorService);
    }

    public static ListeningExecutorService propagating(ListeningExecutorService listeningExecutorService) {
        return new PropagatingListeningExecutorService(listeningExecutorService);
    }

    public static ScheduledExecutorService propagating(ScheduledExecutorService executorService) {
        return new PropagatingScheduledExecutorService(executorService);
    }

    private static <T> ImmutableList<ContextCallable<T>> propagating(Collection<? extends Callable<T>> tasks) {
        ImmutableList.Builder propagating = ImmutableList.builder();
        for (Callable<T> task : tasks) {
            propagating.add(new ContextCallable<T>(task));
        }
        return propagating.build();
    }

    private static <T> Future<T> willNotRunIfCancelled(final Future<T> future, final GenericContextCallback<?> cancellable) {
        if (future instanceof ListenableFuture) {
            return new ForwardingListenableFuture.SimpleForwardingListenableFuture<T>((ListenableFuture)future){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    cancellable.willNotRun();
                    return super.cancel(mayInterruptIfRunning);
                }
            };
        }
        return new ForwardingFuture<T>(){

            @Override
            protected Future<T> delegate() {
                return future;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                cancellable.willNotRun();
                return super.cancel(mayInterruptIfRunning);
            }
        };
    }

    private static <T> ScheduledFuture<T> willNotRunIfCancelled(final ScheduledFuture<T> future, final GenericContextCallback<?> cancellable) {
        return new ForwardingScheduledFuture<T>(){

            @Override
            protected ScheduledFuture<T> delegate() {
                return future;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                cancellable.willNotRun();
                return super.cancel(mayInterruptIfRunning);
            }
        };
    }

    private static abstract class ForwardingScheduledFuture<V>
    extends ForwardingFuture<V>
    implements ScheduledFuture<V> {
        ForwardingScheduledFuture() {
        }

        @Override
        protected abstract ScheduledFuture<V> delegate();

        @Override
        public long getDelay(TimeUnit unit) {
            return this.delegate().getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.delegate().compareTo(o);
        }
    }

    private static class PropagatingScheduledExecutorService
    extends PropagatingExecutorService
    implements ScheduledExecutorService {
        final ScheduledExecutorService scheduledExecutorService;

        PropagatingScheduledExecutorService(ScheduledExecutorService executorService) {
            super(executorService);
            this.scheduledExecutorService = executorService;
        }

        @Override
        public final ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            ContextRunnable propagating = new ContextRunnable(command);
            try {
                return ContextPropagation.willNotRunIfCancelled(this.scheduledExecutorService.schedule(propagating, delay, unit), propagating);
            }
            catch (RejectedExecutionException e) {
                propagating.willNotRun();
                throw e;
            }
        }

        @Override
        public final <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            ContextCallable<V> propagating = new ContextCallable<V>(callable);
            try {
                return ContextPropagation.willNotRunIfCancelled(this.scheduledExecutorService.schedule(propagating, delay, unit), propagating);
            }
            catch (RejectedExecutionException e) {
                propagating.willNotRun();
                throw e;
            }
        }

        @Override
        public final ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            ContextRunnable propagating = new ContextRunnable(command);
            try {
                return ContextPropagation.willNotRunIfCancelled(this.scheduledExecutorService.scheduleAtFixedRate(propagating, initialDelay, period, unit), propagating);
            }
            catch (RejectedExecutionException e) {
                propagating.willNotRun();
                throw e;
            }
        }

        @Override
        public final ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            ContextRunnable propagating = new ContextRunnable(command);
            try {
                return ContextPropagation.willNotRunIfCancelled(this.scheduledExecutorService.scheduleWithFixedDelay(propagating, initialDelay, delay, unit), propagating);
            }
            catch (RejectedExecutionException e) {
                propagating.willNotRun();
                throw e;
            }
        }
    }

    private static class PropagatingListeningExecutorService
    extends PropagatingExecutorService
    implements ListeningExecutorService {
        PropagatingListeningExecutorService(ListeningExecutorService listeningExecutorService) {
            super(listeningExecutorService);
        }

        @Override
        public <T> ListenableFuture<T> submit(Callable<T> task) {
            return ContextPropagation.propagating((ListenableFuture)super.submit(task));
        }

        @Override
        public ListenableFuture<?> submit(Runnable task) {
            return ContextPropagation.propagating((ListenableFuture)super.submit(task));
        }

        @Override
        public <T> ListenableFuture<T> submit(Runnable task, T result) {
            return ContextPropagation.propagating((ListenableFuture)super.submit(task, result));
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Future future : super.invokeAll(tasks)) {
                builder.add(ContextPropagation.propagating((ListenableFuture)future));
            }
            return builder.build();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Future future : super.invokeAll(tasks, timeout, unit)) {
                builder.add(ContextPropagation.propagating((ListenableFuture)future));
            }
            return builder.build();
        }
    }

    private static class PropagatingExecutorService
    extends PropagatingExecutor
    implements ExecutorService {
        final ExecutorService executorService;

        PropagatingExecutorService(ExecutorService executorService) {
            super(executorService);
            this.executorService = executorService;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            ContextRunnable propagating = new ContextRunnable(task);
            try {
                return ContextPropagation.willNotRunIfCancelled(this.executorService.submit(propagating, result), propagating);
            }
            catch (RejectedExecutionException e) {
                propagating.willNotRun();
                throw e;
            }
        }

        @Override
        public Future<?> submit(Runnable task) {
            ContextRunnable propagating = new ContextRunnable(task);
            try {
                return ContextPropagation.willNotRunIfCancelled(this.executorService.submit(propagating), propagating);
            }
            catch (RejectedExecutionException e) {
                propagating.willNotRun();
                throw e;
            }
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            ContextCallable<T> propagating = new ContextCallable<T>(task);
            try {
                return ContextPropagation.willNotRunIfCancelled(this.executorService.submit(propagating), propagating);
            }
            catch (RejectedExecutionException e) {
                propagating.willNotRun();
                throw e;
            }
        }

        @Override
        public final List<Runnable> shutdownNow() {
            return this.executorService.shutdownNow();
        }

        @Override
        public final void shutdown() {
            this.executorService.shutdown();
        }

        @Override
        public final boolean isTerminated() {
            return this.executorService.isTerminated();
        }

        @Override
        public final boolean isShutdown() {
            return this.executorService.isShutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            ImmutableList propagatingList = ContextPropagation.propagating(tasks);
            try {
                Object t = this.executorService.invokeAny(propagatingList, timeout, unit);
                return t;
            }
            finally {
                for (ContextCallable propagating : propagatingList) {
                    propagating.willNotRun();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            ImmutableList propagatingList = ContextPropagation.propagating(tasks);
            try {
                Object t = this.executorService.invokeAny(propagatingList);
                return t;
            }
            finally {
                for (ContextCallable propagating : propagatingList) {
                    propagating.willNotRun();
                }
            }
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            ImmutableList propagatingList = ContextPropagation.propagating(tasks);
            try {
                List futures = this.executorService.invokeAll(propagatingList, timeout, unit);
                ImmutableList.Builder handleCancel = ImmutableList.builder();
                for (int i = 0; i < futures.size(); ++i) {
                    handleCancel.add(ContextPropagation.willNotRunIfCancelled(futures.get(i), (GenericContextCallback)propagatingList.get(i)));
                }
                return handleCancel.build();
            }
            catch (RejectedExecutionException e) {
                for (ContextCallable propagating : propagatingList) {
                    propagating.willNotRun();
                }
                throw e;
            }
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            ImmutableList propagatingList = ContextPropagation.propagating(tasks);
            try {
                List futures = this.executorService.invokeAll(propagatingList);
                ImmutableList.Builder handleCancel = ImmutableList.builder();
                for (int i = 0; i < futures.size(); ++i) {
                    handleCancel.add(ContextPropagation.willNotRunIfCancelled(futures.get(i), (GenericContextCallback)propagatingList.get(i)));
                }
                return handleCancel.build();
            }
            catch (RejectedExecutionException e) {
                for (ContextCallable propagating : propagatingList) {
                    propagating.willNotRun();
                }
                throw e;
            }
        }

        @Override
        public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executorService.awaitTermination(timeout, unit);
        }
    }

    private static class PropagatingExecutor
    implements Executor {
        final Executor executor;

        PropagatingExecutor(Executor executor) {
            this.executor = executor;
        }

        @Override
        public final void execute(Runnable command) {
            ContextRunnable propagating = new ContextRunnable(command);
            try {
                this.executor.execute(propagating);
            }
            catch (RejectedExecutionException e) {
                propagating.willNotRun();
                throw e;
            }
        }
    }

    private static final class PropagatingFuture<V>
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V> {
        private final ExecutionList listeners = new ExecutionList();
        private final Context context = Context.getCurrentContext();

        PropagatingFuture(ListenableFuture<V> delegate) {
            super(delegate);
            delegate.addListener(new ContextRunnable(){

                @Override
                protected void runInContext() {
                    PropagatingFuture.this.listeners.execute();
                }
            }, MoreExecutors.directExecutor());
        }

        @Override
        public void addListener(Runnable listener, Executor executor) {
            this.listeners.add(new ContextRunnable(this.context, listener), executor);
        }
    }
}

