/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.context;

import com.google.common.base.Function;
import com.google.common.context.Context;
import com.google.common.context.NonThrowingAutoCloseable;
import com.google.common.logging.FormattingLogger;
import com.google.tracing.CurrentContext;
import com.google.tracing.GenericContext;
import com.google.tracing.TraceContext;
import java.util.concurrent.Callable;
import java.util.logging.Level;

public final class WithContext
implements NonThrowingAutoCloseable {
    private static final FormattingLogger logger = FormattingLogger.getLogger((String)WithContext.class.getName());
    private final GenericContext prevContext = CurrentContext.currentContext();
    private final GenericContext attached;
    private final GenericContext toRestore;

    public static WithContext enter(Context c) {
        return new WithContext(c);
    }

    @Override
    public void close() {
        CurrentContext.detachContext((GenericContext)this.attached, (GenericContext)this.toRestore);
        WithContext.verifyCurrentContext(this.prevContext);
    }

    public static ContextApplier with(Context c) {
        return new ContextApplier(c);
    }

    WithContext(Context c) {
        this.attached = c.asGenericContext();
        this.toRestore = CurrentContext.attachContext((GenericContext)this.attached);
    }

    private static void verifyCurrentContext(GenericContext prevContext) {
        GenericContext currentContext = CurrentContext.currentContext();
        if (currentContext != prevContext && prevContext.getTrace() != null && currentContext.getTrace() != TraceContext.abortedContext()) {
            logger.logpfmt(Level.WARNING, "com.google.common.context.WithContext", "verifyCurrentContext", "Unbalanced trace contexts for LocalTraceSpan. Expected: %s Found: %s", new Object[]{prevContext, currentContext});
        }
    }

    public static final class ContextApplier {
        private final Context context;

        private ContextApplier(Context ctx) {
            this.context = ctx;
        }

        public void run(Runnable runnable) {
            CurrentContext.runInContext((GenericContext)this.context.asGenericContext(), (Runnable)runnable);
        }

        public <T> T call(Callable<T> callable) throws Exception {
            return (T)CurrentContext.callInContext((GenericContext)this.context.asGenericContext(), callable);
        }

        public <InputT, OutputT> OutputT apply(Function<InputT, OutputT> function, InputT input) {
            return (OutputT)CurrentContext.applyInContext((GenericContext)this.context.asGenericContext(), function, input);
        }
    }
}

