/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flags.ext;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.flags.Flag;
import com.google.common.flags.InvalidFlagValueException;
import com.google.common.flags.ext.MapUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapFlag<K, V>
extends Flag<Map<K, V>> {
    private static final Converter<String, String> STRING_CONVERTER = Converter.identity();
    private static final char DEFAULT_ENTRY_SEPARATOR = ',';
    private static final char DEFAULT_KEY_VALUE_SEPARATOR = '=';
    private static final boolean DEFAULT_OVERWRITE_DUPLICATE_KEYS = false;
    private static final boolean DEFAULT_COLLECT_ENTRIES = false;
    private final Converter<String, K> keyConverter;
    private final Converter<String, V> valueConverter;
    private final char entrySeparator;
    private final char keyValueSeparator;
    private final boolean overwriteDuplicateKeys;
    private final boolean collectEntries;
    private final Map<K, V> result = new LinkedHashMap();

    public static MapFlag<String, String> map() {
        return new MapFlag<String, String>(STRING_CONVERTER, STRING_CONVERTER, ',', '=', false, false);
    }

    public <T> MapFlag<T, V> withKeyParser(Converter<String, T> keyConverter) {
        return new MapFlag<T, V>(keyConverter, this.valueConverter, this.entrySeparator, this.keyValueSeparator, this.overwriteDuplicateKeys, this.collectEntries);
    }

    public <T> MapFlag<K, T> withValueParser(Converter<String, T> valueConverter) {
        return new MapFlag<K, T>(this.keyConverter, valueConverter, this.entrySeparator, this.keyValueSeparator, this.overwriteDuplicateKeys, this.collectEntries);
    }

    public MapFlag<K, V> withEntrySeparator(char entrySeparator) {
        return new MapFlag<K, V>(this.keyConverter, this.valueConverter, entrySeparator, this.keyValueSeparator, this.overwriteDuplicateKeys, this.collectEntries);
    }

    public MapFlag<K, V> withKeyValueSeparator(char keyValueSeparator) {
        return new MapFlag<K, V>(this.keyConverter, this.valueConverter, this.entrySeparator, keyValueSeparator, this.overwriteDuplicateKeys, this.collectEntries);
    }

    public MapFlag<K, V> overwriteDuplicateKeys() {
        return new MapFlag<K, V>(this.keyConverter, this.valueConverter, this.entrySeparator, this.keyValueSeparator, true, this.collectEntries);
    }

    public MapFlag<K, V> collectEntries() {
        return new MapFlag<K, V>(this.keyConverter, this.valueConverter, this.entrySeparator, this.keyValueSeparator, this.overwriteDuplicateKeys, true);
    }

    public Flag<Map<K, V>> withDefault(Map<K, V> defaultValue) {
        return new MapFlag<K, V>(this.keyConverter, this.valueConverter, this.entrySeparator, this.keyValueSeparator, this.overwriteDuplicateKeys, this.collectEntries, defaultValue);
    }

    public Flag<Map<K, V>> withDefault(String defaultValue) {
        try {
            return new MapFlag<K, V>(this.keyConverter, this.valueConverter, this.entrySeparator, this.keyValueSeparator, this.overwriteDuplicateKeys, this.collectEntries, this.parse(defaultValue));
        }
        catch (InvalidFlagValueException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected MapFlag(Converter<String, K> keyConverter, Converter<String, V> valueConverter, char entrySeparator, char keyValueSeparator, boolean overwriteDuplicateKeys, boolean collectEntries, Map<K, V> defaultValue) {
        super(ImmutableMap.copyOf(Preconditions.checkNotNull(defaultValue)));
        this.keyConverter = Preconditions.checkNotNull(keyConverter);
        this.valueConverter = Preconditions.checkNotNull(valueConverter);
        this.entrySeparator = entrySeparator;
        this.keyValueSeparator = keyValueSeparator;
        this.overwriteDuplicateKeys = overwriteDuplicateKeys;
        this.collectEntries = collectEntries;
    }

    protected MapFlag(Converter<String, K> keyConverter, Converter<String, V> valueConverter, char entrySeparator, char keyValueSeparator, boolean overwriteDuplicateKeys, boolean collectEntries) {
        this(keyConverter, valueConverter, entrySeparator, keyValueSeparator, overwriteDuplicateKeys, collectEntries, Collections.emptyMap());
    }

    protected MapFlag(Converter<String, K> keyConverter, Converter<String, V> valueConverter, char entrySeparator, char keyValueSeparator) {
        this(keyConverter, valueConverter, entrySeparator, keyValueSeparator, false, false, Collections.emptyMap());
    }

    @Override
    protected Map<K, V> parse(String text) throws InvalidFlagValueException {
        if (!this.collectEntries) {
            this.result.clear();
        }
        Map<K, V> newEntries = MapUtils.parseMap(text, this.keyConverter, this.valueConverter, this.entrySeparator, this.keyValueSeparator, this.overwriteDuplicateKeys);
        if (!this.overwriteDuplicateKeys) {
            for (K newKey : newEntries.keySet()) {
                if (!this.result.containsKey(newKey)) continue;
                throw new InvalidFlagValueException(String.format("Duplicate map key '%s' in '%s'", newKey.toString(), text));
            }
        }
        this.result.putAll(newEntries);
        return Collections.unmodifiableMap(this.result);
    }

    @Override
    protected String parsableStringValue(Map<K, V> value) {
        return FluentIterable.from(value.entrySet()).transform(new Function<Map.Entry<K, V>, String>(){

            @Override
            public String apply(Map.Entry<K, V> from) {
                String string = (String)MapFlag.this.keyConverter.reverse().convert(from.getKey());
                char c = MapFlag.this.keyValueSeparator;
                String string2 = (String)MapFlag.this.valueConverter.reverse().convert(from.getValue());
                return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(c).append(string2).toString();
            }
        }).join(Joiner.on(this.entrySeparator));
    }

    @Override
    public void resetForTest() {
        super.resetForTest();
        this.result.clear();
    }

    public static final class MapFlagFactory {
        public static Flag<Map<String, String>> value(Map<String, String> defaultValue) {
            return MapFlag.map().withEntrySeparator(',').withKeyValueSeparator('=').withDefault(defaultValue);
        }

        public static Map<String, String> valueOf(String text) {
            return MapFlag.map().withEntrySeparator(',').withKeyValueSeparator('=').withDefault(text).get();
        }

        private MapFlagFactory() {
        }
    }
}

