/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flags.ext;

import com.google.common.base.CharMatcher;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.flags.InvalidFlagValueException;
import java.util.LinkedHashMap;
import java.util.Map;

final class MapUtils {
    private MapUtils() {
    }

    static <K, V> Map<K, V> parseMap(String text, Converter<String, K> keyConverter, Converter<String, V> valueConverter, char entrySeparator, char keyValueSeparator, boolean overwriteDuplicateKeys) throws InvalidFlagValueException {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(keyConverter);
        Preconditions.checkNotNull(valueConverter);
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        if (!CharMatcher.whitespace().matchesAllOf(text)) {
            for (String s : Splitter.on(entrySeparator).split(text)) {
                V value;
                K key;
                int index = s.indexOf(keyValueSeparator);
                if (index == -1) {
                    String string = String.valueOf(s);
                    throw new InvalidFlagValueException(string.length() != 0 ? "Invalid map entry syntax ".concat(string) : new String("Invalid map entry syntax "));
                }
                String keyStr = CharMatcher.whitespace().trimFrom(s.substring(0, index));
                try {
                    key = keyConverter.convert(keyStr);
                }
                catch (Exception e) {
                    throw new InvalidFlagValueException(String.format("Error parsing map key '%s'", keyStr), e);
                }
                String valStr = CharMatcher.whitespace().trimFrom(s.substring(index + 1));
                try {
                    value = valueConverter.convert(valStr);
                }
                catch (Exception e) {
                    throw new InvalidFlagValueException(String.format("Error parsing map value '%s' for key '%s'", valStr, keyStr), e);
                }
                if (!overwriteDuplicateKeys && result.containsKey(key)) {
                    throw new InvalidFlagValueException(String.format("Duplicate map key '%s' in '%s'", keyStr, text));
                }
                result.put(key, value);
            }
        }
        return result;
    }
}

