/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.google;

import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.backend.Platform;
import com.google.common.flogger.backend.Tags;
import com.google.common.flogger.backend.google.HighPrecisionClock;
import com.google.common.flogger.backend.system.Clock;
import com.google.common.flogger.backend.system.EmptyLoggingContext;
import com.google.common.flogger.backend.system.LoggingContext;
import com.google.common.flogger.backend.system.SimpleLoggerBackend;
import com.google.common.flogger.backend.system.StackBasedCallerFinder;
import com.google.common.flogger.backend.system.SystemClock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GooglePlatform
extends Platform {
    private static final String CONFIG_CONTEXT_IMPL = "google.debug_logs.log_platform.context";
    private static final String DEFAULT_CONTEXT_IMPL = "com.google.common.flogger.config.TraceLoggingContext";
    private static final String CONTEXT_GETTER = "getInstance";
    private final LoggingContext context = GooglePlatform.resolveLoggingContext();
    private final Clock clock = GooglePlatform.resolveClock();

    private static Clock resolveClock() {
        Clock highPrecisionClock = HighPrecisionClock.getInstance();
        return highPrecisionClock != null ? highPrecisionClock : SystemClock.getInstance();
    }

    private static LoggingContext resolveLoggingContext() {
        String contextImpl;
        try {
            contextImpl = System.getProperty(CONFIG_CONTEXT_IMPL, DEFAULT_CONTEXT_IMPL);
        }
        catch (SecurityException e) {
            contextImpl = DEFAULT_CONTEXT_IMPL;
        }
        LoggingContext context = GooglePlatform.callStaticGetter(contextImpl, CONTEXT_GETTER, LoggingContext.class);
        return context != null ? context : EmptyLoggingContext.getInstance();
    }

    @Override
    protected Platform.LogCallerFinder getCallerFinderImpl() {
        return StackBasedCallerFinder.getInstance();
    }

    @Override
    protected LoggerBackend getBackendImpl(String className) {
        Logger logger = Logger.getLogger(className.replace('$', '.'));
        return new SimpleLoggerBackend(logger);
    }

    @Override
    protected boolean shouldForceLoggingImpl(String loggerName, Level level, boolean isEnabled) {
        return this.context.shouldForceLogging(loggerName, level, isEnabled);
    }

    @Override
    protected Tags getInjectedTagsImpl() {
        return this.context.getTags();
    }

    @Override
    protected long getCurrentTimeNanosImpl() {
        return this.clock.getCurrentTimeNanos();
    }

    @Override
    protected String getConfigInfoImpl() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.clock);
        String string3 = String.valueOf(this.context);
        return new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Platform: ").append(string).append("\nClock: ").append(string2).append("\nLoggingContext: ").append(string3).append("\n").toString();
    }

    private static <T> T callStaticGetter(String className, String methodName, Class<T> targetType) {
        try {
            return targetType.cast(Class.forName(className).getMethod(methodName, new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ReflectiveOperationException | SecurityException e) {
            System.err.format("error calling expected no-argument static method %s.%s: %s\n", className, methodName, e);
            e.printStackTrace(System.err);
        }
        catch (ClassCastException e) {
            System.err.format("cannot cast result of call %s.%s to expected type %s: %s\n", className, methodName, targetType.getName(), e);
            e.printStackTrace(System.err);
        }
        return null;
    }
}

