/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.GoogleInternal;
import com.google.common.hash.CityHash128HashFunction;
import com.google.common.hash.Fingerprint1999;
import com.google.common.hash.Fingerprint2011;
import com.google.common.hash.GoogleLegacy32HashFunction;
import com.google.common.hash.GoogleLegacy64HashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.JenkinsHashing;

@GoogleInternal
public final class TradeSecretHashing {
    private static final int FINGERPRINT_SEED = 102072;
    static final int SEED32 = 314159265;
    static final int CONSTANT32 = -1640531527;
    static final long SEED64 = 3141592653589793238L;
    static final long CONSTANT64 = -2266404186210603134L;

    public static HashFunction fingerprint2011() {
        return Fingerprint2011Holder.FINGERPRINT_2011;
    }

    public static HashFunction internalCityHash128() {
        return CityHash128Holder.CITY_HASH_128;
    }

    public static HashFunction internalCityHash128(long seedHigh, long seedLow) {
        return new CityHash128HashFunction(seedHigh, seedLow);
    }

    @Deprecated
    public static HashFunction googleHash32() {
        return GoogleHash32Holder.GOOGLE_LEGACY_32;
    }

    @Deprecated
    public static HashFunction googleHash32(int seed) {
        return new GoogleLegacy32HashFunction(seed, GoogleLegacy32HashFunction.FingerprintStrategy.WORKING);
    }

    @Deprecated
    public static HashFunction googleHash64() {
        return GoogleHash64Holder.GOOGLE_LEGACY_64;
    }

    @Deprecated
    public static HashFunction googleHash64(long seed) {
        return new GoogleLegacy64HashFunction(seed);
    }

    @Deprecated
    public static HashFunction fingerprint1999() {
        return Fingerprint1999Holder.FINGERPRINT_1999;
    }

    @Deprecated
    public static HashFunction brokenFingerprint1999() {
        return BrokenFingerprint1999Holder.BROKEN_FINGERPRINT_1999;
    }

    @Deprecated
    public static HashCode stringHash64(CharSequence value) {
        long a;
        long b = a = -2266404186210603134L;
        long c = 3141592653589793238L;
        int offset = 0;
        int keylen = value.length();
        while (keylen >= 12) {
            a += TradeSecretHashing.word64CharAt(value, offset);
            a -= (b += TradeSecretHashing.word64CharAt(value, offset + 4));
            a -= (c += TradeSecretHashing.word64CharAt(value, offset + 8));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            keylen -= 12;
            offset += 12;
        }
        c += (long)value.length();
        switch (keylen) {
            case 11: {
                c += ((long)value.charAt(offset + 10) & 0xFFFFL) << 40;
            }
            case 10: {
                c += ((long)value.charAt(offset + 9) & 0xFFFFL) << 24;
            }
            case 9: {
                c += ((long)value.charAt(offset + 8) & 0xFFFFL) << 8;
            }
            case 8: {
                b += TradeSecretHashing.word64CharAt(value, offset + 4);
                a += TradeSecretHashing.word64CharAt(value, offset);
                break;
            }
            case 7: {
                b += ((long)value.charAt(offset + 6) & 0xFFFFL) << 32;
            }
            case 6: {
                b += ((long)value.charAt(offset + 5) & 0xFFFFL) << 16;
            }
            case 5: {
                b += (long)value.charAt(offset + 4) & 0xFFFFL;
            }
            case 4: {
                a += TradeSecretHashing.word64CharAt(value, offset);
                break;
            }
            case 3: {
                a += ((long)value.charAt(offset + 2) & 0xFFFFL) << 32;
            }
            case 2: {
                a += ((long)value.charAt(offset + 1) & 0xFFFFL) << 16;
            }
            case 1: {
                a += (long)value.charAt(offset) & 0xFFFFL;
            }
            case 0: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return HashCode.fromLong(JenkinsHashing.mix64(a, b, c));
    }

    private static long word64CharAt(CharSequence chars, int offset) {
        return ((long)chars.charAt(offset) & 0xFFFFL) + (((long)chars.charAt(offset + 1) & 0xFFFFL) << 16) + (((long)chars.charAt(offset + 2) & 0xFFFFL) << 32) + (((long)chars.charAt(offset + 3) & 0xFFFFL) << 48);
    }

    private TradeSecretHashing() {
    }

    private static final class BrokenFingerprint1999Holder {
        static final HashFunction BROKEN_FINGERPRINT_1999 = new Fingerprint1999((HashFunction)new GoogleLegacy32HashFunction(0, GoogleLegacy32HashFunction.FingerprintStrategy.BROKEN), (HashFunction)new GoogleLegacy32HashFunction(102072, GoogleLegacy32HashFunction.FingerprintStrategy.BROKEN), "TradeSecretHashing.brokenFingerprint1999()");

        private BrokenFingerprint1999Holder() {
        }
    }

    private static final class Fingerprint1999Holder {
        static final HashFunction FINGERPRINT_1999 = new Fingerprint1999(TradeSecretHashing.googleHash32(0), TradeSecretHashing.googleHash32(102072), "TradeSecretHashing.fingerprint1999()");

        private Fingerprint1999Holder() {
        }
    }

    private static final class GoogleHash64Holder {
        static final HashFunction GOOGLE_LEGACY_64 = new GoogleLegacy64HashFunction(3141592653589793238L);

        private GoogleHash64Holder() {
        }
    }

    private static final class GoogleHash32Holder {
        static final HashFunction GOOGLE_LEGACY_32 = new GoogleLegacy32HashFunction(314159265, GoogleLegacy32HashFunction.FingerprintStrategy.WORKING);

        private GoogleHash32Holder() {
        }
    }

    private static class CityHash128Holder {
        static final HashFunction CITY_HASH_128 = new CityHash128HashFunction();

        private CityHash128Holder() {
        }
    }

    private static class Fingerprint2011Holder {
        static final HashFunction FINGERPRINT_2011 = new Fingerprint2011();

        private Fingerprint2011Holder() {
        }
    }
}

