/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.html.HtmlEscapers;
import com.google.i18n.BidiUtils;
import com.google.i18n.identifiers.JavaLocaleConverter;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.ULocaleConverter;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

@GoogleInternal
@GwtIncompatible
public class BidiFormatter {
    private static final int FLAG_CONTEXT_LTR = 1;
    private static final int FLAG_CONTEXT_RTL = 2;
    private static final int FLAG_ALWAYS_SPAN = 4;
    private static final int FLAG_STEREO_ISOLATE = 8;
    private static final int FLAG_ASSUME_HTML5_DIR = 16;
    private static final int FLAGS_LIMIT = 32;
    private static final int DEFAULT_FLAGS = 0;
    private static final BidiFormatter[] instances = new BidiFormatter[32];
    private final BidiUtils.Dir contextDir;
    private final int flags;

    public static BidiFormatter getInstance(@Nullable BidiUtils.Dir contextDir) {
        return new Builder(contextDir).build();
    }

    public static BidiFormatter getInstance(boolean rtlContext) {
        return new Builder(rtlContext).build();
    }

    public static BidiFormatter getInstance(Locale locale) {
        return new Builder(locale).build();
    }

    public static BidiFormatter getInstance(ULocale locale) {
        return new Builder(locale).build();
    }

    public static BidiFormatter getInstance(LanguageCode languageCode) {
        return new Builder(languageCode).build();
    }

    public static BidiFormatter getInstanceWithNoContext() {
        return new Builder((BidiUtils.Dir)null).build();
    }

    private BidiFormatter(@Nullable BidiUtils.Dir contextDir, int flags) {
        this.contextDir = contextDir;
        this.flags = flags;
    }

    @Nullable
    public BidiUtils.Dir getContextDir() {
        return this.contextDir;
    }

    public boolean isRtlContext() {
        return this.contextDir == BidiUtils.Dir.RTL;
    }

    public boolean getAlwaysSpan() {
        return (this.flags & 4) != 0;
    }

    public boolean getAssumeHtml5Dir() {
        return (this.flags & 0x10) != 0;
    }

    public boolean getStereoIsolate() {
        return (this.flags & 8) != 0;
    }

    public String dirAttrValue(String str, boolean isHtml) {
        return this.knownDirAttrValue(BidiFormatter.estimateDirection(str, isHtml));
    }

    public String dirAttrValue(String str) {
        return this.dirAttrValue(str, false);
    }

    public String knownDirAttrValue(BidiUtils.Dir dir) {
        Preconditions.checkNotNull(dir);
        if (dir == BidiUtils.Dir.NEUTRAL) {
            dir = this.contextDir;
        }
        return dir == BidiUtils.Dir.RTL ? "rtl" : "ltr";
    }

    public String dirAttr(String str, boolean isHtml) {
        return this.knownDirAttr(BidiFormatter.estimateDirection(str, isHtml));
    }

    public String dirAttr(String str) {
        return this.dirAttr(str, false);
    }

    public String knownDirAttr(BidiUtils.Dir dir) {
        Preconditions.checkNotNull(dir);
        if (dir != this.contextDir) {
            return dir == BidiUtils.Dir.LTR ? "dir=\"ltr\"" : (dir == BidiUtils.Dir.RTL ? "dir=\"rtl\"" : "");
        }
        return "";
    }

    public String spanWrap(String str, boolean isHtml, boolean isolate) {
        return this.spanWrapWithKnownDir(null, str, isHtml, isolate);
    }

    public String spanWrap(String str, boolean isHtml) {
        return this.spanWrap(str, isHtml, true);
    }

    public String spanWrap(String str) {
        return this.spanWrap(str, false, true);
    }

    public String spanWrapWithKnownDir(@Nullable BidiUtils.Dir dir, String str, boolean isHtml, boolean isolate) {
        boolean dirCondition;
        if (dir == null) {
            dir = BidiFormatter.estimateDirection(str, isHtml);
        }
        String origStr = str;
        if (!isHtml) {
            str = HtmlEscapers.htmlEscaper().escape(str);
        }
        StringBuilder result = new StringBuilder();
        boolean bl = dirCondition = dir != BidiUtils.Dir.NEUTRAL && dir != this.contextDir;
        if (isolate) {
            if (this.getAssumeHtml5Dir()) {
                if (!dirCondition) {
                    if (this.contextDir != null) {
                        BidiUtils.Dir oppositeDir;
                        BidiUtils.Dir dir2 = oppositeDir = this.contextDir == BidiUtils.Dir.LTR ? BidiUtils.Dir.RTL : BidiUtils.Dir.LTR;
                        if (BidiUtils.getExitDir(origStr, isHtml) == oppositeDir || this.getStereoIsolate() && BidiUtils.getEntryDir(origStr, isHtml) == oppositeDir) {
                            dir = this.contextDir;
                            dirCondition = true;
                        }
                    } else {
                        dir = BidiUtils.getExitDir(origStr, isHtml);
                        if (dir == BidiUtils.Dir.NEUTRAL && this.getStereoIsolate()) {
                            dir = BidiUtils.getEntryDir(origStr, isHtml);
                        }
                        dirCondition = dir != BidiUtils.Dir.NEUTRAL;
                    }
                }
            } else if (this.getStereoIsolate()) {
                result.append(this.markBeforeKnownDir(dir, origStr, isHtml));
            }
        }
        if (this.getAlwaysSpan() || dirCondition) {
            result.append("<span");
            if (dirCondition) {
                result.append(dir == BidiUtils.Dir.RTL ? " dir=\"rtl\"" : " dir=\"ltr\"");
            }
            result.append('>').append(str).append("</span>");
        } else {
            result.append(str);
        }
        if (isolate && !this.getAssumeHtml5Dir()) {
            result.append(this.markAfterKnownDir(dir, origStr, isHtml));
        }
        return result.toString();
    }

    public String spanWrapWithKnownDir(@Nullable BidiUtils.Dir dir, String str, boolean isHtml) {
        return this.spanWrapWithKnownDir(dir, str, isHtml, true);
    }

    public String spanWrapWithKnownDir(@Nullable BidiUtils.Dir dir, String str) {
        return this.spanWrapWithKnownDir(dir, str, false, true);
    }

    public String unicodeWrap(String str, boolean isHtml, boolean isolate) {
        return this.unicodeWrapWithKnownDir(null, str, isHtml, isolate);
    }

    public String unicodeWrap(String str, boolean isHtml) {
        return this.unicodeWrap(str, isHtml, true);
    }

    public String unicodeWrap(String str) {
        return this.unicodeWrap(str, false, true);
    }

    public String unicodeWrapWithKnownDir(@Nullable BidiUtils.Dir dir, String str, boolean isHtml, boolean isolate) {
        if (dir == null) {
            dir = BidiFormatter.estimateDirection(str, isHtml);
        }
        StringBuilder result = new StringBuilder();
        if (this.getStereoIsolate() && isolate) {
            result.append(this.markBeforeKnownDir(dir, str, isHtml));
        }
        if (dir != BidiUtils.Dir.NEUTRAL && dir != this.contextDir) {
            result.append(dir == BidiUtils.Dir.RTL ? (char)'\u202b' : '\u202a');
            result.append(str);
            result.append('\u202c');
        } else {
            result.append(str);
        }
        if (isolate) {
            result.append(this.markAfterKnownDir(dir, str, isHtml));
        }
        return result.toString();
    }

    public String unicodeWrapWithKnownDir(@Nullable BidiUtils.Dir dir, String str, boolean isHtml) {
        return this.unicodeWrapWithKnownDir(dir, str, isHtml, true);
    }

    public String unicodeWrapWithKnownDir(@Nullable BidiUtils.Dir dir, String str) {
        return this.unicodeWrapWithKnownDir(dir, str, false, true);
    }

    public String markAfter(String str, boolean isHtml) {
        return this.markAfterKnownDir(null, str, isHtml);
    }

    public String markAfter(String str) {
        return this.markAfter(str, false);
    }

    public String markAfterKnownDir(@Nullable BidiUtils.Dir dir, String str, boolean isHtml) {
        if (dir == null) {
            dir = BidiFormatter.estimateDirection(str, isHtml);
        }
        if (this.contextDir == BidiUtils.Dir.LTR && (dir == BidiUtils.Dir.RTL || BidiUtils.getExitDir(str, isHtml) == BidiUtils.Dir.RTL)) {
            return BidiUtils.Format.LRM_STRING;
        }
        if (this.contextDir == BidiUtils.Dir.RTL && (dir == BidiUtils.Dir.LTR || BidiUtils.getExitDir(str, isHtml) == BidiUtils.Dir.LTR)) {
            return BidiUtils.Format.RLM_STRING;
        }
        return "";
    }

    public String markAfterKnownDir(@Nullable BidiUtils.Dir dir, String str) {
        return this.markAfterKnownDir(dir, str, false);
    }

    public String markBefore(String str, boolean isHtml) {
        return this.markBeforeKnownDir(null, str, isHtml);
    }

    public String markBefore(String str) {
        return this.markBefore(str, false);
    }

    public String markBeforeKnownDir(@Nullable BidiUtils.Dir dir, String str, boolean isHtml) {
        if (dir == null) {
            dir = BidiFormatter.estimateDirection(str, isHtml);
        }
        if (this.contextDir == BidiUtils.Dir.LTR && (dir == BidiUtils.Dir.RTL || BidiUtils.getEntryDir(str, isHtml) == BidiUtils.Dir.RTL)) {
            return BidiUtils.Format.LRM_STRING;
        }
        if (this.contextDir == BidiUtils.Dir.RTL && (dir == BidiUtils.Dir.LTR || BidiUtils.getEntryDir(str, isHtml) == BidiUtils.Dir.LTR)) {
            return BidiUtils.Format.RLM_STRING;
        }
        return "";
    }

    public String markBeforeKnownDir(@Nullable BidiUtils.Dir dir, String str) {
        return this.markBeforeKnownDir(dir, str, false);
    }

    public String mark() {
        return this.contextDir == BidiUtils.Dir.LTR ? BidiUtils.Format.LRM_STRING : (this.contextDir == BidiUtils.Dir.RTL ? BidiUtils.Format.RLM_STRING : "");
    }

    public String startEdge() {
        return this.contextDir == BidiUtils.Dir.RTL ? "right" : "left";
    }

    public String endEdge() {
        return this.contextDir == BidiUtils.Dir.RTL ? "left" : "right";
    }

    public static BidiUtils.Dir estimateDirection(String str, boolean isHtml) {
        return BidiUtils.estimateDirection(str, isHtml);
    }

    public static BidiUtils.Dir estimateDirection(String str) {
        return BidiUtils.estimateDirection(str);
    }

    public static final class Builder {
        private BidiUtils.Dir contextDir;
        private int flags;

        public Builder(@Nullable BidiUtils.Dir contextDir) {
            Preconditions.checkArgument(contextDir != BidiUtils.Dir.NEUTRAL);
            this.initialize(contextDir);
        }

        public Builder(boolean rtlContext) {
            this.initialize(rtlContext ? BidiUtils.Dir.RTL : BidiUtils.Dir.LTR);
        }

        public Builder(Locale locale) {
            this.initialize(BidiUtils.languageDir(JavaLocaleConverter.CONVERTER.fromOther(locale)));
        }

        public Builder(ULocale locale) {
            this.initialize(BidiUtils.languageDir(ULocaleConverter.CONVERTER.fromOther(locale)));
        }

        public Builder(LanguageCode languageCode) {
            this.initialize(BidiUtils.languageDir(languageCode));
        }

        private void initialize(@Nullable BidiUtils.Dir contextDir) {
            this.contextDir = contextDir;
            this.flags = 0;
        }

        public Builder alwaysSpan(boolean alwaysSpan) {
            this.flags = alwaysSpan ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
            return this;
        }

        public Builder assumeHtml5Dir(boolean assumeHtml5Dir) {
            this.flags = assumeHtml5Dir ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
            return this;
        }

        public Builder stereoIsolate(boolean stereoIsolate) {
            this.flags = stereoIsolate ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BidiFormatter build() {
            this.flags |= this.contextDir == BidiUtils.Dir.LTR ? 1 : (this.contextDir == BidiUtils.Dir.RTL ? 2 : 0);
            BidiFormatter instance = instances[this.flags];
            if (instance == null) {
                BidiFormatter[] bidiFormatterArray = instances;
                synchronized (bidiFormatterArray) {
                    instance = instances[this.flags];
                    if (instance == null) {
                        instances[this.flags] = instance = new BidiFormatter(this.contextDir, this.flags);
                    }
                }
            }
            return instance;
        }
    }
}

