/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.StringUtil;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

@GoogleInternal
@GwtIncompatible
public class HtmlDomInspector {
    protected Document document;
    private final List<Node> nodeStack = Lists.newArrayList();

    @Deprecated
    public HtmlDomInspector(String html) {
        this(HtmlDomInspector.makeDocument(html, Encoding.DEFAULT, null));
    }

    @Deprecated
    public HtmlDomInspector(String html, Encoding encoding) {
        this(HtmlDomInspector.makeDocument(html, encoding, null));
    }

    @Deprecated
    public HtmlDomInspector(String html, boolean utf8) {
        this(html, utf8 ? Encoding.UTF8 : Encoding.DEFAULT);
    }

    public HtmlDomInspector(Document doc) {
        this.document = doc;
    }

    private HtmlDomInspector(Builder builder) {
        this(HtmlDomInspector.makeDocument(builder.input, builder.encoding, builder.tidyProperties));
    }

    private static Document makeDocument(String input, Encoding encoding, Properties tidyProperties) {
        byte[] bytes;
        if (StringUtil.isEmptyOrWhitespace(input)) {
            return Tidy.createEmptyDocument();
        }
        Tidy tidy = new Tidy();
        tidy.setMakeClean(false);
        tidy.setXmlTags(false);
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        tidy.setTidyMark(false);
        if (tidyProperties != null) {
            tidy.setConfigurationFromProps(tidyProperties);
        }
        switch (encoding) {
            case UTF8: {
                tidy.setInputEncoding(StandardCharsets.UTF_8.name());
                tidy.setOutputEncoding(StandardCharsets.UTF_8.name());
                bytes = input.getBytes(StandardCharsets.UTF_8);
                break;
            }
            case ASCII: {
                tidy.setInputEncoding(StandardCharsets.US_ASCII.name());
                tidy.setOutputEncoding(StandardCharsets.US_ASCII.name());
                bytes = input.getBytes(StandardCharsets.US_ASCII);
                break;
            }
            default: {
                bytes = input.getBytes(Charset.defaultCharset());
            }
        }
        return tidy.parseDOM((InputStream)new ByteArrayInputStream(bytes), null);
    }

    public Document getDocument() {
        return this.document;
    }

    public Node getCurrentNode() {
        if (this.nodeStack.isEmpty()) {
            return this.document;
        }
        return this.nodeStack.get(this.nodeStack.size() - 1);
    }

    public void pushNode(String xpath) throws XPathExpressionException {
        this.nodeStack.add(this.getSingleNode(xpath));
    }

    public void popNode() {
        this.nodeStack.remove(this.nodeStack.size() - 1);
    }

    public void clearNodeStack() {
        this.nodeStack.clear();
    }

    public String getSingleNodeValue(String xpath) throws XPathExpressionException, NodeNotFoundException, MultipleNodesFoundException {
        return this.getSingleNode(xpath).getNodeValue();
    }

    public String getSingleNodeText(String xpath) throws XPathExpressionException {
        Node node = this.getSingleNode(xpath);
        return HtmlDomInspector.getNodeText(node);
    }

    public List<String> getMultipleNodesText(String xpath) throws XPathExpressionException, NodeNotFoundException {
        ArrayList<String> result = new ArrayList<String>();
        NodeList nodeList = this.getNodeList(xpath);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            result.add(HtmlDomInspector.getNodeText(node));
        }
        return result;
    }

    public static String getNodeText(Node node) {
        NodeList childNodes = node.getChildNodes();
        if (childNodes == null || childNodes.getLength() <= 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (childNodes.item(i).getNodeType() != 3) continue;
            result.append(childNodes.item(i).getNodeValue());
        }
        return result.toString();
    }

    public String getSingleNodeTextRecursive(String xpath) throws XPathExpressionException {
        Node node = this.getSingleNode(xpath);
        NodeList nodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("descendant::text()", node, XPathConstants.NODESET);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nodes.getLength(); ++i) {
            result.append(nodes.item(i).getNodeValue());
        }
        return result.toString();
    }

    public String getSingleNodeAttributeValue(String xpath, String attributeName) throws XPathExpressionException {
        Element element = (Element)this.getSingleNode(xpath);
        if (element.getAttributeNode(attributeName) == null) {
            return null;
        }
        return element.getAttribute(attributeName);
    }

    public String getNodeListTextRecursive(String xpath) throws XPathExpressionException {
        NodeList nodelist = this.getNodeList(xpath);
        StringBuilder result = new StringBuilder();
        for (int nodeIndex = 0; nodeIndex < nodelist.getLength(); ++nodeIndex) {
            NodeList nodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("descendant::text()", nodelist.item(nodeIndex), XPathConstants.NODESET);
            for (int textNodeIndex = 0; textNodeIndex < nodes.getLength(); ++textNodeIndex) {
                result.append(nodes.item(textNodeIndex).getNodeValue());
            }
        }
        return result.toString();
    }

    public int nodeCount(String xpath) throws XPathExpressionException {
        return this.getNodeList(xpath).getLength();
    }

    public boolean hasNodes(String xpath) throws XPathExpressionException {
        return this.nodeCount(xpath) > 0;
    }

    public Node getSingleNode(String xpath) throws XPathExpressionException {
        NodeList nodes = this.getNodeList(xpath);
        if (nodes.getLength() == 0) {
            throw new NodeNotFoundException();
        }
        if (nodes.getLength() > 1) {
            throw new MultipleNodesFoundException();
        }
        return nodes.item(0);
    }

    public NodeList getNodeList(String xpath) throws XPathExpressionException {
        return (NodeList)XPathFactory.newInstance().newXPath().evaluate(xpath, this.getCurrentNode(), XPathConstants.NODESET);
    }

    public Collection<String> findDuplicateIds() {
        try {
            NodeList nodeList = this.getNodeList("//@id");
            HashSet<String> nodeSet = Sets.newHashSet();
            HashSet<String> duplicateIds = Sets.newHashSet();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String id = nodeList.item(i).getNodeValue();
                boolean unique = nodeSet.add(id);
                if (unique) continue;
                duplicateIds.add(id);
            }
            return duplicateIds;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public NodeList findElementsWithoutId(String ... elements) {
        try {
            Iterator<String> elementWithoutIdMatcher = Iterators.transform(Arrays.asList(elements).iterator(), new Function<String, String>(this){

                @Override
                public String apply(String from) {
                    return new StringBuilder(12 + String.valueOf(from).length()).append("//").append(from).append("[not(@id)]").toString();
                }
            });
            String xpath = Joiner.on("|").join(elementWithoutIdMatcher);
            return this.getNodeList(xpath);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public static class MultipleNodesFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public static class NodeNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public static class Builder {
        final String input;
        Encoding encoding;
        Properties tidyProperties;

        public Builder(String input) {
            this.input = input;
            this.encoding = Encoding.DEFAULT;
            this.tidyProperties = null;
        }

        public Builder setEncoding(Encoding encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder addInlineTags(String ... inlineTags) {
            String value = Joiner.on(',').join(inlineTags);
            this.setTidyProperty("new-inline-tags", value);
            return this;
        }

        public Builder setTrimEmptyElements(boolean trimEmpty) {
            this.setTidyProperty("trim-empty-elements", String.valueOf(trimEmpty));
            return this;
        }

        private void setTidyProperty(String key, String value) {
            if (this.tidyProperties == null) {
                this.tidyProperties = new Properties();
            }
            this.tidyProperties.setProperty(key, value);
        }

        public HtmlDomInspector build() {
            return new HtmlDomInspector(this);
        }
    }

    public static enum Encoding {
        UTF8,
        ASCII,
        DEFAULT;

    }
}

