/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.time;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.DiscreteDomain;
import com.google.common.math.DoubleMath;
import com.google.common.math.LongMath;
import com.google.errorprone.annotations.DoNotCall;
import java.math.RoundingMode;
import java.time.Instant;

@GwtCompatible
public final class Instants {
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final int NANOS_PER_MICRO = 1000;
    private static final int MICROS_PER_SECOND = 1000000;

    private Instants() {
    }

    public static double toEpochSeconds(Instant instant) {
        return (double)instant.getEpochSecond() + (double)instant.getNano() / 1.0E9;
    }

    public static Instant ofEpochSeconds(double seconds) {
        long wholeSeconds = DoubleMath.roundToLong(seconds, RoundingMode.FLOOR);
        long nanos = DoubleMath.roundToLong((seconds - (double)wholeSeconds) * 1.0E9, RoundingMode.FLOOR);
        return Instant.ofEpochSecond(wholeSeconds, nanos);
    }

    @Deprecated
    @DoNotCall(value="Use Instant.ofEpochSecond(long) instead.")
    public static Instant ofEpochSeconds(long seconds) {
        return Instant.ofEpochSecond(seconds);
    }

    public static long toEpochMicros(Instant instant) {
        long micros = LongMath.checkedMultiply(instant.getEpochSecond(), 1000000L);
        return LongMath.checkedAdd(micros, instant.getNano() / 1000);
    }

    public static Instant ofEpochMicros(long micros) {
        long seconds = LongMath.divide(micros, 1000000L, RoundingMode.FLOOR);
        int microsOfSecond = LongMath.mod(micros, 1000000);
        return Instant.ofEpochSecond(seconds, microsOfSecond * 1000);
    }

    public static long toEpochNanos(Instant instant) {
        long nanos = LongMath.checkedMultiply(instant.getEpochSecond(), 1000000000L);
        return LongMath.checkedAdd(nanos, instant.getNano());
    }

    public static Instant ofEpochNanos(long nanos) {
        long seconds = LongMath.divide(nanos, 1000000000L, RoundingMode.FLOOR);
        int nanosOfSecond = LongMath.mod(nanos, 1000000000);
        return Instant.ofEpochSecond(seconds, nanosOfSecond);
    }

    public static DiscreteDomain<Instant> domain() {
        return InstantDomain.INSTANCE;
    }

    private static final class InstantDomain
    extends DiscreteDomain<Instant> {
        private static final InstantDomain INSTANCE = new InstantDomain();

        private InstantDomain() {
        }

        @Override
        public Instant minValue() {
            return Instant.MIN;
        }

        @Override
        public Instant maxValue() {
            return Instant.MAX;
        }

        @Override
        public Instant next(Instant value) {
            return value.equals(this.maxValue()) ? null : value.plusNanos(1L);
        }

        @Override
        public Instant previous(Instant value) {
            return value.equals(this.minValue()) ? null : value.minusNanos(1L);
        }

        @Override
        public long distance(Instant start, Instant end) {
            long seconds = LongMath.saturatedSubtract(end.getEpochSecond(), start.getEpochSecond());
            long nanos = LongMath.saturatedMultiply(seconds, 1000000000L);
            return LongMath.saturatedAdd(nanos, end.getNano() - start.getNano());
        }

        public String toString() {
            return "Instants.domain()";
        }
    }
}

