/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.time;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Verify;
import com.google.common.time.Durations;
import com.google.common.time.Sleeper;
import java.time.Duration;

@GwtCompatible
final class Sleepers {
    private Sleepers() {
    }

    @GwtIncompatible
    static enum NoOpSleeper implements Sleeper
    {
        INSTANCE;


        @Override
        public void sleep(Duration duration) throws InterruptedException {
            Durations.checkNotNegative(duration);
        }

        public String toString() {
            return "Sleeper.noOpSleeper()";
        }
    }

    @GwtIncompatible
    static enum DefaultSleeper implements Sleeper
    {
        INSTANCE;


        @Override
        public void sleep(Duration duration) throws InterruptedException {
            Durations.checkNotNegative(duration);
            long millis = duration.toMillis();
            Duration nanosOnly = duration.minusMillis(millis);
            Verify.verify(nanosOnly.getSeconds() == 0L);
            int nanos = nanosOnly.getNano();
            Thread.sleep(millis, nanos);
        }

        public String toString() {
            return "Sleeper.defaultSleeper()";
        }
    }
}

