/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firebear.client;

import com.google.api.client.util.Strings;
import com.google.api.client.util.Throwables;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import com.google.common.labs.concurrent.RetryStrategy;
import com.google.common.labs.concurrent.RetryingFuture;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firebase.firebear.client.FirebearCertificateProviderInterface;
import com.google.gaia.mint.GetPublicCertificateForRobotRequest;
import com.google.gaia.mint.GetPublicCertificateForRobotResponse;
import com.google.gaia.mint.PublicCertificate;
import com.google.gaia.mint.credentials.RobotClient;
import com.google.thirdparty.jodatime.JodaSleeper;
import java.io.StringBufferInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.Duration;

@ThreadSafe
public class FirebearCertificateProvider
implements FirebearCertificateProviderInterface,
Runnable {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/firebear/client/FirebearCertificateProvider");
    private final RobotClient robotClient;
    private final long robotId;
    private final Duration refreshInterval;
    @GuardedBy(value="mutex")
    private ImmutableMap<String, X509Certificate> certificates;
    @GuardedBy(value="mutex")
    private boolean running;
    @GuardedBy(value="mutex")
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> scheduledFuture;
    private ReadWriteLock mutex;
    private final RetryStrategy retryStrategy;

    public FirebearCertificateProvider(RobotClient robotClient, long robotId, RetryStrategy retryStrategy, JodaSleeper sleeper, Duration refreshInterval, ScheduledExecutorService scheduledExecutorService) {
        this.robotClient = robotClient;
        this.robotId = robotId;
        this.refreshInterval = refreshInterval;
        this.mutex = new ReentrantReadWriteLock();
        this.scheduledExecutorService = scheduledExecutorService;
        this.retryStrategy = retryStrategy;
    }

    @Override
    @Nullable
    public X509Certificate getCertificate(String kid) {
        try {
            this.mutex.readLock().lock();
            Preconditions.checkState(this.running, "Not started.");
            X509Certificate x509Certificate = this.certificates.get(kid);
            return x509Certificate;
        }
        finally {
            this.mutex.readLock().unlock();
        }
    }

    public void start() {
        try {
            this.startAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public ListenableFuture<Void> startAsync() {
        try {
            this.mutex.writeLock().lock();
            if (this.running) {
                ListenableFuture<Object> listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            ListenableFuture<Void> listenableFuture = Futures.transform(this.refresh(), unusedVoid -> {
                try {
                    this.mutex.writeLock().lock();
                    if (!this.running) {
                        this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(this, this.refreshInterval.getMillis(), this.refreshInterval.getMillis(), TimeUnit.MILLISECONDS);
                        this.running = true;
                    }
                }
                finally {
                    this.mutex.writeLock().unlock();
                }
                return null;
            }, MoreExecutors.directExecutor());
            return listenableFuture;
        }
        finally {
            this.mutex.writeLock().unlock();
        }
    }

    @Override
    public void run() {
        try {
            Futures.addCallback(this.refresh(), new FutureCallback<Void>(this){

                @Override
                public void onSuccess(Void v) {
                }

                @Override
                public void onFailure(Throwable t) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(t)).withInjectedLogSite("com/google/firebase/firebear/client/FirebearCertificateProvider$1", "onFailure", 147, "FirebearCertificateProvider.java")).log("Ignoring error so that scheduler will schedule the next run.");
                }
            }, MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).withInjectedLogSite("com/google/firebase/firebear/client/FirebearCertificateProvider", "run", 154, "FirebearCertificateProvider.java")).log("Ignoring error so that scheduler will schedule the next run.");
        }
    }

    public void stop() {
        try {
            this.mutex.writeLock().lock();
            Preconditions.checkState(this.running, "Not started.");
            this.scheduledFuture.cancel(true);
            this.running = false;
        }
        finally {
            this.mutex.writeLock().unlock();
        }
    }

    private ListenableFuture<Void> refresh() {
        RetryingFuture newCertsFuture;
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/firebase/firebear/client/FirebearCertificateProvider", "refresh", 172, "FirebearCertificateProvider.java")).log("Refreshing the keys.");
        try {
            newCertsFuture = RetryingFuture.retryingFuture((Supplier)new Supplier<ListenableFuture<ImmutableMap<String, X509Certificate>>>(){

                @Override
                public ListenableFuture<ImmutableMap<String, X509Certificate>> get() {
                    return FirebearCertificateProvider.this.refreshOnce();
                }
            }, (RetryStrategy)this.retryStrategy, Predicates.alwaysTrue(), (Executor)MoreExecutors.directExecutor());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Unable to update the keys and all the retries are exhausted.", e);
        }
        return Futures.transform(newCertsFuture, newCerts -> {
            try {
                this.mutex.writeLock().lock();
                this.certificates = newCerts;
            }
            finally {
                this.mutex.writeLock().unlock();
            }
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/firebase/firebear/client/FirebearCertificateProvider", "lambda$refresh$1", 199, "FirebearCertificateProvider.java")).log("Keys has been refreshed successfully.");
            return null;
        }, MoreExecutors.directExecutor());
    }

    private ListenableFuture<ImmutableMap<String, X509Certificate>> refreshOnce() {
        GetPublicCertificateForRobotRequest req = new GetPublicCertificateForRobotRequest();
        req.setRobotGaiaId(this.robotId);
        ImmutableMap.Builder newCerts = ImmutableMap.builder();
        CheckedFuture responseFuture = this.robotClient.asyncGetPublicCertificateForRobot(req);
        return Futures.transform(responseFuture, response -> {
            try {
                if (response.getReturnCodeEnum() == GetPublicCertificateForRobotResponse.ReturnCode.SUCCESS) {
                    List certs = response.publicCertificateLists();
                    for (PublicCertificate cert : certs) {
                        String kid = cert.getKeyName();
                        if (Strings.isNullOrEmpty((String)cert.getX509CertificatePem())) continue;
                        newCerts.put(kid, (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new StringBufferInputStream(cert.getX509CertificatePem())));
                    }
                    return newCerts.build();
                }
                throw new RuntimeException(String.format("Unable to load certificates. Return code: %s Error message: %s", response.getReturnCodeEnum(), response.getErrorMessage()));
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }, MoreExecutors.directExecutor());
    }
}

