/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firebear.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.Instant;

public class JsonHelper {
    private final JsonObject jsonObject;

    private JsonHelper(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Nullable
    public String getParamAsString(String name) {
        JsonPrimitive primitive = this.getParamAsPrimitive(name);
        if (primitive != null && primitive.isString()) {
            return primitive.getAsString();
        }
        return null;
    }

    @Nullable
    public Long getParamAsLong(String name) {
        JsonPrimitive primitive = this.getParamAsPrimitive(name);
        if (primitive != null && primitive.isNumber()) {
            return primitive.getAsNumber().longValue();
        }
        return null;
    }

    @Nullable
    public Instant getParamAsInstant(String name, TimeUnit timeUnit) {
        Long timeInEpochSeconds = this.getParamAsLong(name);
        if (timeInEpochSeconds == null) {
            return null;
        }
        return new Instant(timeUnit.toMillis(timeInEpochSeconds));
    }

    @Nullable
    private JsonPrimitive getParamAsPrimitive(String name) {
        JsonElement element = this.jsonObject.get(name);
        if (element != null && element.isJsonPrimitive()) {
            return (JsonPrimitive)element;
        }
        return null;
    }

    public static JsonHelper forObject(JsonObject jsonObject) {
        return new JsonHelper(jsonObject);
    }
}

