/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firebear.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import com.google.firebase.firebear.client.JsonHelper;
import com.google.firebase.firebear.client.JwtVerificationException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.joda.time.Instant;

public class JwtToken {
    private static final int HEADER_INDEX = 0;
    private static final int PAYLOAD_INDEX = 1;
    private static final int SIGNATURE_INDEX = 2;
    private static final char JWT_SEGMENT_SEPARATOR = '.';
    private static final String KEY_ID_HEADER = "kid";
    private static final String ISSUER = "iss";
    private static final String ISSUED_AT = "iat";
    private static final String EXPIRATION = "exp";
    private static final String AUDIENCE = "aud";
    private static final String SUBJECT = "sub";
    private final JsonObject payload;
    private final JsonObject header;
    private final byte[] signature;
    private final JsonHelper payloadJsonHelper;
    private final JsonHelper headerJsonHelper;
    private final String baseString;
    private static JsonParser parser = new JsonParser();
    private static final BaseEncoding BASE_64_URL = BaseEncoding.base64Url();

    public JwtToken(JsonObject payload, JsonObject header, byte[] signature, String baseString) {
        this.payload = Preconditions.checkNotNull(payload);
        this.header = Preconditions.checkNotNull(header);
        this.signature = Preconditions.checkNotNull(signature);
        this.payloadJsonHelper = JsonHelper.forObject(payload);
        this.headerJsonHelper = JsonHelper.forObject(header);
        this.baseString = baseString;
    }

    public JsonObject getPayload() {
        return this.payload;
    }

    public JsonObject getHeader() {
        return this.header;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getIssuer() {
        return this.payloadJsonHelper.getParamAsString(ISSUER);
    }

    public Instant getIssuedAt() {
        return this.payloadJsonHelper.getParamAsInstant(ISSUED_AT, TimeUnit.SECONDS);
    }

    public Instant getExpiresAt() {
        return this.payloadJsonHelper.getParamAsInstant(EXPIRATION, TimeUnit.SECONDS);
    }

    public String getAudience() {
        return this.payloadJsonHelper.getParamAsString(AUDIENCE);
    }

    public String getSubject() {
        return this.payloadJsonHelper.getParamAsString(SUBJECT);
    }

    public String getKeyId() {
        return this.headerJsonHelper.getParamAsString(KEY_ID_HEADER);
    }

    public String getBaseString() {
        return this.baseString;
    }

    public static JwtToken deserialize(CharSequence jwt) throws JwtVerificationException {
        byte[] signatureBytes;
        JsonObject payloadJson;
        JsonObject headerJson;
        ImmutableList<String> segments = ImmutableList.copyOf(Splitter.on('.').split(jwt));
        if (segments.size() != 3) {
            throw new JwtVerificationException("Invalid JWT Token. The JWT Token should consist of three parts separated by dot.", JwtVerificationException.Reason.INVALID);
        }
        String header = (String)segments.get(0);
        String payload = (String)segments.get(1);
        String signature = (String)segments.get(2);
        try {
            headerJson = JwtToken.base64ToJson(header);
        }
        catch (JsonSyntaxException | IllegalArgumentException | IllegalStateException | CharacterCodingException e) {
            throw new JwtVerificationException("Invalid Json jwt header", JwtVerificationException.Reason.INVALID);
        }
        try {
            payloadJson = JwtToken.base64ToJson(payload);
        }
        catch (JsonSyntaxException | IllegalArgumentException | IllegalStateException | CharacterCodingException e) {
            throw new JwtVerificationException("Invalid Json jwt payload", JwtVerificationException.Reason.INVALID);
        }
        try {
            signatureBytes = BASE_64_URL.decode(signature);
        }
        catch (IllegalArgumentException ex) {
            throw new JwtVerificationException("Failed to validate signature.", ex, JwtVerificationException.Reason.BAD_SIGNATURE);
        }
        return new JwtToken(payloadJson, headerJson, signatureBytes, new StringBuilder(1 + String.valueOf(header).length() + String.valueOf(payload).length()).append(header).append('.').append(payload).toString());
    }

    private static JsonObject base64ToJson(String encoded) throws JsonSyntaxException, CharacterCodingException, IllegalArgumentException {
        String decodedString = new String(BASE_64_URL.decode(encoded), StandardCharsets.UTF_8);
        return parser.parse(decodedString).getAsJsonObject();
    }
}

