/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang;

import com.google.api.tools.expr.parser.StringDecoder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.firebase.rules.lang.FirebaseRulesIssueListener;
import com.google.firebase.rules.lang.FirebaseRulesParser;
import com.google.firebase.rules.lang.SourcePositionFactory;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.lang.common.UrlEncoder;
import com.google.firebase.rules.runtime.v1.CallExpression;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.Function;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.runtime.v1.ListExpression;
import com.google.firebase.rules.runtime.v1.Literal;
import com.google.firebase.rules.runtime.v1.MapExpression;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.Member;
import com.google.firebase.rules.runtime.v1.Path;
import com.google.firebase.rules.runtime.v1.Permission;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.runtime.v1.ServiceRule;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.firebase.rules.v1.TestRulesetResponse;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.i18n.MessageReference;
import com.google.i18n.MessageReference0;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringEscapeUtils;

public class FirebaseRulesProtoAstGenerator {
    private static final ImmutableMap<Integer, FunctionTemplate> BUILT_IN_FUNCTION_NAME_MAP = ImmutableMap.builder().put(21, FunctionTemplate.BuiltInUnaryOperator.BOOLEAN_NOT).put(29, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInMathOperator.MULTIPLY)).put(28, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInMathOperator.DIVIDE)).put(19, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInMathOperator.MODULUS)).put(23, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInMathOperator.ADD)).put(18, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInMathOperator.MINUS)).put(10, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInBooleanOperator.GREATER_THAN)).put(11, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInBooleanOperator.GREATER_THAN_OR_EQUALS)).put(16, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInBooleanOperator.LESS_THAN)).put(17, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInBooleanOperator.LESS_THAN_OR_EQUALS)).put(9, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInBooleanOperator.EQUALS)).put(20, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInBooleanOperator.NOT_EQUALS)).put(1, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInBooleanOperator.BOOLEAN_AND)).put(22, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInBooleanOperator.BOOLEAN_OR)).put(36, (FunctionTemplate.BuiltInUnaryOperator)((Object)FunctionTemplate.BuiltInBooleanOperator.IS_TYPE)).build();
    private static final Literal.Builder NULL_LITERAL = Literal.newBuilder().setNullValue(Literal.NullValue.NULL_VALUE);
    private static final String RULES_1_VERSION_STRING = "1";
    private static final String RULES_2_VERSION_STRING = "2";
    private static final int MAX_ALLOWED_EXPRESSION_DEPTH = 100;
    public static final int MAX_ALLOWED_RULE_DEPTH = 64;
    private final Collection<FirebaseRulesIssueListener> issueClients;
    private final SourcePositionFactory sourcePositionFactory;
    private final boolean allowVersionTwo;
    private final boolean allowByteLiterals;
    private int nestedRuleDepth;
    private int nestedExpressionDepth;

    public FirebaseRulesProtoAstGenerator(SourcePositionFactory sourcePositionFactory, boolean allowVersionTwo, boolean allowByteLiterals) {
        this.allowVersionTwo = allowVersionTwo;
        this.allowByteLiterals = allowByteLiterals;
        this.issueClients = Sets.newHashSet();
        this.sourcePositionFactory = sourcePositionFactory;
    }

    RulesetAst.Builder generateCode(FirebaseRulesParser parser) {
        return this.visitRuleset(parser.ruleset());
    }

    void addIssueListener(FirebaseRulesIssueListener issueListener) {
        this.issueClients.add(issueListener);
    }

    private RulesetAst.Builder visitRuleset(FirebaseRulesParser.RulesetContext ctx) {
        RulesetAst.Builder rulesetAst = RulesetAst.newBuilder();
        this.setVersion(ctx, rulesetAst);
        for (FirebaseRulesParser.RulesetStatementContext statementCtx : ctx.rulesetStatement()) {
            FirebaseRulesParser.ServiceDeclarationContext serviceDeclaration;
            FirebaseRulesParser.FunctionDeclarationContext funcDeclCtx = statementCtx.functionDeclaration();
            if (funcDeclCtx != null) {
                Function.Builder funcDecl = this.extractFunctionDeclaration(funcDeclCtx);
                rulesetAst.addFunctions(funcDecl);
            }
            if ((serviceDeclaration = statementCtx.serviceDeclaration()) == null) continue;
            ServiceRule.Builder serviceRule = this.extractServiceDeclaration(rulesetAst.getVersion(), serviceDeclaration);
            rulesetAst.addServiceRules(serviceRule);
        }
        return rulesetAst;
    }

    private ServiceRule.Builder extractServiceDeclaration(RulesetAst.Version version, FirebaseRulesParser.ServiceDeclarationContext serviceDefinition) {
        ServiceRule.Builder serviceRule = ServiceRule.newBuilder();
        serviceRule.setServiceName(this.makeIdentifier(serviceDefinition.serviceId()));
        if (serviceDefinition.serviceStatement() != null) {
            for (FirebaseRulesParser.ServiceStatementContext serviceStatementContext : serviceDefinition.serviceStatement()) {
                this.extractServiceStatement(version, serviceRule, serviceStatementContext);
            }
        }
        return serviceRule;
    }

    private void extractServiceStatement(RulesetAst.Version version, ServiceRule.Builder serviceRule, FirebaseRulesParser.ServiceStatementContext serviceStatementContext) {
        if (serviceStatementContext.functionDeclaration() != null) {
            serviceRule.addFunctions(this.extractFunctionDeclaration(serviceStatementContext.functionDeclaration()));
        } else if (serviceStatementContext.matchRuleDeclaration() != null) {
            serviceRule.addMatchRules(this.extractMatchRuleDeclaration(version, serviceStatementContext.matchRuleDeclaration()));
        } else {
            throw this.handleInvalidContext(serviceStatementContext);
        }
    }

    private void setVersion(FirebaseRulesParser.RulesetContext ctx, RulesetAst.Builder rulesetAst) {
        String declaredSyntax;
        if (ctx.versionStatement() == null) {
            rulesetAst.setVersion(RulesetAst.Version.VERSION_1);
            return;
        }
        switch (declaredSyntax = this.extractStringFromQuotes(ctx.versionStatement().STRING().getText())) {
            case "1": {
                rulesetAst.setVersion(RulesetAst.Version.VERSION_1);
                break;
            }
            case "2": {
                if (this.allowVersionTwo) {
                    rulesetAst.setVersion(RulesetAst.Version.VERSION_2);
                    break;
                }
            }
            default: {
                this.reportIssue(CompilationIssueUtils.makeError(this.getPosition(ctx.versionStatement()), (MessageReference)FirebaseRulesMessages.UNSUPPORTED_RULES_VERSION, declaredSyntax));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MatchRule.Builder extractMatchRuleDeclaration(RulesetAst.Version version, FirebaseRulesParser.MatchRuleDeclarationContext ctx) {
        ++this.nestedRuleDepth;
        try {
            if (this.nestedRuleDepth >= 64) {
                this.reportIssue(CompilationIssueUtils.makeError(this.getPosition(ctx), (MessageReference)FirebaseRulesMessages.RULE_HIERARCHY_TOO_COMPLEX, new String[0]));
                MatchRule.Builder builder = MatchRule.newBuilder();
                return builder;
            }
            MatchRule.Builder matchRule = MatchRule.newBuilder();
            matchRule.setSourcePosition(this.getPosition(ctx));
            matchRule.setPath(this.extractPath(version, ctx.pathDecl()));
            List<FirebaseRulesParser.MatchStatementContext> matchStatements = ctx.matchStatement();
            for (FirebaseRulesParser.MatchStatementContext matchStatement : matchStatements) {
                FirebaseRulesParser.MatchRuleDeclarationContext nestedRuleDeclCtx;
                FirebaseRulesParser.PermissionDeclarationContext permDeclCtx;
                FirebaseRulesParser.FunctionDeclarationContext funcDeclCtx = matchStatement.functionDeclaration();
                if (funcDeclCtx != null) {
                    Function.Builder funcDecl = this.extractFunctionDeclaration(funcDeclCtx);
                    matchRule.addFunctions(funcDecl);
                }
                if ((permDeclCtx = matchStatement.permissionDeclaration()) != null) {
                    Permission.Builder permDecl = this.extractPermissionDeclaration(permDeclCtx);
                    matchRule.addPermissions(permDecl);
                }
                if ((nestedRuleDeclCtx = matchStatement.matchRuleDeclaration()) == null) continue;
                MatchRule.Builder nestedRuleDecl = this.extractMatchRuleDeclaration(version, nestedRuleDeclCtx);
                matchRule.addMatchRules(nestedRuleDecl);
            }
            MatchRule.Builder builder = matchRule;
            return builder;
        }
        finally {
            --this.nestedRuleDepth;
        }
    }

    private Path extractPath(RulesetAst.Version version, FirebaseRulesParser.PathDeclContext context) {
        Preconditions.checkArgument(version != RulesetAst.Version.UNRECOGNIZED, "unknown rules version");
        Path.Builder path = Path.newBuilder();
        HashSet<String> binds = Sets.newHashSet();
        List<FirebaseRulesParser.PathDeclSegmentContext> segments = context.pathDeclSegment();
        int lastSegmentIndex = segments.size() - 1;
        int segmentIndex = 0;
        int numGlobs = 0;
        for (FirebaseRulesParser.PathDeclSegmentContext segment : segments) {
            MessageReference0 globErrorMesssage = null;
            switch (version) {
                case VERSION_UNSPECIFIED: 
                case VERSION_1: {
                    if (segmentIndex == lastSegmentIndex) break;
                    globErrorMesssage = FirebaseRulesMessages.GLOB_MATCH_IN_MIDDLE_OF_PATH;
                    break;
                }
                case VERSION_2: {
                    if (numGlobs <= 0) break;
                    globErrorMesssage = FirebaseRulesMessages.ONLY_ONE_GLOB_PERMITTED;
                    break;
                }
                case UNRECOGNIZED: {
                    throw new AssertionError((Object)"unreachable");
                }
            }
            Path.PathSegment pathSegment = this.extractPathDeclSegment(segment, binds, globErrorMesssage);
            path.addSegments(pathSegment);
            if (pathSegment.hasGlobCapture()) {
                ++numGlobs;
            }
            ++segmentIndex;
        }
        return path.build();
    }

    private Path.PathSegment extractPathDeclSegment(FirebaseRulesParser.PathDeclSegmentContext segment, Set<String> binds, @Nullable MessageReference globErrorMessage) {
        if (segment instanceof FirebaseRulesParser.SimpleSegmemntContext) {
            FirebaseRulesParser.SimpleSegmemntContext ctx = (FirebaseRulesParser.SimpleSegmemntContext)segment;
            return Path.PathSegment.newBuilder().setExpression(Expression.newBuilder().setSourcePosition(this.getPosition(ctx.PATH_SEGMENT().getSymbol())).setLiteral(Literal.newBuilder().setStringValue(this.getPathSegmentText(ctx.PATH_SEGMENT())))).build();
        }
        if (segment instanceof FirebaseRulesParser.CaptureSegmentContext) {
            FirebaseRulesParser.CaptureSegmentContext ctx = (FirebaseRulesParser.CaptureSegmentContext)segment;
            Identifier capture = this.makeIdentifier(ctx.capture().localVariableId()).build();
            this.ensureUniqueCapture(binds, capture);
            return Path.PathSegment.newBuilder().setCapture(capture).build();
        }
        if (segment instanceof FirebaseRulesParser.GlobSegmentContext) {
            FirebaseRulesParser.GlobSegmentContext ctx = (FirebaseRulesParser.GlobSegmentContext)segment;
            if (globErrorMessage != null) {
                this.reportIssue(CompilationIssueUtils.makeError(this.getPosition(ctx), globErrorMessage, new String[0]));
            }
            Identifier globCapture = this.makeIdentifier(ctx.globCapture().localVariableId()).build();
            this.ensureUniqueCapture(binds, globCapture);
            return Path.PathSegment.newBuilder().setGlobCapture(globCapture).build();
        }
        if (segment instanceof FirebaseRulesParser.EmptySegmentContext) {
            return Path.PathSegment.getDefaultInstance();
        }
        throw this.handleInvalidContext(segment);
    }

    private Function.Builder extractFunctionDeclaration(FirebaseRulesParser.FunctionDeclarationContext ctx) {
        Function.Builder function = Function.newBuilder();
        if (ctx.localFunctionId() != null) {
            function.setId(this.makeIdentifier(ctx.localFunctionId()));
        }
        if (ctx.functionSignature() != null && ctx.functionSignature().paramList() != null) {
            for (FirebaseRulesParser.LocalVariableIdContext variableIdContext : ctx.functionSignature().paramList().localVariableId()) {
                function.addParamsIds(this.makeIdentifier(variableIdContext));
            }
        }
        if (ctx.functionBody() != null) {
            Expression.Builder bodyExpression = this.extractExpression(ctx.functionBody().functionStatement().expression());
            function.setBody(bodyExpression);
        }
        return function;
    }

    private Permission.Builder extractPermissionDeclaration(FirebaseRulesParser.PermissionDeclarationContext ctx) {
        Permission.Builder perm = Permission.newBuilder();
        if (ctx.operationId() != null) {
            for (FirebaseRulesParser.IdContext idContext : ctx.operationId().id()) {
                perm.addIds(this.makeIdentifier(idContext));
            }
        }
        if (ctx.permissionBody() != null && ctx.permissionBody().expression() != null) {
            perm.setAllow(this.extractExpression(ctx.permissionBody().expression()));
        } else if (ctx.operationId() != null) {
            perm.setAllow(Expression.newBuilder().setLiteral(Literal.newBuilder().setBoolValue(true)).setSourcePosition(this.getPosition(ctx.operationId())));
        }
        return perm;
    }

    private Expression.Builder extractUnaryAdditiveExpression(FirebaseRulesParser.UnaryAdditiveExpressionContext ctx) {
        Preconditions.checkArgument(ctx.op.getType() == 18);
        if (ctx.stop.getText().equals("9223372036854775808")) {
            return Expression.newBuilder().setLiteral(Literal.newBuilder().setLongValue(Long.MIN_VALUE));
        }
        FunctionTemplate.BuiltInUnaryOperator functionTemplate = FunctionTemplate.BuiltInUnaryOperator.NEGATE_NUMBER;
        CallExpression.Builder callExpr = CallExpression.newBuilder();
        callExpr.setFunctionName(this.makeIdentifier(functionTemplate.getFunctionName(), ctx.op));
        Expression.Builder argumentExpr = this.extractSimpleExpression(ctx.simpleExpression());
        callExpr.addArguments(argumentExpr);
        return this.expression(callExpr, this.getPosition(ctx));
    }

    private Expression.Builder extractNotExpression(FirebaseRulesParser.NotExpressionContext ctx) {
        return this.extractOperator(ctx.op, ctx.expression());
    }

    private Expression.Builder extractMultiplicativeExpression(FirebaseRulesParser.MultiplicativeExpressionContext ctx) {
        return this.extractOperator(ctx.op, ctx.expression(0), ctx.expression(1));
    }

    private Expression.Builder extractAdditiveExpression(FirebaseRulesParser.AdditiveExpressionContext ctx) {
        return this.extractOperator(ctx.op, ctx.expression(0), ctx.expression(1));
    }

    private Expression.Builder extractRelationalExpression(FirebaseRulesParser.RelationalExpressionContext ctx) {
        return this.extractOperator(ctx.op, ctx.expression(0), ctx.expression(1));
    }

    private Expression.Builder extractEqualityExpression(FirebaseRulesParser.EqualityExpressionContext ctx) {
        return this.extractOperator(ctx.op, ctx.expression(0), ctx.expression(1));
    }

    private Expression.Builder extractLogicalAndExpression(FirebaseRulesParser.LogicalAndExpressionContext ctx) {
        return this.extractOperator(ctx.op, ctx.expression(0), ctx.expression(1));
    }

    private Expression.Builder extractLogicalOrExpression(FirebaseRulesParser.LogicalOrExpressionContext ctx) {
        return this.extractOperator(ctx.op, ctx.expression(0), ctx.expression(1));
    }

    private Expression.Builder extractIsTypeExpression(FirebaseRulesParser.ExprIsTypeIdExpressionContext ctx) {
        Token operator = ctx.op;
        FunctionTemplate functionTemplate = BUILT_IN_FUNCTION_NAME_MAP.get(operator.getType());
        String string = String.valueOf(operator);
        Preconditions.checkNotNull(functionTemplate, new StringBuilder(22 + String.valueOf(string).length()).append("Cannot find operator: ").append(string).toString());
        CallExpression.Builder callExpr = CallExpression.newBuilder().setFunctionName(this.makeIdentifier(functionTemplate.getFunctionName(), operator)).addArguments(this.extractExpression(ctx.expression())).addArguments(this.extractType(ctx.isOperatorId()));
        return this.expression(callExpr, this.getPosition(ctx));
    }

    private Expression.Builder extractInExpression(FirebaseRulesParser.ExprInExpressionContext ctx) {
        CallExpression.Builder callExpr = CallExpression.newBuilder().setFunctionName(Identifier.newBuilder().setSourcePosition(this.getPosition(ctx.op)).setName(FunctionTemplate.IN.getFunctionName())).setOperand(this.extractExpression(ctx.expression().get(1))).addArguments(this.extractExpression(ctx.expression().get(0)));
        return this.expression(callExpr, this.getPosition(ctx));
    }

    private Expression.Builder extractParenSimpleExpression(FirebaseRulesParser.ParenSimpleExpressionContext ctx) {
        return this.extractExpression(ctx.expression());
    }

    private Expression.Builder extractListSimpleExpression(FirebaseRulesParser.ListSimpleExpressionContext ctx) {
        ListExpression.Builder listExpression = ListExpression.newBuilder();
        FirebaseRulesParser.ExpressionListContext expressionListContext = ctx.expressionList();
        if (expressionListContext != null && expressionListContext.expression() != null) {
            for (FirebaseRulesParser.ExpressionContext exprCtx : expressionListContext.expression()) {
                listExpression.addExpressions(this.extractExpression(exprCtx));
            }
        }
        return this.expression(listExpression, this.getPosition(ctx));
    }

    private Expression.Builder extractType(FirebaseRulesParser.IsOperatorIdContext ctx) {
        return this.expression(Literal.newBuilder().setStringValue(ctx.getText()), this.getPosition(ctx));
    }

    private Expression.Builder extractMapSimpleExpression(FirebaseRulesParser.MapSimpleExpressionContext ctx) {
        MapExpression.Builder mapExpression = MapExpression.newBuilder();
        if (ctx.mapExpression().mapEntries() != null) {
            for (FirebaseRulesParser.MapEntryContext mapEntryContext : ctx.mapExpression().mapEntries().mapEntry()) {
                if (mapEntryContext.expression().size() != 2) continue;
                mapExpression.addKeys(this.extractExpression(mapEntryContext.expression().get(0)));
                mapExpression.addValues(this.extractExpression(mapEntryContext.expression().get(1)));
            }
        }
        return this.expression(mapExpression, this.getPosition(ctx));
    }

    private Expression.Builder extractMemberFunctionCallSimpleExpression(FirebaseRulesParser.MemberFunctionCallSimpleExpressionContext ctx) {
        Expression.Builder operand = this.extractSimpleExpression(ctx.simpleExpression());
        Identifier.Builder functionName = this.makeIdentifier(ctx.memberId());
        CallExpression.Builder callExpr = CallExpression.newBuilder().setFunctionName(functionName).setOperand(operand);
        this.extractCallArguments(callExpr, ctx.expressionList());
        return this.expression(callExpr, this.getPosition(ctx));
    }

    public Expression.Builder extractFunctionCallSimpleExpression(FirebaseRulesParser.FunctionCallSimpleExpressionContext ctx) {
        Identifier.Builder functionName = this.makeIdentifier(ctx.localFunctionId());
        CallExpression.Builder callExpr = CallExpression.newBuilder().setFunctionName(functionName);
        FirebaseRulesParser.ExpressionListContext argumentExprCtxs = ctx.expressionList();
        this.extractCallArguments(callExpr, argumentExprCtxs);
        return this.expression(callExpr, this.getPosition(ctx));
    }

    public Expression.Builder extractPackagedFunctionCallSimpleExpression(FirebaseRulesParser.PackagedFunctionCallSimpleExpressionContext ctx) {
        Identifier.Builder functionName = this.makeIdentifier(ctx.packageFunctionId());
        Identifier.Builder packageName = this.makeIdentifier(ctx.packageId());
        CallExpression.Builder callExpr = CallExpression.newBuilder().setFunctionName(functionName).setPackageName(packageName);
        FirebaseRulesParser.ExpressionListContext argumentExprCtxs = ctx.expressionList();
        this.extractCallArguments(callExpr, argumentExprCtxs);
        return this.expression(callExpr, this.getPosition(ctx));
    }

    private void extractCallArguments(CallExpression.Builder callExpr, FirebaseRulesParser.ExpressionListContext argumentExprCtxs) {
        if (argumentExprCtxs != null) {
            List<Expression.Builder> args = this.extractExpressionList(argumentExprCtxs.expression());
            for (Expression.Builder arg : args) {
                callExpr.addArguments(arg);
            }
        }
    }

    private Expression.Builder extractMemberLookupSimpleExpression(FirebaseRulesParser.MemberLookupSimpleExpressionContext ctx) {
        Expression.Builder operand = this.extractSimpleExpression(ctx.simpleExpression());
        Identifier.Builder id = this.makeIdentifier(ctx.keywordId());
        Member.Builder memberExpr = Member.newBuilder().setId(id).setOperand(operand);
        return this.expression(memberExpr, this.getPosition(ctx));
    }

    private Expression.Builder extractListLookupSimpleExpression(FirebaseRulesParser.ListLookupSimpleExpressionContext ctx) {
        Expression.Builder operand = this.extractSimpleExpression(ctx.simpleExpression());
        CallExpression.Builder callExpr = CallExpression.newBuilder().setOperand(operand);
        if (ctx.listIndex() instanceof FirebaseRulesParser.IndexLookupContext) {
            FirebaseRulesParser.IndexLookupContext indexCtx = (FirebaseRulesParser.IndexLookupContext)ctx.listIndex();
            callExpr.setFunctionName(this.makeIdentifier(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX.getFunctionName(), ctx));
            callExpr.addArguments(this.extractExpression(indexCtx.expression()));
        } else if (ctx.listIndex() instanceof FirebaseRulesParser.RangeLookupContext) {
            callExpr.setFunctionName(this.makeIdentifier(FunctionTemplate.BuiltInRangeFunction.LOOKUP_RANGE.getFunctionName(), ctx));
            FirebaseRulesParser.RangeLookupContext rangeLookupCtx = (FirebaseRulesParser.RangeLookupContext)ctx.listIndex();
            if (rangeLookupCtx.expr1 != null) {
                callExpr.addArguments(this.extractExpression(rangeLookupCtx.expr1));
            } else {
                callExpr.addArguments(this.expression(NULL_LITERAL, this.getPosition(ctx)));
            }
            if (rangeLookupCtx.expr2 != null) {
                callExpr.addArguments(this.extractExpression(rangeLookupCtx.expr2));
            } else {
                callExpr.addArguments(this.expression(NULL_LITERAL, this.getPosition(ctx)));
            }
        } else {
            throw this.handleInvalidContext(ctx);
        }
        return this.expression(callExpr, this.getPosition(ctx));
    }

    private Expression.Builder extractVariableSimpleExpression(FirebaseRulesParser.VariableSimpleExpressionContext ctx) {
        return this.expression(Member.newBuilder().setId(this.makeIdentifier(ctx.localVariableId())), this.getPosition(ctx));
    }

    private Expression.Builder extractPathSimpleExpression(FirebaseRulesParser.PathSimpleExpressionContext context) {
        Path.Builder path = Path.newBuilder();
        List<FirebaseRulesParser.PathExpressionSegmentContext> segments = context.pathExpression().pathExpressionSegment();
        HashSet<String> binds = Sets.newHashSet();
        for (FirebaseRulesParser.PathExpressionSegmentContext segment : segments) {
            path.addSegments(this.extractPathExpressionSegment(context, segment, binds));
        }
        return Expression.newBuilder().setPath(path.build()).setSourcePosition(this.getPosition(context));
    }

    private Path.PathSegment extractPathExpressionSegment(FirebaseRulesParser.PathSimpleExpressionContext context, FirebaseRulesParser.PathExpressionSegmentContext segment, Set<String> binds) {
        if (segment.expression() != null) {
            return Path.PathSegment.newBuilder().setExpression(this.extractExpression(segment.expression())).build();
        }
        if (segment.pathDeclSegment() != null) {
            FirebaseRulesParser.PathDeclSegmentContext pathDeclSegment = segment.pathDeclSegment();
            return this.extractPathDeclSegment(pathDeclSegment, binds, null);
        }
        throw this.handleInvalidContext(context);
    }

    private String getPathSegmentText(TerminalNode pathSegmentNode) {
        String pathSegmentToDecode = pathSegmentNode.getText().substring(1);
        try {
            return UrlEncoder.decode(pathSegmentToDecode);
        }
        catch (UrlEncoder.UrlDecodingException e) {
            this.reportIssue(CompilationIssueUtils.makeError(this.getPosition(pathSegmentNode), (MessageReference)FirebaseRulesMessages.URL_DECODE_ERROR, pathSegmentToDecode, e.getMessage()));
            return "";
        }
    }

    private void ensureUniqueCapture(Set<String> binds, Identifier identifier) {
        if (binds.contains(identifier.getName())) {
            this.reportIssue(CompilationIssueUtils.makeError(identifier, (MessageReference)FirebaseRulesMessages.BIND_REDEFINITION, identifier.getName()));
        }
        binds.add(identifier.getName());
    }

    private Expression.Builder extractLiteralExpression(FirebaseRulesParser.LiteralExpressionContext ctx) {
        return Expression.newBuilder().setLiteral(this.extractLiteral(ctx.literal()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression.Builder extractExpression(FirebaseRulesParser.ExpressionContext ctx) {
        SourcePosition position = this.getPosition(ctx);
        ++this.nestedExpressionDepth;
        try {
            Expression.Builder expr;
            if (this.nestedExpressionDepth >= 100) {
                this.reportIssue(CompilationIssueUtils.makeError(position, (MessageReference)FirebaseRulesMessages.EXPRESSION_TOO_COMPLEX, new String[0]));
                Expression.Builder builder = Expression.newBuilder();
                return builder;
            }
            if (ctx instanceof FirebaseRulesParser.PrimaryExpressionContext) {
                expr = this.extractSimpleExpression(((FirebaseRulesParser.PrimaryExpressionContext)ctx).simpleExpression());
            } else if (ctx instanceof FirebaseRulesParser.UnaryAdditiveExpressionContext) {
                expr = this.extractUnaryAdditiveExpression((FirebaseRulesParser.UnaryAdditiveExpressionContext)ctx);
            } else if (ctx instanceof FirebaseRulesParser.NotExpressionContext) {
                expr = this.extractNotExpression((FirebaseRulesParser.NotExpressionContext)ctx);
            } else if (ctx instanceof FirebaseRulesParser.MultiplicativeExpressionContext) {
                expr = this.extractMultiplicativeExpression((FirebaseRulesParser.MultiplicativeExpressionContext)ctx);
            } else if (ctx instanceof FirebaseRulesParser.AdditiveExpressionContext) {
                expr = this.extractAdditiveExpression((FirebaseRulesParser.AdditiveExpressionContext)ctx);
            } else if (ctx instanceof FirebaseRulesParser.RelationalExpressionContext) {
                expr = this.extractRelationalExpression((FirebaseRulesParser.RelationalExpressionContext)ctx);
            } else if (ctx instanceof FirebaseRulesParser.EqualityExpressionContext) {
                expr = this.extractEqualityExpression((FirebaseRulesParser.EqualityExpressionContext)ctx);
            } else if (ctx instanceof FirebaseRulesParser.LogicalAndExpressionContext) {
                expr = this.extractLogicalAndExpression((FirebaseRulesParser.LogicalAndExpressionContext)ctx);
            } else if (ctx instanceof FirebaseRulesParser.LogicalOrExpressionContext) {
                expr = this.extractLogicalOrExpression((FirebaseRulesParser.LogicalOrExpressionContext)ctx);
            } else if (ctx instanceof FirebaseRulesParser.ExprIsTypeIdExpressionContext) {
                expr = this.extractIsTypeExpression((FirebaseRulesParser.ExprIsTypeIdExpressionContext)ctx);
            } else if (ctx instanceof FirebaseRulesParser.ExprInExpressionContext) {
                expr = this.extractInExpression((FirebaseRulesParser.ExprInExpressionContext)ctx);
            } else if (ctx instanceof FirebaseRulesParser.UnsupportedAdditivePostfixContext || ctx instanceof FirebaseRulesParser.UnsupportedAdditivePrefixContext) {
                expr = Expression.newBuilder();
            } else {
                throw this.handleInvalidContext(ctx);
            }
            expr.setSourcePosition(position);
            Expression.Builder builder = expr;
            return builder;
        }
        finally {
            --this.nestedExpressionDepth;
        }
    }

    private Expression.Builder extractSimpleExpression(FirebaseRulesParser.SimpleExpressionContext ctx) {
        Expression.Builder expr;
        if (ctx instanceof FirebaseRulesParser.ParenSimpleExpressionContext) {
            expr = this.extractParenSimpleExpression((FirebaseRulesParser.ParenSimpleExpressionContext)ctx);
        } else if (ctx instanceof FirebaseRulesParser.ListSimpleExpressionContext) {
            expr = this.extractListSimpleExpression((FirebaseRulesParser.ListSimpleExpressionContext)ctx);
        } else if (ctx instanceof FirebaseRulesParser.MapSimpleExpressionContext) {
            expr = this.extractMapSimpleExpression((FirebaseRulesParser.MapSimpleExpressionContext)ctx);
        } else if (ctx instanceof FirebaseRulesParser.PackagedFunctionCallSimpleExpressionContext) {
            expr = this.extractPackagedFunctionCallSimpleExpression((FirebaseRulesParser.PackagedFunctionCallSimpleExpressionContext)ctx);
        } else if (ctx instanceof FirebaseRulesParser.MemberFunctionCallSimpleExpressionContext) {
            expr = this.extractMemberFunctionCallSimpleExpression((FirebaseRulesParser.MemberFunctionCallSimpleExpressionContext)ctx);
        } else if (ctx instanceof FirebaseRulesParser.MemberLookupSimpleExpressionContext) {
            expr = this.extractMemberLookupSimpleExpression((FirebaseRulesParser.MemberLookupSimpleExpressionContext)ctx);
        } else if (ctx instanceof FirebaseRulesParser.ListLookupSimpleExpressionContext) {
            expr = this.extractListLookupSimpleExpression((FirebaseRulesParser.ListLookupSimpleExpressionContext)ctx);
        } else if (ctx instanceof FirebaseRulesParser.FunctionCallSimpleExpressionContext) {
            expr = this.extractFunctionCallSimpleExpression((FirebaseRulesParser.FunctionCallSimpleExpressionContext)ctx);
        } else if (ctx instanceof FirebaseRulesParser.VariableSimpleExpressionContext) {
            expr = this.extractVariableSimpleExpression((FirebaseRulesParser.VariableSimpleExpressionContext)ctx);
        } else if (ctx instanceof FirebaseRulesParser.PathSimpleExpressionContext) {
            expr = this.extractPathSimpleExpression((FirebaseRulesParser.PathSimpleExpressionContext)ctx);
        } else if (ctx instanceof FirebaseRulesParser.LiteralExpressionContext) {
            expr = this.extractLiteralExpression((FirebaseRulesParser.LiteralExpressionContext)ctx);
        } else {
            throw this.handleInvalidContext(ctx);
        }
        return expr;
    }

    private Expression.Builder extractOperator(Token operator, FirebaseRulesParser.ExpressionContext ... argumentExprCtxs) {
        FunctionTemplate functionTemplate = BUILT_IN_FUNCTION_NAME_MAP.get(operator.getType());
        String string = String.valueOf(operator);
        Preconditions.checkNotNull(functionTemplate, new StringBuilder(22 + String.valueOf(string).length()).append("Cannot find operator: ").append(string).toString());
        CallExpression.Builder callExpr = CallExpression.newBuilder();
        callExpr.setFunctionName(this.makeIdentifier(functionTemplate.getFunctionName(), operator));
        for (FirebaseRulesParser.ExpressionContext argumentExprCtx : argumentExprCtxs) {
            Expression.Builder argumentExpr = this.extractExpression(argumentExprCtx);
            callExpr.addArguments(argumentExpr);
        }
        return this.expression(callExpr, this.getPosition(operator));
    }

    private List<Expression.Builder> extractExpressionList(List<FirebaseRulesParser.ExpressionContext> exprCtxs) {
        ArrayList<Expression.Builder> expressionList = Lists.newArrayList();
        for (FirebaseRulesParser.ExpressionContext exprCtx : exprCtxs) {
            expressionList.add(this.extractExpression(exprCtx));
        }
        return expressionList;
    }

    private Literal.Builder extractLiteral(FirebaseRulesParser.LiteralContext ctx) {
        if (ctx.NULL() != null) {
            return NULL_LITERAL;
        }
        Literal.Builder literal = Literal.newBuilder();
        if (ctx.NUM_INT() != null) {
            try {
                return literal.setLongValue(Long.parseLong(ctx.NUM_INT().getText()));
            }
            catch (NumberFormatException e) {
                this.addError(ctx.getStart(), FirebaseRulesMessages.INVALID_NUMBER_LITERAL, ctx.NUM_INT().getText());
                return literal;
            }
        }
        if (ctx.NUM_FLOAT() != null) {
            try {
                return literal.setDoubleValue(Double.parseDouble(ctx.NUM_FLOAT().getText()));
            }
            catch (NumberFormatException e) {
                this.addError(ctx.getStart(), FirebaseRulesMessages.INVALID_NUMBER_LITERAL, ctx.NUM_FLOAT().getText());
                return literal;
            }
        }
        if (ctx.STRING() != null) {
            String text = ctx.STRING().getText();
            return literal.setStringValue(this.extractStringFromQuotes(text));
        }
        if (ctx.BYTES() != null) {
            if (!this.allowByteLiterals) {
                this.addError(ctx.getStart(), FirebaseRulesMessages.FORBIDDEN_BYTE_LITERAL, ctx.BYTES().getText());
            }
            return literal.setBytesValue(StringDecoder.decodeByteString(ctx.BYTES().getText()));
        }
        if (ctx.TRUE() != null) {
            return literal.setBoolValue(true);
        }
        if (ctx.FALSE() != null) {
            return literal.setBoolValue(false);
        }
        if (ctx.UNPAIRED_DOUBLE_QUOTE() != null || ctx.UNPAIRED_SINGLE_QUOTE() != null) {
            return Literal.newBuilder();
        }
        throw this.handleInvalidContext(ctx);
    }

    private void addError(Token token, MessageReference messageReference, String ... params) {
        this.reportIssue(CompilationIssueUtils.makeError(this.getPosition(token), messageReference, params));
    }

    private Identifier.Builder makeIdentifier(ParserRuleContext ctx) {
        return this.makeIdentifier(ctx.getText(), ctx);
    }

    private Identifier.Builder makeIdentifier(String name, ParserRuleContext ctx) {
        return this.makeIdentifier(name, ctx.getStart());
    }

    private Identifier.Builder makeIdentifier(String name, Token token) {
        return Identifier.newBuilder().setName(name).setSourcePosition(this.getPosition(token));
    }

    private SourcePosition getPosition(ParserRuleContext ctx) {
        return this.getPosition(ctx.getStart());
    }

    private SourcePosition getPosition(TerminalNode node) {
        return this.getPosition(node.getSymbol());
    }

    private SourcePosition getPosition(Token token) {
        return this.sourcePositionFactory.fromToken(token).build();
    }

    private RuntimeException handleInvalidContext(ParserRuleContext ctx) {
        String string = String.valueOf(ctx.getText());
        return new RuntimeException(string.length() != 0 ? "Invalid context".concat(string) : new String("Invalid context"));
    }

    private Expression.Builder expression(CallExpression.Builder callExpression, SourcePosition sourcePosition) {
        return Expression.newBuilder().setCall(callExpression).setSourcePosition(sourcePosition);
    }

    private Expression.Builder expression(ListExpression.Builder listExpression, SourcePosition sourcePosition) {
        return Expression.newBuilder().setList(listExpression).setSourcePosition(sourcePosition);
    }

    private Expression.Builder expression(MapExpression.Builder mapExpression, SourcePosition sourcePosition) {
        return Expression.newBuilder().setMap(mapExpression).setSourcePosition(sourcePosition);
    }

    private Expression.Builder expression(Member.Builder member, SourcePosition sourcePosition) {
        return Expression.newBuilder().setMember(member).setSourcePosition(sourcePosition);
    }

    private Expression.Builder expression(Literal.Builder literal, SourcePosition sourcePosition) {
        return Expression.newBuilder().setLiteral(literal).setSourcePosition(sourcePosition);
    }

    private String extractStringFromQuotes(String text) {
        int len;
        if (!(text == null || (len = text.length()) < 2 || text.charAt(0) != '\"' && text.charAt(0) != '\'' || text.charAt(len - 1) != '\"' && text.charAt(len - 1) != '\'')) {
            return StringEscapeUtils.unescapeJava(text.substring(1, len - 1));
        }
        return text;
    }

    private void reportIssue(TestRulesetResponse.Issue issue) {
        for (FirebaseRulesIssueListener listener : this.issueClients) {
            listener.onIssue(issue);
        }
    }
}

