/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.flogger.GoogleLogger;
import com.google.firebase.rules.lang.CompileResult;
import com.google.firebase.rules.lang.FirebaseRulesIssueListener;
import com.google.firebase.rules.lang.FirebaseRulesLexer;
import com.google.firebase.rules.lang.FirebaseRulesParser;
import com.google.firebase.rules.lang.FirebaseRulesParserBaseVisitor;
import com.google.firebase.rules.lang.FirebaseRulesProtoAstGenerator;
import com.google.firebase.rules.lang.SourcePositionFactory;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.common.FirebaseRulesLangOptions;
import com.google.firebase.rules.lang.common.SourcePositionUtils;
import com.google.firebase.rules.lang.semantic.DefaultSemanticValidator;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.runtime.v1.RulesetAstOrBuilder;
import com.google.firebase.rules.utils.LoggingUtils;
import com.google.firebase.rules.v1.File;
import com.google.firebase.rules.v1.SourceOrBuilder;
import com.google.firebase.rules.v1.TestRulesetResponse;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.i18n.MessageReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;

@ThreadSafe
public class FirebaseRulesProtoCompiler {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/rules/lang/FirebaseRulesProtoCompiler");
    private final FirebaseRulesLangOptions options;

    private FirebaseRulesProtoCompiler(FirebaseRulesLangOptions options) {
        this.options = options;
    }

    public static FirebaseRulesProtoCompiler create() {
        return FirebaseRulesProtoCompiler.create(FirebaseRulesLangOptions.builder().build());
    }

    public static FirebaseRulesProtoCompiler create(FirebaseRulesLangOptions options) {
        return new FirebaseRulesProtoCompiler(options);
    }

    public CompileResult compile(SourceOrBuilder source) {
        LinkedList<TestRulesetResponse.Issue> issues = Lists.newLinkedList();
        RulesetAst.Builder rulesetAst = RulesetAst.newBuilder();
        CompileResult.ParserStrategy parserStrategy = CompileResult.ParserStrategy.LL;
        ImmutableList<File> files = ImmutableList.copyOf(source.getFilesList());
        for (int i = 0; i < source.getFilesCount(); ++i) {
            File sourceFile = source.getFiles(i);
            CompileResult compileResult = this.compileFile(new SourcePositionFactory(this.options.includeSourceOffset(), i), sourceFile, files);
            rulesetAst.mergeFrom(compileResult.getRulesetAst());
            issues.addAll(compileResult.getIssues());
            parserStrategy = compileResult.getParserStrategy();
        }
        if (!CompilationIssueUtils.hasCompileError(issues)) {
            issues.addAll(this.performSemanticValidation(rulesetAst));
        }
        rulesetAst.addAllFileMetadata(source.getFilesList().stream().map(file -> file.toBuilder().clearContent().build()).collect(Collectors.toList()));
        return this.createResult(rulesetAst, issues, parserStrategy, this.options.includeSourceOffset(), files);
    }

    private CompileResult compileFile(SourcePositionFactory sourcePositionFactory, File sourceFile, ImmutableList<File> files) {
        if (!sourceFile.getContent().isEmpty()) {
            try {
                CharStream fileStream = this.readInputStream(sourceFile);
                return this.compileUnit(sourcePositionFactory, fileStream, files);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new CompileResult(RulesetAst.getDefaultInstance(), ImmutableList.of(CompilationIssueUtils.makeError(sourcePositionFactory.getEmptyPosition().build(), (MessageReference)FirebaseRulesMessages.EMPTY_RULES_CONTENT, new String[0])), CompileResult.ParserStrategy.SLL, sourcePositionFactory.includeSourceOffset(), files);
    }

    public CompileResult compileUnit(SourcePositionFactory sourcePositionFactory, CharStream stream, ImmutableList<File> files) {
        CompilerInstance compilerInstance = new CompilerInstance(sourcePositionFactory, stream, files);
        if (!this.options.trySllFirst()) {
            return compilerInstance.tryLLParser();
        }
        try {
            return compilerInstance.compileNoErrorRecovery(PredictionMode.SLL);
        }
        catch (RuntimeException ex) {
            if (ex.getClass() == RuntimeException.class && ex.getCause() instanceof RecognitionException) {
                return compilerInstance.tryLLParser();
            }
            throw ex;
        }
    }

    public List<TestRulesetResponse.Issue> performSemanticValidation(RulesetAstOrBuilder rulesetAst) {
        return new DefaultSemanticValidator(this.options).check(rulesetAst);
    }

    public ImmutableSet<String> getAutoImportedPackages() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().add("math")).add("latlng")).add("duration")).add("timestamp")).add("datastore")).build();
    }

    @VisibleForTesting
    CharStream readInputStream(File sourceFile) throws IOException {
        return CharStreams.fromStream(new ByteArrayInputStream(sourceFile.getContentBytes().toByteArray()));
    }

    private CompileResult createResult(RulesetAst.Builder generatedCode, List<TestRulesetResponse.Issue> issues, CompileResult.ParserStrategy parserStrategy, boolean includeSourceOffset, ImmutableList<File> files) {
        return new CompileResult(generatedCode.build(), issues.stream().map(issue -> issue.toBuilder().setSourcePosition(SourcePositionUtils.fillFileName(issue.getSourcePosition(), generatedCode.getFileMetadataList())).build()).collect(Collectors.toList()), parserStrategy, includeSourceOffset, files);
    }

    private static class CompilerIssueCollector
    extends BaseErrorListener
    implements FirebaseRulesIssueListener {
        private final Collection<TestRulesetResponse.Issue> issues;
        private final SourcePositionFactory sourcePositionFactory;

        public CompilerIssueCollector(Collection<TestRulesetResponse.Issue> issues, SourcePositionFactory sourcePositionFactory) {
            this.issues = issues;
            this.sourcePositionFactory = sourcePositionFactory;
        }

        @Override
        public void onIssue(TestRulesetResponse.Issue issue) {
            this.issues.add(issue);
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.onIssue(TestRulesetResponse.Issue.newBuilder().setSeverity(TestRulesetResponse.Issue.Severity.ERROR).setDescription(msg).setSourcePosition(this.sourcePositionFactory.fromSyntaxError(offendingSymbol, recognizer)).build());
        }
    }

    private static class CompilerErrorStrategy
    extends DefaultErrorStrategy {
        private final boolean supressRecovery;

        CompilerErrorStrategy(boolean suppressRecovery) {
            this.supressRecovery = suppressRecovery;
        }

        @Override
        protected void reportNoViableAlternative(Parser parser, NoViableAltException e) {
            parser.notifyErrorListeners(e.getOffendingToken(), this.formatError(e.getOffendingToken()), e);
        }

        @Override
        protected void reportUnwantedToken(Parser parser) {
            parser.notifyErrorListeners(this.formatError(parser.getCurrentToken()));
        }

        private String formatError(Token t) {
            return t != null ? String.format("Unexpected '%s'.", t.getText()) : "Unexpected input.";
        }

        @Override
        public void recover(Parser recognizer, RecognitionException e) {
            if (this.supressRecovery) {
                throw new RuntimeException(e);
            }
            super.recover(recognizer, e);
        }

        @Override
        public Token recoverInline(Parser recognizer) throws RecognitionException {
            if (this.supressRecovery) {
                throw new RuntimeException(new InputMismatchException(recognizer));
            }
            return super.recoverInline(recognizer);
        }

        @Override
        public void sync(Parser recognizer) {
            if (!this.supressRecovery) {
                super.sync(recognizer);
            }
        }
    }

    private class CompilerInstance {
        private final SourcePositionFactory sourcePositionFactory;
        private final FirebaseRulesLexer lexer;
        private final CommonTokenStream tokens;
        private final FirebaseRulesParser parser;
        private final List<TestRulesetResponse.Issue> issues;
        private final CompilerIssueCollector compilerIssueCollector;
        private final ImmutableList<File> files;

        CompilerInstance(SourcePositionFactory sourcePositionFactory, CharStream input, ImmutableList<File> files) {
            this.sourcePositionFactory = sourcePositionFactory;
            this.files = files;
            this.lexer = new FirebaseRulesLexer(input);
            this.tokens = new CommonTokenStream(this.lexer);
            this.parser = new FirebaseRulesParser(this.tokens);
            this.issues = Lists.newLinkedList();
            this.compilerIssueCollector = new CompilerIssueCollector(this.issues, sourcePositionFactory);
            for (String packageName : FirebaseRulesProtoCompiler.this.getAutoImportedPackages()) {
                this.parser.addPackage(packageName);
            }
            this.lexer.removeErrorListeners();
            this.parser.removeErrorListeners();
            this.lexer.addErrorListener(this.compilerIssueCollector);
            this.parser.addErrorListener(this.compilerIssueCollector);
        }

        private CompileResult tryLLParser() {
            ((ParserATNSimulator)this.parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            this.reset();
            this.checkForCompilationErrors();
            if (this.issues.isEmpty()) {
                this.reset();
                if (FirebaseRulesProtoCompiler.this.options.trySllFirst()) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/firebase/rules/lang/FirebaseRulesProtoCompiler$CompilerInstance", "tryLLParser", 269, "FirebaseRulesProtoCompiler.java")).log("[%d] Compilation failed with SLL while LL strategy passed.", LoggingUtils.getTraceId());
                }
                return this.compileNoErrorRecovery(PredictionMode.LL);
            }
            return new CompileResult(RulesetAst.getDefaultInstance(), this.issues, CompileResult.ParserStrategy.LL, this.sourcePositionFactory.includeSourceOffset(), this.files);
        }

        private void reset() {
            this.tokens.reset();
            this.issues.clear();
        }

        private void checkForCompilationErrors() {
            this.parser.setErrorHandler(new CompilerErrorStrategy(false));
            FirebaseRulesParserBaseVisitor visitor = new FirebaseRulesParserBaseVisitor();
            visitor.visit(this.parser.ruleset());
        }

        private CompileResult compileNoErrorRecovery(PredictionMode predictionMode) {
            ((ParserATNSimulator)this.parser.getInterpreter()).setPredictionMode(predictionMode);
            this.parser.setErrorHandler(new CompilerErrorStrategy(true));
            FirebaseRulesProtoAstGenerator generator = new FirebaseRulesProtoAstGenerator(this.sourcePositionFactory, FirebaseRulesProtoCompiler.this.options.allowVersionTwo(), FirebaseRulesProtoCompiler.this.options.allowByteLiterals());
            generator.addIssueListener(this.compilerIssueCollector);
            RulesetAst.Builder generatedAst = generator.generateCode(this.parser);
            return new CompileResult(generatedAst.build(), this.issues, this.getParserStrategy(predictionMode), this.sourcePositionFactory.includeSourceOffset(), this.files);
        }

        private CompileResult.ParserStrategy getParserStrategy(PredictionMode predictionMode) {
            return predictionMode == PredictionMode.SLL ? CompileResult.ParserStrategy.SLL : CompileResult.ParserStrategy.LL;
        }
    }
}

