/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.common;

import com.google.firebase.rules.runtime.v1.CallExpression;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.Function;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.runtime.v1.ListExpression;
import com.google.firebase.rules.runtime.v1.Literal;
import com.google.firebase.rules.runtime.v1.MapExpression;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.Member;
import com.google.firebase.rules.runtime.v1.Path;
import com.google.firebase.rules.runtime.v1.Permission;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.runtime.v1.ServiceRule;

public abstract class AbstractAstVisitor {
    protected void visitAst(RulesetAst ast) {
        for (Function function : ast.getFunctionsList()) {
            this.visitFunction(function);
        }
        for (ServiceRule serviceRule : ast.getServiceRulesList()) {
            this.visitServiceRule(serviceRule);
        }
    }

    protected void visitIdentifier(Identifier identifier) {
    }

    protected void visitFunction(Function function) {
        if (function.hasBody()) {
            this.visit(function.getBody());
        }
        if (function.hasId()) {
            this.visitIdentifier(function.getId());
        }
        for (Identifier identifier : function.getParamsIdsList()) {
            this.visitIdentifier(identifier);
        }
    }

    private void visitPath(Path pathTemplate) {
        block5: for (Path.PathSegment segment : pathTemplate.getSegmentsList()) {
            switch (segment.getKindCase()) {
                case EXPRESSION: {
                    this.visit(segment.getExpression());
                    continue block5;
                }
                case CAPTURE: {
                    this.visitIdentifier(segment.getCapture());
                    continue block5;
                }
                case GLOB_CAPTURE: {
                    this.visitIdentifier(segment.getGlobCapture());
                    continue block5;
                }
            }
            String string = String.valueOf(segment);
            throw new RuntimeException(new StringBuilder(23 + String.valueOf(string).length()).append("Cannot find path type: ").append(string).toString());
        }
    }

    protected void visitServiceRule(ServiceRule serviceRule) {
        if (serviceRule.hasServiceName()) {
            this.visitIdentifier(serviceRule.getServiceName());
        }
        for (Function segment : serviceRule.getFunctionsList()) {
            this.visitFunction(segment);
        }
        for (MatchRule matchRule : serviceRule.getMatchRulesList()) {
            this.visitMatchRule(matchRule);
        }
    }

    protected void visitMatchRule(MatchRule matchRule) {
        if (matchRule.hasPath()) {
            this.visitPath(matchRule.getPath());
        }
        for (Function segment : matchRule.getFunctionsList()) {
            this.visitFunction(segment);
        }
        for (MatchRule childMatchRule : matchRule.getMatchRulesList()) {
            this.visitMatchRule(childMatchRule);
        }
        for (Permission permission : matchRule.getPermissionsList()) {
            this.visitPermission(permission);
        }
    }

    protected void visitPermission(Permission permission) {
        for (Identifier identifier : permission.getIdsList()) {
            this.visitIdentifier(identifier);
        }
        if (permission.hasAllow()) {
            this.visit(permission.getAllow());
        }
    }

    protected void visit(Expression expr) {
        switch (expr.getExpressionCase()) {
            case CALL: {
                this.visitCall(expr.getCall());
                break;
            }
            case MEMBER: {
                this.visitMember(expr.getMember());
                break;
            }
            case LIST: {
                this.visitList(expr.getList());
                break;
            }
            case PATH: {
                this.visitPath(expr.getPath());
                break;
            }
            case MAP: {
                this.visitMap(expr.getMap());
                break;
            }
            case LITERAL: {
                this.visitLiteral(expr.getLiteral());
                break;
            }
            default: {
                String string = String.valueOf(expr.getSourcePosition());
                throw new RuntimeException(new StringBuilder(29 + String.valueOf(string).length()).append("Cannot find expression type: ").append(string).toString());
            }
        }
    }

    protected void visitList(ListExpression listExpression) {
        for (Expression expression : listExpression.getExpressionsList()) {
            this.visit(expression);
        }
    }

    protected void visitMap(MapExpression mapExpression) {
        int size = mapExpression.getKeysCount();
        for (int i = 0; i < size; ++i) {
            this.visit(mapExpression.getKeys(i));
            this.visit(mapExpression.getValues(i));
        }
    }

    protected void visitCall(CallExpression callExpression) {
        if (callExpression.hasOperand()) {
            this.visit(callExpression.getOperand());
        }
        if (callExpression.hasPackageName()) {
            this.visitIdentifier(callExpression.getPackageName());
        }
        if (callExpression.hasFunctionName()) {
            this.visitIdentifier(callExpression.getFunctionName());
        }
        for (Expression argument : callExpression.getArgumentsList()) {
            this.visit(argument);
        }
    }

    protected void visitMember(Member member) {
        if (member.hasOperand()) {
            this.visit(member.getOperand());
        }
        if (member.hasId()) {
            this.visitIdentifier(member.getId());
        }
    }

    protected void visitLiteral(Literal literal) {
    }
}

