/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.common;

import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.firebase.rules.v1.TestRulesetResponse;
import com.google.i18n.MessageReference;
import java.util.List;
import java.util.Locale;

public class CompilationIssueUtils {
    private CompilationIssueUtils() {
    }

    public static TestRulesetResponse.Issue makeError(Identifier identifier, MessageReference messageReference, String ... params) {
        return CompilationIssueUtils.makeError(identifier.getSourcePosition(), messageReference, params);
    }

    public static TestRulesetResponse.Issue makeError(SourcePosition sourcePosition, MessageReference messageReference, String ... params) {
        return CompilationIssueUtils.makeIssue(sourcePosition, TestRulesetResponse.Issue.Severity.ERROR, messageReference, params);
    }

    public static TestRulesetResponse.Issue makeError(SourcePosition sourcePosition, Exception ex) {
        return TestRulesetResponse.Issue.newBuilder().setSeverity(TestRulesetResponse.Issue.Severity.ERROR).setSourcePosition(sourcePosition).setDescription(ex.getMessage()).build();
    }

    public static TestRulesetResponse.Issue makeWarning(Identifier identifier, MessageReference messageReference, String ... params) {
        return CompilationIssueUtils.makeWarning(identifier.getSourcePosition(), messageReference, params);
    }

    public static TestRulesetResponse.Issue makeWarning(SourcePosition sourcePosition, MessageReference messageReference, String ... params) {
        return CompilationIssueUtils.makeIssue(sourcePosition, TestRulesetResponse.Issue.Severity.WARNING, messageReference, params);
    }

    private static TestRulesetResponse.Issue makeIssue(SourcePosition sourcePosition, TestRulesetResponse.Issue.Severity severity, MessageReference messageReference, String[] params) {
        return TestRulesetResponse.Issue.newBuilder().setSeverity(severity).setSourcePosition(sourcePosition).setDescription(messageReference.getMessage(Locale.ENGLISH).toString(params)).build();
    }

    public static boolean hasCompileError(List<TestRulesetResponse.Issue> issues) {
        for (TestRulesetResponse.Issue issue : issues) {
            if (issue.getSeverity() != TestRulesetResponse.Issue.Severity.ERROR) continue;
            return true;
        }
        return false;
    }
}

