/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.common;

import java.util.Arrays;
import java.util.List;

public interface FunctionTemplate {
    public static final FunctionTemplate TO_DYN = MethodCallFunctionTemplate.makeFunctionTemplate("@dyn@");
    public static final FunctionTemplate IS_NAN = MethodCallFunctionTemplate.makeFunctionTemplate("math.isNaN");
    public static final FunctionTemplate IS_INFINITY = MethodCallFunctionTemplate.makeFunctionTemplate("math.isInfinity");
    public static final FunctionTemplate FLOOR = MethodCallFunctionTemplate.makeFunctionTemplate("math.floor");
    public static final FunctionTemplate CEIL = MethodCallFunctionTemplate.makeFunctionTemplate("math.ceil");
    public static final FunctionTemplate ROUND = MethodCallFunctionTemplate.makeFunctionTemplate("math.round");
    public static final FunctionTemplate ABS = MethodCallFunctionTemplate.makeFunctionTemplate("math.abs");
    public static final FunctionTemplate DURATION_ABS = MethodCallFunctionTemplate.makeFunctionTemplate("duration.abs");
    public static final FunctionTemplate IN = MethodCallFunctionTemplate.makeFunctionTemplate("in");

    public String getFunctionName();

    public String getSignature(String var1, List<String> var2);

    public static interface PathMembers {
        public static final FunctionTemplate BIND = MethodCallFunctionTemplate.makeFunctionTemplate("bind");
    }

    public static interface TimestampMembers {
        public static final FunctionTemplate NANOS = MethodCallFunctionTemplate.makeFunctionTemplate("nanos");
        public static final FunctionTemplate SECONDS = MethodCallFunctionTemplate.makeFunctionTemplate("seconds");
        public static final FunctionTemplate MINUTES = MethodCallFunctionTemplate.makeFunctionTemplate("minutes");
        public static final FunctionTemplate HOURS = MethodCallFunctionTemplate.makeFunctionTemplate("hours");
        public static final FunctionTemplate DAY = MethodCallFunctionTemplate.makeFunctionTemplate("day");
        public static final FunctionTemplate MONTH = MethodCallFunctionTemplate.makeFunctionTemplate("month");
        public static final FunctionTemplate YEAR = MethodCallFunctionTemplate.makeFunctionTemplate("year");
        public static final FunctionTemplate DAY_OF_YEAR = MethodCallFunctionTemplate.makeFunctionTemplate("dayOfYear");
        public static final FunctionTemplate DAY_OF_WEEK = MethodCallFunctionTemplate.makeFunctionTemplate("dayOfWeek");
        public static final FunctionTemplate DATE = MethodCallFunctionTemplate.makeFunctionTemplate("date");
        public static final FunctionTemplate TO_MILLIS = MethodCallFunctionTemplate.makeFunctionTemplate("toMillis");
        public static final FunctionTemplate TIME = MethodCallFunctionTemplate.makeFunctionTemplate("time");
    }

    public static interface DurationMembers {
        public static final FunctionTemplate NANOS = MethodCallFunctionTemplate.makeFunctionTemplate("nanos");
        public static final FunctionTemplate SECONDS = MethodCallFunctionTemplate.makeFunctionTemplate("seconds");
    }

    public static interface LatLngMembers {
        public static final FunctionTemplate LATITUDE = MethodCallFunctionTemplate.makeFunctionTemplate("latitude");
        public static final FunctionTemplate LONGITUDE = MethodCallFunctionTemplate.makeFunctionTemplate("longitude");
        public static final FunctionTemplate DISTANCE = MethodCallFunctionTemplate.makeFunctionTemplate("distance");
    }

    public static interface MapMembers {
        public static final FunctionTemplate KEYS = MethodCallFunctionTemplate.makeFunctionTemplate("keys");
        public static final FunctionTemplate VALUES = MethodCallFunctionTemplate.makeFunctionTemplate("values");
        public static final FunctionTemplate SIZE = MethodCallFunctionTemplate.makeFunctionTemplate("size");
    }

    public static interface ListMembers {
        public static final FunctionTemplate HAS_ALL = MethodCallFunctionTemplate.makeFunctionTemplate("hasAll");
        public static final FunctionTemplate HAS_ANY = MethodCallFunctionTemplate.makeFunctionTemplate("hasAny");
        public static final FunctionTemplate HAS_ONLY = MethodCallFunctionTemplate.makeFunctionTemplate("hasOnly");
        public static final FunctionTemplate JOIN = MethodCallFunctionTemplate.makeFunctionTemplate("join");
        public static final FunctionTemplate SIZE = MethodCallFunctionTemplate.makeFunctionTemplate("size");
        public static final FunctionTemplate CONCAT = MethodCallFunctionTemplate.makeFunctionTemplate("concat");
    }

    public static interface StringMembers {
        public static final FunctionTemplate SPLIT = MethodCallFunctionTemplate.makeFunctionTemplate("split");
        public static final FunctionTemplate MATCHES = MethodCallFunctionTemplate.makeFunctionTemplate("matches");
        public static final FunctionTemplate TRIM = MethodCallFunctionTemplate.makeFunctionTemplate("trim");
        public static final FunctionTemplate UPPER = MethodCallFunctionTemplate.makeFunctionTemplate("upper");
        public static final FunctionTemplate LOWER = MethodCallFunctionTemplate.makeFunctionTemplate("lower");
        public static final FunctionTemplate SIZE = MethodCallFunctionTemplate.makeFunctionTemplate("size");
    }

    public static class MethodCallFunctionTemplate
    implements FunctionTemplate {
        private final String functionName;

        public MethodCallFunctionTemplate(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public String getFunctionName() {
            return this.functionName;
        }

        @Override
        public String getSignature(String operand, List<String> arguments) {
            StringBuilder sb = new StringBuilder();
            if (operand != null) {
                sb.append(operand).append(".");
            }
            sb.append(this.getFunctionName());
            sb.append("(");
            for (int i = 0; i < arguments.size(); ++i) {
                sb.append(arguments.get(i));
                if (i >= arguments.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }

        public static FunctionTemplate makeFunctionTemplate(String functionName) {
            return new MethodCallFunctionTemplate(functionName);
        }
    }

    public static enum BuiltInRangeFunction implements FunctionTemplate
    {
        LOOKUP_RANGE("@range");

        private final String functionName;

        private BuiltInRangeFunction(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public String getFunctionName() {
            return this.functionName;
        }

        @Override
        public String getSignature(String operand, List<String> arguments) {
            return String.format("%s[%s:%s]", operand, arguments.get(0), arguments.get(1));
        }
    }

    public static enum BuiltInIndexFunction implements FunctionTemplate
    {
        LOOKUP_INDEX("[]");

        private final String functionName;

        private BuiltInIndexFunction(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public String getFunctionName() {
            return this.functionName;
        }

        @Override
        public String getSignature(String operand, List<String> arguments) {
            return String.format("%s[%s]", operand, arguments.get(0));
        }
    }

    public static enum BuiltInTypeConversionFunction implements FunctionTemplate
    {
        TO_INT("int"),
        TO_FLOAT("float"),
        TO_STRING("string"),
        PATH("path"),
        DURATION_VALUE("duration.value"),
        DURATION_TIME("duration.time"),
        LATLNG_VALUE("latlng.value"),
        TIMESTAMP_VALUE("timestamp.value"),
        TIMESTAMP_DATE("timestamp.date"),
        TIMESTAMP_TIME("timestamp.time");

        private final String functionName;
        private final String friendlyName;

        private BuiltInTypeConversionFunction(String functionName) {
            this(functionName, functionName);
        }

        private BuiltInTypeConversionFunction(String functionName, String friendlyName) {
            this.functionName = functionName;
            this.friendlyName = friendlyName;
        }

        @Override
        public String getFunctionName() {
            return this.functionName;
        }

        @Override
        public String getSignature(String operand, List<String> arguments) {
            return String.format("%s(%s)", this.friendlyName, arguments.get(0));
        }
    }

    public static enum BuiltInUnaryOperator implements FunctionTemplate
    {
        BOOLEAN_NOT("!"),
        NEGATE_NUMBER("@neg", "-");

        private final String functionName;
        private final String friendlyName;

        private BuiltInUnaryOperator(String functionName) {
            this(functionName, functionName);
        }

        private BuiltInUnaryOperator(String functionName, String friendlyName) {
            this.functionName = functionName;
            this.friendlyName = friendlyName;
        }

        @Override
        public String getFunctionName() {
            return this.functionName;
        }

        @Override
        public String getSignature(String operand, List<String> arguments) {
            return String.format("%s%s", this.friendlyName, arguments.get(0));
        }
    }

    public static enum BuiltInBooleanOperator implements FunctionTemplate
    {
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUALS(">="),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUALS("<="),
        EQUALS("=="),
        NOT_EQUALS("!="),
        BOOLEAN_AND("&&"),
        BOOLEAN_OR("||"),
        JUMP_IF("jump-if"),
        IS_TYPE("is");

        private static final List<? extends FunctionTemplate> SHORT_CIRCUITS;
        private final String functionName;
        private final String friendlyName;

        private BuiltInBooleanOperator(String functionName) {
            this(functionName, functionName);
        }

        private BuiltInBooleanOperator(String functionName, String friendlyName) {
            this.functionName = functionName;
            this.friendlyName = friendlyName;
        }

        @Override
        public String getFunctionName() {
            return this.functionName;
        }

        @Override
        public String getSignature(String operand, List<String> arguments) {
            return String.format("%s %s %s", arguments.get(0), this.friendlyName, arguments.get(1));
        }

        public static boolean isShortCircuit(String functionName) {
            for (BuiltInBooleanOperator candidate : BuiltInBooleanOperator.values()) {
                if (!candidate.functionName.equals(functionName)) continue;
                return SHORT_CIRCUITS.contains(candidate);
            }
            return false;
        }

        static {
            SHORT_CIRCUITS = Arrays.asList(BOOLEAN_AND, BOOLEAN_OR, JUMP_IF);
        }
    }

    public static enum BuiltInMathOperator implements FunctionTemplate
    {
        MULTIPLY("*"),
        DIVIDE("/"),
        MODULUS("%"),
        ADD("+"),
        MINUS("-");

        private final String functionName;

        private BuiltInMathOperator(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public String getFunctionName() {
            return this.functionName;
        }

        @Override
        public String getSignature(String operand, List<String> arguments) {
            return String.format("%s %s %s", arguments.get(0), this.functionName, arguments.get(1));
        }
    }

    public static interface PathDeSugarMethods {
        public static final FunctionTemplate CONCAT = MethodCallFunctionTemplate.makeFunctionTemplate("@+@");
        public static final FunctionTemplate TO_PATH = MethodCallFunctionTemplate.makeFunctionTemplate("@p@");
    }
}

