/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.policy;

import com.google.api.expr.Constant;
import com.google.api.expr.Expr;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.google.firebase.rules.PolicyPath;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.lang.policy.IdGenerator;
import com.google.firebase.rules.runtime.v1.CallExpression;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.runtime.v1.Literal;
import com.google.firebase.rules.runtime.v1.MapExpression;
import com.google.firebase.rules.runtime.v1.Member;
import com.google.firebase.rules.runtime.v1.Path;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.protobuf.NullValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FirebaseRulesExpressionToCelExpression
implements Function<Expression, Expr> {
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String FIELD_NAME_POLICY_PATH_SEGMENTS = PolicyPath.getDescriptor().findFieldByNumber(1).getName();
    private static final String FIELD_NAME_SEGMENT_CAPTURE = PolicyPath.Segment.getDescriptor().findFieldByNumber(2).getName();
    private static final String FIELD_NAME_SEGMENT_MULTI_CAPTURE = PolicyPath.Segment.getDescriptor().findFieldByNumber(3).getName();
    private static final String FIELD_NAME_SEGMENT_VALUE = PolicyPath.Segment.getDescriptor().findFieldByNumber(1).getName();
    private static final String FIELD_NAME_CAPTURE_NAME = PolicyPath.Capture.getDescriptor().findFieldByNumber(1).getName();
    private static final String FIELD_NAME_MULTI_CAPTURE_NAME = PolicyPath.MultiCapture.getDescriptor().findFieldByNumber(1).getName();
    private final IdGenerator idGenerator;
    public final Map<Long, SourcePosition> idToSourcePosition = new HashMap<Long, SourcePosition>();
    private Function<Expression, Expr> dynWrapper;

    public FirebaseRulesExpressionToCelExpression(IdGenerator idGenerator, boolean wrapFirstElementOfAggregationsInDyn) {
        this.idGenerator = idGenerator;
        this.dynWrapper = wrapFirstElementOfAggregationsInDyn ? expression -> this.makeExprBuilder(expression.getSourcePosition()).setCallExpr(Expr.Call.newBuilder().setFunction(FunctionTemplate.TO_DYN.getFunctionName()).addArgs(this.apply((Expression)expression))).build() : this;
    }

    public SourcePosition getSourcePositionForId(long id) {
        return this.idToSourcePosition.get(id);
    }

    @Override
    public Expr apply(Expression expression) {
        Expr.Builder builder = this.makeExprBuilder(expression.getSourcePosition());
        switch (expression.getExpressionCase()) {
            case LITERAL: {
                return builder.setConstExpr(this.fromLiteral(expression.getLiteral())).build();
            }
            case CALL: {
                Expr.Call.Builder call = Expr.Call.newBuilder();
                CallExpression callExpression = expression.getCall();
                if (callExpression.hasPackageName()) {
                    String string = this.toString(callExpression.getPackageName());
                    String string2 = this.toString(callExpression.getFunctionName());
                    call.setFunction(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(PACKAGE_SEPARATOR).append(string2).toString());
                } else {
                    call.setFunction(this.toString(callExpression.getFunctionName()));
                }
                if (callExpression.hasOperand()) {
                    call.setTarget(this.apply(callExpression.getOperand()));
                }
                call.addAllArgs((Iterable)callExpression.getArgumentsList().stream().map(this).collect(Collectors.toList()));
                return builder.setCallExpr(call).build();
            }
            case MEMBER: {
                Member member = expression.getMember();
                if (member.hasOperand()) {
                    Expr.Select.Builder select = Expr.Select.newBuilder();
                    select.setOperand(this.apply(member.getOperand()));
                    select.setField(this.toString(member.getId()));
                    return builder.setSelectExpr(select).build();
                }
                return builder.setIdentExpr(Expr.Ident.newBuilder().setName(this.toString(member.getId()))).build();
            }
            case LIST: {
                Expr.CreateList.Builder list = Expr.CreateList.newBuilder();
                if (!expression.getList().getExpressionsList().isEmpty()) {
                    list.addElements(this.dynWrapper.apply(expression.getList().getExpressionsList().get(0)));
                }
                list.addAllElements((Iterable)expression.getList().getExpressionsList().stream().skip(1L).map(this).collect(Collectors.toList()));
                return builder.setListExpr(list).build();
            }
            case PATH: {
                return this.handleSegments(expression.getSourcePosition(), expression.getPath().getSegmentsList());
            }
            case MAP: {
                Expr.CreateStruct.Builder struct = Expr.CreateStruct.newBuilder();
                MapExpression mapExpression = expression.getMap();
                if (!mapExpression.getKeysList().isEmpty() && !mapExpression.getValuesList().isEmpty()) {
                    Expression key2 = mapExpression.getKeysList().get(0);
                    Expression value2 = mapExpression.getValuesList().get(0);
                    Expr keyExpr = this.apply(key2);
                    Expr.CreateStruct.Entry.Builder entryBuilder = Expr.CreateStruct.Entry.newBuilder();
                    entryBuilder.setId(keyExpr.getId());
                    struct.addEntries(entryBuilder.setMapKey(keyExpr).setValue(this.dynWrapper.apply(value2)).build());
                }
                struct.addAllEntries((Iterable)Streams.zip(mapExpression.getKeysList().stream().skip(1L), mapExpression.getValuesList().stream().skip(1L), (key, value) -> {
                    Expr mapKey = this.apply((Expression)key);
                    Expr.CreateStruct.Entry.Builder entryBuilder = Expr.CreateStruct.Entry.newBuilder();
                    entryBuilder.setId(mapKey.getId());
                    return entryBuilder.setMapKey(mapKey).setValue(this.apply((Expression)value)).build();
                }).collect(Collectors.toList()));
                return builder.setStructExpr(struct).build();
            }
        }
        String string = String.valueOf(expression);
        throw new RuntimeException(new StringBuilder(29 + String.valueOf(string).length()).append("Cannot find expression type: ").append(string).toString());
    }

    private Expr handleSegments(SourcePosition sourcePosition, List<Path.PathSegment> segments) {
        int firstInterpolationIndex = -1;
        for (int i = 0; i < segments.size(); ++i) {
            Path.PathSegment segment = segments.get(i);
            if (!this.isInterpolation(segment)) continue;
            firstInterpolationIndex = i;
            break;
        }
        if (firstInterpolationIndex == -1) {
            return this.makePathExpr(sourcePosition, segments.stream().map(this::makeSegmentExpr).collect(Collectors.toList()));
        }
        Expression interpolationExpression = segments.get(firstInterpolationIndex).getExpression();
        Expr interpolation = this.makePathExprForInterpolation(interpolationExpression);
        if (firstInterpolationIndex != 0) {
            Expr constPart = this.makePathExpr(sourcePosition, segments.subList(0, firstInterpolationIndex).stream().map(this::makeSegmentExpr).collect(Collectors.toList()));
            interpolation = this.makeExprBuilder(sourcePosition).setCallExpr(Expr.Call.newBuilder().setFunction(FunctionTemplate.PathDeSugarMethods.CONCAT.getFunctionName()).addArgs(constPart).addArgs(interpolation)).build();
        }
        if (firstInterpolationIndex == segments.size() - 1) {
            return interpolation;
        }
        return this.makeExprBuilder(sourcePosition).setCallExpr(Expr.Call.newBuilder().setFunction(FunctionTemplate.PathDeSugarMethods.CONCAT.getFunctionName()).addArgs(interpolation).addArgs(this.handleSegments(sourcePosition, segments.subList(firstInterpolationIndex + 1, segments.size())))).build();
    }

    private Expr makePathExprForInterpolation(Expression expression) {
        return this.makeExprBuilder(expression.getSourcePosition()).setCallExpr(Expr.Call.newBuilder().setFunction(FunctionTemplate.PathDeSugarMethods.TO_PATH.getFunctionName()).addArgs(this.apply(expression))).build();
    }

    private Expr makePathExpr(SourcePosition sourcePosition, List<Expr> pathSegments) {
        Expr.CreateStruct.Builder pathStruct = Expr.CreateStruct.newBuilder();
        pathStruct.setMessageName(PolicyPath.getDescriptor().getFullName());
        Expr.CreateList.Builder list = Expr.CreateList.newBuilder();
        list.addAllElements(pathSegments);
        pathStruct.addEntries(this.makeFieldEntry(sourcePosition, FIELD_NAME_POLICY_PATH_SEGMENTS, this.makeExprBuilder(sourcePosition).setListExpr(list).build()));
        return this.makeExprBuilder(sourcePosition).setStructExpr(pathStruct).build();
    }

    private Expr makeSegmentExpr(Path.PathSegment pathSegment) {
        SourcePosition position;
        Expr.CreateStruct.Builder segmentStruct = Expr.CreateStruct.newBuilder();
        segmentStruct.setMessageName(PolicyPath.Segment.getDescriptor().getFullName());
        switch (pathSegment.getKindCase()) {
            case CAPTURE: {
                position = pathSegment.getCapture().getSourcePosition();
                Expr.CreateStruct.Builder captureStruct = Expr.CreateStruct.newBuilder();
                captureStruct.setMessageName(PolicyPath.Capture.getDescriptor().getFullName());
                captureStruct.addEntries(this.makeFieldEntry(position, FIELD_NAME_CAPTURE_NAME, this.makeString(position, pathSegment.getCapture().getName())));
                segmentStruct.addEntries(this.makeFieldEntry(position, FIELD_NAME_SEGMENT_CAPTURE, this.makeExprBuilder(position).setStructExpr(captureStruct).build()));
                break;
            }
            case GLOB_CAPTURE: {
                position = pathSegment.getGlobCapture().getSourcePosition();
                Expr.CreateStruct.Builder globStruct = Expr.CreateStruct.newBuilder();
                globStruct.setMessageName(PolicyPath.MultiCapture.getDescriptor().getFullName());
                globStruct.addEntries(this.makeFieldEntry(position, FIELD_NAME_MULTI_CAPTURE_NAME, this.makeString(position, pathSegment.getCapture().getName())));
                segmentStruct.addEntries(this.makeFieldEntry(position, FIELD_NAME_SEGMENT_MULTI_CAPTURE, this.makeExprBuilder(position).setStructExpr(globStruct).build()));
                break;
            }
            case EXPRESSION: {
                position = pathSegment.getExpression().getSourcePosition();
                Preconditions.checkState(pathSegment.getExpression().getExpressionCase() == Expression.ExpressionCase.LITERAL);
                Preconditions.checkState(pathSegment.getExpression().getLiteral().getKindCase() == Literal.KindCase.STRING_VALUE);
                String value = pathSegment.getExpression().getLiteral().getStringValue();
                segmentStruct.addEntries(this.makeFieldEntry(position, FIELD_NAME_SEGMENT_VALUE, this.makeString(position, value)));
                break;
            }
            default: {
                String string = String.valueOf(pathSegment);
                throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("Unsupported path segment: ").append(string).toString());
            }
        }
        return this.makeExprBuilder(position).setStructExpr(segmentStruct).build();
    }

    private boolean isInterpolation(Path.PathSegment segment) {
        return segment.getKindCase() != Path.PathSegment.KindCase.CAPTURE && segment.getKindCase() != Path.PathSegment.KindCase.GLOB_CAPTURE && (segment.getKindCase() != Path.PathSegment.KindCase.EXPRESSION || segment.getExpression().getExpressionCase() != Expression.ExpressionCase.LITERAL || segment.getExpression().getLiteral().getKindCase() != Literal.KindCase.STRING_VALUE);
    }

    private String toString(Identifier identifier) {
        return identifier.getName();
    }

    private Constant fromLiteral(Literal literal) {
        switch (literal.getKindCase()) {
            case BOOL_VALUE: {
                return Constant.newBuilder().setBoolValue(literal.getBoolValue()).build();
            }
            case LONG_VALUE: {
                return Constant.newBuilder().setInt64Value(literal.getLongValue()).build();
            }
            case DOUBLE_VALUE: {
                return Constant.newBuilder().setDoubleValue(literal.getDoubleValue()).build();
            }
            case STRING_VALUE: {
                return Constant.newBuilder().setStringValue(literal.getStringValue()).build();
            }
            case BYTES_VALUE: {
                return Constant.newBuilder().setBytesValue(literal.getBytesValue()).build();
            }
            case NULL_VALUE: {
                return Constant.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
            }
        }
        String string = String.valueOf(literal);
        throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length()).append("Unsupported literal ").append(string).toString());
    }

    private Expr makeString(SourcePosition sourcePosition, String string) {
        return this.makeExprBuilder(sourcePosition).setConstExpr(Constant.newBuilder().setStringValue(string)).build();
    }

    private Expr.CreateStruct.Entry makeFieldEntry(SourcePosition sourcePosition, String key, Expr value) {
        long id = this.idGenerator.getId(sourcePosition);
        this.idToSourcePosition.put(id, sourcePosition);
        return Expr.CreateStruct.Entry.newBuilder().setId(id).setFieldKey(key).setValue(value).build();
    }

    private Expr.Builder makeExprBuilder(SourcePosition sourcePosition) {
        long id = this.idGenerator.getId(sourcePosition);
        this.idToSourcePosition.put(id, sourcePosition);
        return Expr.newBuilder().setId(id);
    }
}

