/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.policy;

import com.google.api.expr.Constant;
import com.google.api.expr.Expr;
import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.LocalDecl;
import com.google.firebase.rules.Metadata;
import com.google.firebase.rules.Policy;
import com.google.firebase.rules.Rule;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.lang.policy.FirebaseRulesExpressionToCelExpression;
import com.google.firebase.rules.lang.policy.IdGenerator;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.Function;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.Permission;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.runtime.v1.ServiceRule;
import com.google.firebase.rules.v1.File;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.protobuf.Empty;
import java.util.stream.Collectors;

public class RulesAstToPolicyConverter {
    private static final String SERVICE_VARIABLE = "service";
    private static final String METHOD_VARIABLE = "method";
    public static final String REQUEST = "request";
    private final IdGenerator.MetadataGatheringIdGenerator idGenerator;
    private final FirebaseRulesExpressionToCelExpression expressionConverter;
    private final RulesetAst rulesetAst;

    public RulesAstToPolicyConverter(RulesetAst rulesetAst, ImmutableList<File> files) {
        this.rulesetAst = rulesetAst;
        this.idGenerator = new IdGenerator.MetadataGatheringIdGenerator(files);
        this.expressionConverter = new FirebaseRulesExpressionToCelExpression(this.idGenerator, false);
    }

    public Policy getPolicy() {
        Policy.Builder policyBuilder = Policy.newBuilder();
        policyBuilder.setId(this.idGenerator.getId(SourcePosition.getDefaultInstance()));
        policyBuilder.addAllDeclarations((Iterable)this.rulesetAst.getFunctionsList().stream().map(this::convertFunction).collect(Collectors.toList()));
        policyBuilder.addAllDeclarations((Iterable)this.rulesetAst.getServiceRulesList().stream().map(this::convertServiceRule).collect(Collectors.toList()));
        return policyBuilder.build();
    }

    public Metadata getMetadata() {
        return this.idGenerator.toMetadata();
    }

    private LocalDecl convertServiceRule(ServiceRule serviceRule) {
        return LocalDecl.newBuilder().setId(this.idGenerator.getId(serviceRule.getServiceName().getSourcePosition())).setSelector(LocalDecl.Selector.newBuilder().setFilter(this.makeEqualExpr(REQUEST, SERVICE_VARIABLE, serviceRule.getServiceName())).addAllDeclarations((Iterable)serviceRule.getFunctionsList().stream().map(this::convertFunction).collect(Collectors.toList())).addAllDeclarations((Iterable)serviceRule.getMatchRulesList().stream().map(this::convertMatch).collect(Collectors.toList()))).build();
    }

    private LocalDecl convertMatch(MatchRule matchRule) {
        long id = this.idGenerator.getId(matchRule.getSourcePosition());
        return LocalDecl.newBuilder().setId(id).setSelector(LocalDecl.Selector.newBuilder().setFilter(this.expressionConverter.apply(Expression.newBuilder().setSourcePosition(matchRule.getSourcePosition()).setPath(matchRule.getPath()).build())).addAllDeclarations((Iterable)matchRule.getFunctionsList().stream().map(this::convertFunction).collect(Collectors.toList())).addAllDeclarations((Iterable)matchRule.getMatchRulesList().stream().map(this::convertMatch).collect(Collectors.toList())).addAllRules((Iterable)matchRule.getPermissionsList().stream().map(this::convertPermission).collect(Collectors.toList()))).build();
    }

    private Rule convertPermission(Permission permission) {
        SourcePosition idSourcePosition = permission.getIdsList().get(0).getSourcePosition();
        Expr actionExpr = permission.getIdsList().stream().map(identifier -> this.makeEqualExpr(REQUEST, METHOD_VARIABLE, (Identifier)identifier)).reduce((exprA, exprB) -> this.makeOrExpr((Expr)exprA, (Expr)exprB, idSourcePosition)).orElse(Expr.newBuilder().setConstExpr(Constant.newBuilder().setBoolValue(true)).build());
        return Rule.newBuilder().setId(this.idGenerator.getId(idSourcePosition)).setEffect(Rule.Effect.ALLOW).setCondition(this.makeAndExpr(actionExpr, this.expressionConverter.apply(permission.getAllow()), idSourcePosition)).build();
    }

    private LocalDecl convertFunction(Function function) {
        return LocalDecl.newBuilder().setId(this.idGenerator.getId(function.getId().getSourcePosition())).setName(function.getId().getName()).setFunction(LocalDecl.Function.newBuilder().addAllParameters((Iterable)function.getParamsIdsList().stream().map(this::convertIdentifier).collect(Collectors.toList())).setResultExpression(this.expressionConverter.apply(function.getBody()))).build();
    }

    private LocalDecl convertIdentifier(Identifier identifier) {
        return LocalDecl.newBuilder().setId(this.idGenerator.getId(identifier.getSourcePosition())).setName(identifier.getName()).setIdentifier(Empty.getDefaultInstance()).build();
    }

    private Expr makeOrExpr(Expr lhs, Expr rhs, SourcePosition sourcePosition) {
        return Expr.newBuilder().setId(this.idGenerator.getId(sourcePosition)).setCallExpr(Expr.Call.newBuilder().setFunction(FunctionTemplate.BuiltInBooleanOperator.BOOLEAN_OR.getFunctionName()).addArgs(lhs).addArgs(rhs)).build();
    }

    private Expr makeAndExpr(Expr lhs, Expr rhs, SourcePosition sourcePosition) {
        return Expr.newBuilder().setId(this.idGenerator.getId(sourcePosition)).setCallExpr(Expr.Call.newBuilder().setFunction(FunctionTemplate.BuiltInBooleanOperator.BOOLEAN_AND.getFunctionName()).addArgs(lhs).addArgs(rhs)).build();
    }

    private Expr makeEqualExpr(String target, String id, Identifier value) {
        SourcePosition sourcePosition = value.getSourcePosition();
        Expr operand = Expr.newBuilder().setId(this.idGenerator.getId(sourcePosition)).setIdentExpr(Expr.Ident.newBuilder().setName(target)).build();
        Expr selectExpr = Expr.newBuilder().setId(this.idGenerator.getId(sourcePosition)).setSelectExpr(Expr.Select.newBuilder().setField(id).setOperand(operand)).build();
        Expr valueExpr = Expr.newBuilder().setId(this.idGenerator.getId(sourcePosition)).setConstExpr(Constant.newBuilder().setStringValue(value.getName())).build();
        return Expr.newBuilder().setId(this.idGenerator.getId(sourcePosition)).setCallExpr(Expr.Call.newBuilder().setFunction(FunctionTemplate.BuiltInBooleanOperator.EQUALS.getFunctionName()).addArgs(selectExpr).addArgs(valueExpr)).build();
    }
}

