/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.firebase.rules.lang.common.AbstractAstVisitor;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.runtime.v1.CallExpression;
import com.google.firebase.rules.runtime.v1.Function;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.tree.TreeNode;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class FunctionVisitor
extends AbstractAstVisitor {
    private final Function caller;
    private TreeNode<Scope> node;
    private DirectedGraph<Identifier, DefaultEdge> callGraph;
    private boolean searchParentForFunctions;

    public FunctionVisitor(Function caller, TreeNode<Scope> node, DirectedGraph<Identifier, DefaultEdge> callGraph, boolean searchParentForFunctions) {
        this.caller = caller;
        this.node = node;
        this.callGraph = callGraph;
        this.searchParentForFunctions = searchParentForFunctions;
    }

    public void visit() {
        this.addVertex(this.caller.getId());
        this.visit(this.caller.getBody());
    }

    @Override
    protected void visitCall(CallExpression callExpression) {
        Function callee;
        String functionName = callExpression.getFunctionName().getName();
        if (!callExpression.hasOperand() && (callee = this.findFunction(functionName)) != null) {
            this.addVertex(callee.getId());
            this.callGraph.addEdge(this.caller.getId(), callee.getId());
        }
        super.visitCall(callExpression);
    }

    private Function findFunction(String functionName) {
        return this.findFunction(this.node, functionName);
    }

    private void addVertex(Identifier identifier) {
        if (!this.callGraph.vertexSet().contains(identifier)) {
            this.callGraph.addVertex(identifier);
        }
    }

    private Function findFunction(TreeNode<Scope> node, String functionName) {
        for (Function function : node.getValue().functions()) {
            if (!function.getId().getName().equals(functionName)) continue;
            return function;
        }
        if (node.getParent() != null && this.searchParentForFunctions) {
            return this.findFunction(node.getParent(), functionName);
        }
        return null;
    }
}

