/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.lang.semantic.SemanticValidator;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.Path;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.tree.TreeNode;
import com.google.firebase.rules.v1.TestRulesetResponse;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.i18n.MessageReference;
import java.util.List;
import java.util.function.Consumer;

public final class GlobMatchRuleWithChild
implements SemanticValidator<TreeNode<Scope>> {
    @Override
    public List<TestRulesetResponse.Issue> check(TreeNode<Scope> root) {
        ImmutableList.Builder issues = ImmutableList.builder();
        GlobMatchRuleWithChild.walkTree(root, issues::add);
        return issues.build();
    }

    private static void walkTree(TreeNode<Scope> root, Consumer<TestRulesetResponse.Issue> issues) {
        switch (root.getValue().level()) {
            case RULESET: {
                if (!GlobMatchRuleWithChild.rulesVersionAllowsNestedGlobs(root.getValue().ruleset().getVersion())) break;
                return;
            }
            case SERVICE: {
                break;
            }
            case MATCH: {
                MatchRule rule = root.getValue().match();
                Path path = rule.getPath();
                int segmentCount = path.getSegmentsCount();
                if (segmentCount <= 0 || path.getSegments(segmentCount - 1).getKindCase() != Path.PathSegment.KindCase.GLOB_CAPTURE || root.getChildren().isEmpty()) break;
                issues.accept(CompilationIssueUtils.makeWarning(rule.getSourcePosition(), (MessageReference)FirebaseRulesMessages.GLOB_RULE_SHOULD_NOT_HAVE_CHILD_RULES, new String[0]));
            }
        }
        for (TreeNode<Scope> child : root.getChildren()) {
            GlobMatchRuleWithChild.walkTree(child, issues);
        }
    }

    private static boolean rulesVersionAllowsNestedGlobs(RulesetAst.Version rulesVersion) {
        switch (rulesVersion) {
            case VERSION_UNSPECIFIED: 
            case VERSION_1: {
                return false;
            }
            case VERSION_2: {
                return true;
            }
        }
        throw new AssertionError((Object)"Unknown rules version");
    }
}

