/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.lang.semantic.SemanticValidator;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.tree.TreeNode;
import com.google.firebase.rules.v1.TestRulesetResponse;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.i18n.MessageReference;
import java.util.List;
import java.util.function.Consumer;

public class RejectRulesVersionTwoForFirebaseStorage
implements SemanticValidator<TreeNode<Scope>> {
    private static final String FIREBASE_STORAGE = "firebase.storage";

    @Override
    public List<TestRulesetResponse.Issue> check(TreeNode<Scope> root) {
        ImmutableList.Builder issues = ImmutableList.builder();
        RejectRulesVersionTwoForFirebaseStorage.walkTree(root, issues::add);
        return issues.build();
    }

    private static void walkTree(TreeNode<Scope> root, Consumer<TestRulesetResponse.Issue> issues) {
        switch (root.getValue().level()) {
            case RULESET: {
                if (!root.getValue().ruleset().getVersion().equals(RulesetAst.Version.VERSION_2)) break;
                for (TreeNode<Scope> child : root.getChildren()) {
                    RejectRulesVersionTwoForFirebaseStorage.walkTree(child, issues);
                }
                break;
            }
            case SERVICE: {
                Identifier serviceNameId = root.getValue().service().getServiceName();
                String serviceName = serviceNameId.getName();
                if (!FIREBASE_STORAGE.equals(serviceName)) break;
                issues.accept(CompilationIssueUtils.makeError(serviceNameId, (MessageReference)FirebaseRulesMessages.UNSUPPORTED_RULES_VERSION_FOR_FIREBASE_STORAGE, new String[0]));
                break;
            }
        }
    }
}

