/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.lang.semantic.SemanticValidator;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.tree.PreOrderTreeWalker;
import com.google.firebase.rules.tree.TreeNode;
import com.google.firebase.rules.v1.TestRulesetResponse;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.i18n.MessageReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class RepeatedServiceDefinition
implements SemanticValidator<TreeNode<Scope>> {
    @Override
    public List<TestRulesetResponse.Issue> check(TreeNode<Scope> root) {
        ArrayList<TestRulesetResponse.Issue> issues = Lists.newArrayList();
        HashSet services = Sets.newHashSet();
        new PreOrderTreeWalker<Scope>().walk(root, node -> {
            if (((Scope)node.getValue()).level() == Scope.Level.SERVICE) {
                Identifier serviceNameId = ((Scope)node.getValue()).service().getServiceName();
                String serviceName = serviceNameId.getName();
                if (services.contains(serviceName)) {
                    issues.add(CompilationIssueUtils.makeError(serviceNameId, (MessageReference)FirebaseRulesMessages.DUPLICATE_SERVICE_NAME_DECLARATION, new String[0]));
                }
                services.add(serviceName);
            }
        });
        return issues;
    }
}

