/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.auto.value.AutoOneOf;
import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.lang.semantic.AutoOneOf_Scope;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.Function;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.Permission;
import com.google.firebase.rules.runtime.v1.RulesetAstOrBuilder;
import com.google.firebase.rules.runtime.v1.ServiceRule;
import com.google.firebase.rules.v1.SourcePosition;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@AutoOneOf(value=Level.class)
public abstract class Scope {
    private SourcePosition sourcePosition = null;
    private ImmutableList<Expression> expressions = null;
    private ImmutableList<Function> functions = null;

    public abstract Level level();

    public abstract RulesetAstOrBuilder ruleset();

    public abstract ServiceRule service();

    public abstract MatchRule match();

    public SourcePosition sourcePosition() {
        if (this.sourcePosition == null) {
            switch (this.level()) {
                case RULESET: {
                    this.sourcePosition = SourcePosition.getDefaultInstance();
                    break;
                }
                case SERVICE: {
                    this.sourcePosition = this.service().getServiceName().getSourcePosition();
                    break;
                }
                case MATCH: {
                    this.sourcePosition = this.match().getSourcePosition();
                }
            }
        }
        return this.sourcePosition;
    }

    public ImmutableList<Expression> expressions() {
        if (this.expressions == null) {
            switch (this.level()) {
                case RULESET: 
                case SERVICE: {
                    this.expressions = ImmutableList.of();
                    break;
                }
                case MATCH: {
                    this.expressions = this.match().getPermissionsList().stream().map(Permission::getAllow).collect(ImmutableList.toImmutableList());
                }
            }
        }
        return this.expressions;
    }

    public ImmutableList<Function> functions() {
        if (this.functions == null) {
            switch (this.level()) {
                case RULESET: {
                    this.functions = ImmutableList.copyOf(this.ruleset().getFunctionsList());
                    break;
                }
                case SERVICE: {
                    this.functions = ImmutableList.copyOf(this.service().getFunctionsList());
                    break;
                }
                case MATCH: {
                    this.functions = ImmutableList.copyOf(this.match().getFunctionsList());
                }
            }
        }
        return this.functions;
    }

    public static Scope fromServiceRule(ServiceRule serviceRule) {
        return AutoOneOf_Scope.service(serviceRule);
    }

    public static Scope fromMatchRule(MatchRule pathRule) {
        return AutoOneOf_Scope.match(pathRule);
    }

    public static Scope fromRulesetAst(RulesetAstOrBuilder rulesetAst) {
        return AutoOneOf_Scope.ruleset(rulesetAst);
    }

    public static enum Level {
        RULESET,
        SERVICE,
        MATCH;

    }
}

