/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.api.expr.CheckedExpr;
import com.google.api.expr.Decl;
import com.google.api.expr.Expr;
import com.google.api.expr.ParsedExpr;
import com.google.api.expr.Type;
import com.google.api.tools.expr.checker.Env;
import com.google.api.tools.expr.checker.ExprChecker;
import com.google.api.tools.expr.parser.Errors;
import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.policy.FirebaseRulesExpressionToCelExpression;
import com.google.firebase.rules.lang.policy.IdGenerator;
import com.google.firebase.rules.lang.semantic.FirebaseRulesTypes;
import com.google.firebase.rules.lang.semantic.FunctionVisitor;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.lang.semantic.SemanticValidator;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.Function;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.Path;
import com.google.firebase.rules.runtime.v1.RulesetAstOrBuilder;
import com.google.firebase.rules.runtime.v1.ServiceRule;
import com.google.firebase.rules.runtime.v1.ServiceRuleOrBuilder;
import com.google.firebase.rules.tree.NodeVisitor;
import com.google.firebase.rules.tree.PreOrderTreeWalker;
import com.google.firebase.rules.tree.TreeNode;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.firebase.rules.v1.TestRulesetResponse;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.i18n.MessageReference;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jgrapht.DirectedGraph;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class TypeCheckValidator
implements SemanticValidator<TreeNode<Scope>> {
    private static final String CLOUD_FIRESTORE = "cloud.firestore";
    private static final String FIRESTORE_VALUE = "value";
    private static final String FIRESTORE_EXISTS = "exists";
    private static final String REQUEST = "request";
    private static final String RESOURCE = "resource";
    private final FirebaseRulesExpressionToCelExpression converter = new FirebaseRulesExpressionToCelExpression(new IdGenerator.SimpleIdGenerator(), true);

    @Override
    public List<TestRulesetResponse.Issue> check(TreeNode<Scope> root) {
        TypeCheckerInstance typeChecker = new TypeCheckerInstance();
        new PreOrderTreeWalker<Scope>().walk(root, typeChecker);
        return typeChecker.issues();
    }

    private class TypeCheckerInstance
    implements NodeVisitor<Scope> {
        private final ImmutableList.Builder<TestRulesetResponse.Issue> issues = ImmutableList.builder();
        private Env env = FirebaseRulesTypes.makeEnv(new Errors("", null));

        private TypeCheckerInstance() {
        }

        @Override
        public void visit(TreeNode<Scope> node) {
            RulesetAstOrBuilder rulesetAstOrBuilder;
            List<ServiceRule> serviceRules;
            this.env.enterScope();
            if (node.getValue().level() == Scope.Level.MATCH) {
                MatchRule rule = node.getValue().match();
                Path path = rule.getPath();
                path.getSegmentsList().forEach(pathSegment -> {
                    if (pathSegment.getKindCase() == Path.PathSegment.KindCase.CAPTURE) {
                        this.env.add(FirebaseRulesTypes.declare(pathSegment.getCapture().getName(), FirebaseRulesTypes.STRING));
                    } else if (pathSegment.getKindCase() == Path.PathSegment.KindCase.GLOB_CAPTURE) {
                        this.env.add(FirebaseRulesTypes.declare(pathSegment.getGlobCapture().getName(), FirebaseRulesTypes.PATH));
                    }
                });
            } else if (node.getValue().level() == Scope.Level.RULESET && !(serviceRules = (rulesetAstOrBuilder = node.getValue().ruleset()).getServiceRulesList()).isEmpty()) {
                this.addServiceLevelDecls(serviceRules.get(0), this.env);
            }
            IdentityHashMap<Identifier, Function> functionsMap = new IdentityHashMap<Identifier, Function>();
            DirectedAcyclicGraph<Identifier, DefaultEdge> callGraph = this.buildFunctionDependencyGraph(node, functionsMap);
            new TopologicalOrderIterator<Identifier, DefaultEdge>(new EdgeReversedGraph<Identifier, DefaultEdge>((DirectedGraph<Identifier, DefaultEdge>)callGraph)).forEachRemaining(identifier -> this.typeCheckFunction((Function)functionsMap.get(identifier), this.issues));
            node.getValue().expressions().forEach(expression -> {
                Expr expr = TypeCheckValidator.this.converter.apply((Expression)expression);
                CheckedExpr checkedExpr = ExprChecker.check((Env)this.env, (String)"", (ParsedExpr)ParsedExpr.newBuilder().setExpr(expr).build());
                this.checkForMapsWithNoneStringKey(checkedExpr, this.issues);
                Type type = (Type)checkedExpr.getTypeMapMap().get(expr.getId());
                if (type != null && (type.getTypeKindCase() != Type.TypeKindCase.PRIMITIVE || type.getPrimitive() != Type.PrimitiveType.BOOL) && type.getTypeKindCase() != Type.TypeKindCase.DYN && type.getTypeKindCase() != Type.TypeKindCase.ERROR) {
                    this.issues.add((Object)CompilationIssueUtils.makeError(expression.getSourcePosition(), (MessageReference)FirebaseRulesMessages.TYPE_ERROR, type.toString().toLowerCase(), Type.PrimitiveType.BOOL.toString().toLowerCase()));
                }
            });
            this.env.getErrorContext().getErrors().stream().map(error -> TestRulesetResponse.Issue.newBuilder().setDescription(error.rawMessage()).setSourcePosition(this.getSourcePositionForError(this.env.getErrorContext(), (Errors.Error)error)).setSeverity(TestRulesetResponse.Issue.Severity.ERROR).build()).forEach(this.issues::add);
        }

        private SourcePosition getSourcePositionForError(Errors errors, Errors.Error error) {
            Errors.SourceRef sourceRef = errors.getSourceRef(error.position());
            if (sourceRef != null) {
                return SourcePosition.newBuilder().setLine(sourceRef.line()).setColumn(sourceRef.column()).setCurrentOffset(error.position()).build();
            }
            return SourcePosition.newBuilder().setColumn(error.position()).setCurrentOffset(error.position()).build();
        }

        private void typeCheckFunction(Function function, ImmutableList.Builder<TestRulesetResponse.Issue> issues) {
            this.env.enterScope();
            for (Identifier argument : function.getParamsIdsList()) {
                this.env.add(FirebaseRulesTypes.declare(argument.getName(), FirebaseRulesTypes.DYN));
            }
            Expr body = TypeCheckValidator.this.converter.apply(function.getBody());
            CheckedExpr checkedExpr = ExprChecker.check((Env)this.env, (String)"", (ParsedExpr)ParsedExpr.newBuilder().setExpr(body).build());
            this.checkForMapsWithNoneStringKey(checkedExpr, issues);
            this.env.exitScope();
            Type type = (Type)checkedExpr.getTypeMapMap().get(body.getId());
            this.addFunctionDeclToScope(function, type);
        }

        private void addFunctionDeclToScope(Function function, Type type) {
            String string = String.valueOf(function.getId().getName());
            Decl functionDecl = new Env.FunctionBuilder(function.getId().getName()).add(string.length() != 0 ? "local_".concat(string) : new String("local_"), type != null && type.getTypeKindCase() != Type.TypeKindCase.ERROR && type.getTypeKindCase() != Type.TypeKindCase.TYPEKIND_NOT_SET ? type : FirebaseRulesTypes.DYN, Collections.nCopies(function.getParamsIdsCount(), FirebaseRulesTypes.DYN)).build();
            this.env.add(functionDecl);
        }

        private DirectedAcyclicGraph<Identifier, DefaultEdge> buildFunctionDependencyGraph(TreeNode<Scope> node, IdentityHashMap<Identifier, Function> functionsMap) {
            DirectedAcyclicGraph<Identifier, DefaultEdge> callGraph = new DirectedAcyclicGraph<Identifier, DefaultEdge>(DefaultEdge.class);
            for (Function function : node.getValue().functions()) {
                functionsMap.put(function.getId(), function);
                new FunctionVisitor(function, node, callGraph, false).visit();
            }
            return callGraph;
        }

        private void checkForMapsWithNoneStringKey(CheckedExpr checkedExpr, ImmutableList.Builder<TestRulesetResponse.Issue> issues) {
            for (Map.Entry entry : checkedExpr.getTypeMapMap().entrySet()) {
                Type keyType;
                long expressionId = (Long)entry.getKey();
                Type type = (Type)entry.getValue();
                if (type.getTypeKindCase() != Type.TypeKindCase.MAP_TYPE || (keyType = type.getMapType().getKeyType()).getTypeKindCase() == Type.TypeKindCase.ERROR || keyType.getTypeKindCase() == Type.TypeKindCase.DYN || keyType.getTypeKindCase() == Type.TypeKindCase.PRIMITIVE && keyType.getPrimitive() == Type.PrimitiveType.STRING || keyType.getTypeKindCase() == Type.TypeKindCase.TYPEKIND_NOT_SET) continue;
                issues.add((Object)CompilationIssueUtils.makeError(TypeCheckValidator.this.converter.getSourcePositionForId(expressionId), (MessageReference)FirebaseRulesMessages.TYPE_ERROR, type.toString().toLowerCase(), Type.PrimitiveType.STRING.toString().toLowerCase()));
            }
        }

        @Override
        public void afterNode(TreeNode<Scope> node) {
            this.env.exitScope();
        }

        public ImmutableList<TestRulesetResponse.Issue> issues() {
            return this.issues.build();
        }

        private void addServiceLevelDecls(ServiceRuleOrBuilder serviceRules, Env env) {
            env.add(FirebaseRulesTypes.declare(TypeCheckValidator.REQUEST, FirebaseRulesTypes.MAP_OF_STRING_DYN));
            env.add(FirebaseRulesTypes.declare(TypeCheckValidator.RESOURCE, FirebaseRulesTypes.MAP_OF_STRING_DYN));
            if (serviceRules.getServiceName().getName().equals(TypeCheckValidator.CLOUD_FIRESTORE)) {
                env.add(new Env.FunctionBuilder(TypeCheckValidator.FIRESTORE_VALUE).add("firestore_value", FirebaseRulesTypes.MAP_OF_STRING_DYN, new Type[]{FirebaseRulesTypes.PATH}).doc("Returns the document from the firestore.").build());
                env.add(new Env.FunctionBuilder(TypeCheckValidator.FIRESTORE_EXISTS).add("firestore_exists", FirebaseRulesTypes.BOOL, new Type[]{FirebaseRulesTypes.PATH}).doc("Returns true if document exists in firestore.").build());
            }
        }
    }
}

