/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.auth;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.flogger.GoogleLogger;
import com.google.common.labs.stats.CacheStreamzExporter;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firebase.rules.runtime.auth.ServiceAccountAuthenticator;
import com.google.firebase.rules.runtime.auth.ShortTermCredentialsClient;
import com.google.gaia.mint.GaiaMintScopeCode;
import com.google.gaia.mint.GetShortTermCredentialsRequest;
import com.google.gaia.mint.GetShortTermCredentialsResponse;
import com.google.gaia.mint.MintWrapper;
import com.google.gaia.mint.credentials.GetShortTermCredentialsException;
import com.google.security.credentials.Authenticator;
import com.google.security.credentials.GaiaMint;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.Duration;

public class AuthenticatorCache
implements ServiceAccountAuthenticator {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/rules/runtime/auth/AuthenticatorCache");
    private static final Duration MINT_DURATION = Duration.standardMinutes(5L);
    private static final long REFRESH_AFTER_NANOS = TimeUnit.MILLISECONDS.toNanos(MINT_DURATION.minus(Duration.standardSeconds(30L)).getMillis());
    private static final long EXPIRE_AFTER_NANOS = TimeUnit.MILLISECONDS.toNanos(MINT_DURATION.minus(Duration.standardSeconds(10L)).getMillis());
    static final Function<GaiaMintScopeCode.ScopeCode, Integer> SCOPE_CODE_TO_VALUE = GaiaMintScopeCode.ScopeCode::getValue;
    private final LoadingCache<String, CacheValue> cache;
    private final ImmutableSet<Integer> acceptedScopes;

    private AuthenticatorCache(ShortTermCredentialsClient credentialClient, Ticker ticker, @Nullable ListeningExecutorService executor, CacheBuilderSpec cacheSpec, ImmutableSet<GaiaMintScopeCode.ScopeCode> scopeIds, @Nullable String streamzPrefix) {
        Preconditions.checkArgument(!scopeIds.isEmpty());
        this.acceptedScopes = ImmutableSet.copyOf(Iterables.transform(scopeIds, SCOPE_CODE_TO_VALUE));
        ServiceAccountAuthenticatorCacheLoader cacheLoader = new ServiceAccountAuthenticatorCacheLoader(Preconditions.checkNotNull(credentialClient), this.acceptedScopes, executor);
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.from(cacheSpec).expireAfterWrite(EXPIRE_AFTER_NANOS, TimeUnit.NANOSECONDS).refreshAfterWrite(REFRESH_AFTER_NANOS, TimeUnit.NANOSECONDS).ticker(ticker);
        if (!Strings.isNullOrEmpty(streamzPrefix)) {
            this.cache = cacheBuilder.recordStats().build(cacheLoader);
            CacheStreamzExporter.builder().build().export(streamzPrefix, this.cache);
        } else {
            this.cache = cacheBuilder.build(cacheLoader);
        }
    }

    @Override
    public ImmutableSet<Integer> acceptedScopes() {
        return this.acceptedScopes;
    }

    @Override
    public Authenticator getAuthenticator(String serviceAccountEmail) throws GetShortTermCredentialsException {
        try {
            CacheValue value = this.cache.get(serviceAccountEmail);
            return value.getAuthenticator();
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf(e.getCause(), GetShortTermCredentialsException.class);
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder().cacheSpec(CacheBuilderSpec.parse("maximumSize=1000,concurrencyLevel=10")).ticker(Ticker.systemTicker());
    }

    public static class Builder {
        private ShortTermCredentialsClient shortTermCredentialsClient;
        private Ticker ticker;
        private CacheBuilderSpec cacheSpec;
        private final ImmutableSet.Builder<GaiaMintScopeCode.ScopeCode> scopeCodes = ImmutableSet.builder();
        @Nullable
        private ListeningExecutorService executor;
        @Nullable
        private String streamzPrefix;

        private Builder() {
        }

        public Builder shortTermCredentialsClient(ShortTermCredentialsClient shortTermCredentialsClient) {
            this.shortTermCredentialsClient = shortTermCredentialsClient;
            return this;
        }

        public Builder addScopeCode(GaiaMintScopeCode.ScopeCode scopeCode) {
            this.scopeCodes.add((Object)scopeCode);
            return this;
        }

        public Builder addAllScopeCodes(List<GaiaMintScopeCode.ScopeCode> scopeCodes) {
            this.scopeCodes.addAll(scopeCodes);
            return this;
        }

        public Builder ticker(Ticker ticker) {
            this.ticker = Preconditions.checkNotNull(ticker);
            return this;
        }

        public Builder cacheSpec(CacheBuilderSpec cacheSpec) {
            this.cacheSpec = Preconditions.checkNotNull(cacheSpec);
            return this;
        }

        public Builder executor(@Nullable ListeningExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder streamzPrefix(String streamzPrefix) {
            this.streamzPrefix = streamzPrefix;
            return this;
        }

        public AuthenticatorCache build() {
            ImmutableCollection scopeCodes = this.scopeCodes.build();
            Preconditions.checkState(!scopeCodes.isEmpty(), "At least one scope code must be added before calling build");
            return new AuthenticatorCache(this.shortTermCredentialsClient, this.ticker, this.executor, this.cacheSpec, (ImmutableSet)scopeCodes, this.streamzPrefix);
        }
    }

    private static class ServiceAccountAuthenticatorCacheLoader
    extends CacheLoader<String, CacheValue> {
        private final ShortTermCredentialsClient credentialClient;
        private final ImmutableSet<Integer> scopeIds;
        @Nullable
        private final ListeningExecutorService executor;

        public ServiceAccountAuthenticatorCacheLoader(ShortTermCredentialsClient credentialClient, ImmutableSet<Integer> scopeIds, @Nullable ListeningExecutorService executor) {
            this.credentialClient = credentialClient;
            this.scopeIds = scopeIds;
            this.executor = executor;
        }

        @Override
        public CacheValue load(String serviceAccountEmail) throws InterruptedException, GetShortTermCredentialsException {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/firebase/rules/runtime/auth/AuthenticatorCache$ServiceAccountAuthenticatorCacheLoader", "load", 172, "AuthenticatorCache.java")).log("Getting short term credentials for %s", serviceAccountEmail);
            try {
                GetShortTermCredentialsResponse creds = this.credentialClient.getShortTermCredentials(this.makeRequest(serviceAccountEmail, this.scopeIds));
                return new CacheValue((Authenticator)ServiceAccountAuthenticatorCacheLoader.getAuthenticator(creds));
            }
            catch (GetShortTermCredentialsException exception) {
                return this.makeCacheValueForException(exception);
            }
        }

        @Override
        public ListenableFuture<CacheValue> reload(String serviceAccountEmail, CacheValue oldValue) throws Exception {
            if (this.executor == null) {
                return Futures.catchingAsync(Futures.transform(this.credentialClient.getShortTermCredentialsAsync(this.makeRequest(serviceAccountEmail, this.scopeIds)), creds -> new CacheValue((Authenticator)ServiceAccountAuthenticatorCacheLoader.getAuthenticator(creds)), MoreExecutors.directExecutor()), GetShortTermCredentialsException.class, exception -> Futures.immediateFuture(this.makeCacheValueForException((GetShortTermCredentialsException)((Object)exception))), MoreExecutors.directExecutor());
            }
            return this.executor.submit(() -> this.load(serviceAccountEmail));
        }

        private CacheValue makeCacheValueForException(GetShortTermCredentialsException exception) throws GetShortTermCredentialsException {
            if (!this.credentialClient.isRetryableException(exception)) {
                return new CacheValue((Exception)((Object)exception));
            }
            throw exception;
        }

        private GetShortTermCredentialsRequest makeRequest(String serviceAccountEmail, ImmutableSet<Integer> scopeIds) {
            GetShortTermCredentialsRequest request = new GetShortTermCredentialsRequest().setRobotEmail(serviceAccountEmail).setCredentialType(GetShortTermCredentialsRequest.CredentialType.GAIA_MINT).setRemoteHost("0.1.0.1");
            Iterator iterator = scopeIds.iterator();
            while (iterator.hasNext()) {
                int scopeId = (Integer)iterator.next();
                request.addScopeId(scopeId);
            }
            return request;
        }

        private static GaiaMint getAuthenticator(GetShortTermCredentialsResponse creds) {
            return Authenticator.fromGaiaMint((MintWrapper)creds.getMintWrapper());
        }
    }

    static class CacheValue {
        private Authenticator authenticator;
        private Exception exception;

        CacheValue(Authenticator authenticator) {
            this.authenticator = authenticator;
            this.exception = null;
        }

        CacheValue(Exception exception) {
            this.exception = exception;
            this.authenticator = null;
        }

        public Authenticator getAuthenticator() throws GetShortTermCredentialsException {
            if (this.exception != null) {
                Throwables.throwIfInstanceOf(this.exception, GetShortTermCredentialsException.class);
                throw new RuntimeException(this.exception);
            }
            return this.authenticator;
        }
    }
}

