/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.auth;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.context.Context;
import com.google.common.flogger.GoogleLogger;
import com.google.common.time.SystemClock;
import com.google.firebase.firebear.client.ClockWithSkew;
import com.google.firebase.firebear.client.FirebearCertificateProvider;
import com.google.firebase.firebear.client.FirebearJwtVerifier;
import com.google.firebase.firebear.client.JwtToken;
import com.google.firebase.firebear.client.JwtVerificationException;
import com.google.firebase.firebear.client.JwtVerifier;
import com.google.firebase.rules.runtime.auth.AuthenticatorCache;
import com.google.firebase.rules.runtime.auth.DefaultServiceAccountNamingStrategy;
import com.google.firebase.rules.runtime.auth.RulesValidatedSecurityContext;
import com.google.firebase.rules.runtime.auth.ServiceAccountAuthenticator;
import com.google.firebase.rules.runtime.auth.ShortTermCredentialsClient;
import com.google.gaia.auth.session.GaiaSession;
import com.google.gaia.mint.GaiaMintScopeCode;
import com.google.gaia.mint.credentials.GetShortTermCredentialsException;
import com.google.security.authentication.common.AuthenticationException;
import com.google.security.context.SecurityContext;
import com.google.security.context.ValidationOptions;
import com.google.security.context.validation.Environment;
import com.google.security.context.validation.GaiaSessionHelper;
import com.google.security.context.validation.GaiaValidatorFactoryBuilder;
import com.google.security.context.validation.IamSecurityContextWithGaiaSession;
import com.google.security.context.validation.ValidatedSecurityContext;
import com.google.security.context.validation.Validator;
import com.google.security.context.validation.ValidatorFactory;
import com.google.security.credentials.Authenticator;
import com.google.security.credentials.EndUserCreds;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.Duration;

@ThreadSafe
public class RulesSecurityValidator {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/rules/runtime/auth/RulesSecurityValidator");
    private static final Duration DEFAULT_JWT_VERIFIER_CLOCK_SKEW = Duration.standardSeconds(30L);
    public static final String CREDENTIAL_CACHE_STREAMZ_PREFIX = "/firebase/rules/client/auth/mint_cache";
    private final Function<Long, String> rulesServiceAccountNamingStrategy;
    private final JwtVerifier jwtVerifier;
    private final ServiceAccountAuthenticator serviceAccountAuthenticator;
    private final Validator validator;

    private RulesSecurityValidator(Function<Long, String> rulesServiceAccountNamingStrategy, Validator validator, JwtVerifier jwtVerifier, ServiceAccountAuthenticator serviceAccountAuthenticator) {
        this.rulesServiceAccountNamingStrategy = Preconditions.checkNotNull(rulesServiceAccountNamingStrategy);
        this.jwtVerifier = Preconditions.checkNotNull(jwtVerifier);
        this.validator = Preconditions.checkNotNull(validator);
        this.serviceAccountAuthenticator = Preconditions.checkNotNull(serviceAccountAuthenticator);
    }

    @Nullable
    public JwtToken validateJwtToken(String issuer, String authorizationHeader) throws JwtVerificationException {
        if (!Strings.isNullOrEmpty(authorizationHeader)) {
            return this.jwtVerifier.verifyAuthorizationHeader(issuer, authorizationHeader);
        }
        return null;
    }

    public ValidatedSecurityContext serviceAccountCredentialExchange(long projectNumber) throws GetShortTermCredentialsException {
        String serviceAccountEmail = this.rulesServiceAccountNamingStrategy.apply(projectNumber);
        Authenticator authenticator = this.serviceAccountAuthenticator.getAuthenticator(serviceAccountEmail);
        SecurityContext sc = SecurityContext.newBuilder((SecurityContext)Context.getCurrentContext().getSecurityContext()).setEndUserCreds(EndUserCreds.fromAuthenticator((Authenticator)authenticator)).build();
        try {
            ValidatedSecurityContext validatedContext = this.validator.validate(sc);
            GaiaSession gaiaSession = GaiaSessionHelper.getDefault().getGaiaSession(validatedContext);
            return IamSecurityContextWithGaiaSession.create((GaiaSession)gaiaSession, null);
        }
        catch (AuthenticationException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/firebase/rules/runtime/auth/RulesSecurityValidator", "serviceAccountCredentialExchange", 134, "RulesSecurityValidator.java")).log("Unable to validate the mint %s for project number %d.", (Object)e.getMessage(), projectNumber);
            throw new RuntimeException(e);
        }
    }

    public RulesValidatedSecurityContext validate(String issuer, long projectNumber, String authorizationHeader) throws JwtVerificationException, GetShortTermCredentialsException {
        JwtToken jwtToken = this.validateJwtToken(issuer, authorizationHeader);
        ValidatedSecurityContext validatedSecurityContext = this.serviceAccountCredentialExchange(projectNumber);
        return new RulesValidatedSecurityContext(validatedSecurityContext, jwtToken);
    }

    public static RulesSecurityValidatorBuilder builder() {
        return new RulesSecurityValidatorBuilder().rulesServiceAccountNamingStrategy(DefaultServiceAccountNamingStrategy.PROD);
    }

    public static RulesSecurityValidatorBuilder firebearJwtValidator(FirebearCertificateProvider firebearCertificateProvider, ShortTermCredentialsClient shortTermCredentialsClient, GaiaMintScopeCode.ScopeCode scopeCode, GaiaMintScopeCode.ScopeCode ... additionalScopeCodes) {
        return RulesSecurityValidator.builder().jwtVerifier(new FirebearJwtVerifier(new ClockWithSkew(new SystemClock(), DEFAULT_JWT_VERIFIER_CLOCK_SKEW), Preconditions.checkNotNull(firebearCertificateProvider))).serviceAccountAuthenticator(AuthenticatorCache.builder().shortTermCredentialsClient(Preconditions.checkNotNull(shortTermCredentialsClient)).streamzPrefix(CREDENTIAL_CACHE_STREAMZ_PREFIX).addScopeCode(scopeCode).addAllScopeCodes(Arrays.asList(additionalScopeCodes)).build());
    }

    public static class RulesSecurityValidatorBuilder {
        private Function<Long, String> rulesServiceAccountNamingStrategy;
        private ServiceAccountAuthenticator serviceAccountAuthenticator;
        @Nullable
        private ValidatorFactory clientProvidedValidatorFactory;
        @Nullable
        private JwtVerifier jwtVerifier;
        @Nullable
        private Environment gaiaEnvironment;
        private static final Function<Environment, Supplier<ValidatorFactory>> VALIDATOR_FACTORY_PROVIDER = environment -> Suppliers.memoize(() -> new GaiaValidatorFactoryBuilder(environment).build());

        private RulesSecurityValidatorBuilder() {
        }

        public RulesSecurityValidatorBuilder gaiaEnvironment(Environment gaiaEnvironment) {
            this.gaiaEnvironment = gaiaEnvironment;
            return this;
        }

        public RulesSecurityValidatorBuilder rulesServiceAccountNamingStrategy(Function<Long, String> rulesServiceAccountNamingStrategy) {
            this.rulesServiceAccountNamingStrategy = rulesServiceAccountNamingStrategy;
            return this;
        }

        public RulesSecurityValidatorBuilder serviceAccountAuthenticator(ServiceAccountAuthenticator serviceAccountAuthenticator) {
            this.serviceAccountAuthenticator = serviceAccountAuthenticator;
            return this;
        }

        public RulesSecurityValidatorBuilder jwtVerifier(JwtVerifier jwtVerifier) {
            this.jwtVerifier = jwtVerifier;
            return this;
        }

        public RulesSecurityValidatorBuilder validatorFactory(ValidatorFactory validatorFactory) {
            this.clientProvidedValidatorFactory = validatorFactory;
            return this;
        }

        public RulesSecurityValidator build() {
            Preconditions.checkState(this.gaiaEnvironment != null ^ this.clientProvidedValidatorFactory != null, "Either the gaiaEnvironment or the validatorFactory may be set, but not both.");
            ValidatorFactory validatorFactory = this.clientProvidedValidatorFactory != null ? this.clientProvidedValidatorFactory : VALIDATOR_FACTORY_PROVIDER.apply(this.gaiaEnvironment).get();
            Validator validator = validatorFactory.createValidator(ValidationOptions.newBuilder().addAllAcceptableScope(this.serviceAccountAuthenticator.acceptedScopes()).build());
            return new RulesSecurityValidator(this.rulesServiceAccountNamingStrategy, validator, this.jwtVerifier, this.serviceAccountAuthenticator);
        }
    }
}

