/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.auth;

import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.common.labs.concurrent.RetryStrategy;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.rules.runtime.auth.ShortTermCredentialsClient;
import com.google.gaia.mint.GetShortTermCredentialsRequest;
import com.google.gaia.mint.GetShortTermCredentialsResponse;
import com.google.gaia.mint.credentials.GetShortTermCredentialsException;
import com.google.gaia.mint.credentials.RobotClient;
import com.google.thirdparty.jodatime.JodaSleeper;
import java.util.concurrent.TimeUnit;

public class ServiceAccountCredentialsClient
implements ShortTermCredentialsClient {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/rules/runtime/auth/ServiceAccountCredentialsClient");
    private final RobotClient robotClient;
    private final RetryStrategy retryStrategy;
    private final JodaSleeper sleeper;

    public ServiceAccountCredentialsClient(RobotClient robotClient, RetryStrategy retryStrategy, JodaSleeper sleeper) {
        this.robotClient = Preconditions.checkNotNull(robotClient);
        this.retryStrategy = Preconditions.checkNotNull(retryStrategy);
        this.sleeper = Preconditions.checkNotNull(sleeper);
    }

    @Override
    public GetShortTermCredentialsResponse getShortTermCredentials(GetShortTermCredentialsRequest shortTermCredentialsRequest) throws InterruptedException, GetShortTermCredentialsException {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/firebase/rules/runtime/auth/ServiceAccountCredentialsClient", "getShortTermCredentials", 46, "ServiceAccountCredentialsClient.java")).log("Getting short term credentials for %s", shortTermCredentialsRequest.getRobotEmail());
        GetShortTermCredentialsException credentialsException = null;
        int attempt = 0;
        while (this.retryStrategy.tryAgain(attempt)) {
            int delay = this.retryStrategy.getDelayMillis(attempt);
            if (delay > 0) {
                this.sleeper.sleep((long)this.retryStrategy.getDelayMillis(attempt), TimeUnit.MILLISECONDS);
            }
            try {
                return this.robotClient.getShortTermCredentials(shortTermCredentialsRequest);
            }
            catch (GetShortTermCredentialsException ex) {
                credentialsException = ex;
                if (!this.isRetryableException(ex)) {
                    throw credentialsException;
                }
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/firebase/rules/runtime/auth/ServiceAccountCredentialsClient", "getShortTermCredentials", 64, "ServiceAccountCredentialsClient.java")).log("Unable to get a short term credentials. %s", ex.getErrorMessage());
                ++attempt;
            }
        }
        if (credentialsException != null) {
            throw credentialsException;
        }
        throw new IllegalStateException("Error getting credentials, but no GetShortTermCredentialsException is available.");
    }

    @Override
    public ListenableFuture<GetShortTermCredentialsResponse> getShortTermCredentialsAsync(GetShortTermCredentialsRequest shortTermCredentialsRequest) {
        return this.robotClient.asyncGetShortTermCredentials(shortTermCredentialsRequest);
    }

    @Override
    public boolean isRetryableException(GetShortTermCredentialsException exception) {
        GetShortTermCredentialsResponse.ReturnCode code = exception.getReturnCode();
        return code == GetShortTermCredentialsResponse.ReturnCode.GAIA_UNAVAILABLE || code == GetShortTermCredentialsResponse.ReturnCode.RPC_ERROR || code == GetShortTermCredentialsResponse.ReturnCode.TOKEN_RATE_LIMIT_EXCEEDED || code == GetShortTermCredentialsResponse.ReturnCode.ZANZIBAR_DEADLINE_EXCEEDED || code == GetShortTermCredentialsResponse.ReturnCode.IAM_REQUEST_THROTTLED;
    }
}

