/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.common;

import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.runtime.common.BaseFunction;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.common.TypeProvider;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class AbstractTypeProvider
implements TypeProvider {
    private final ExpressionValue.KindCase operandType;
    private final Map<String, RuntimeFunction> functionMap;

    public AbstractTypeProvider(ExpressionValue.KindCase operandType) {
        ImmutableMap.Builder<String, RuntimeFunction> builder = ImmutableMap.builder();
        this.register(builder);
        this.operandType = operandType;
        this.functionMap = builder.build();
    }

    protected abstract void register(ImmutableMap.Builder<String, RuntimeFunction> var1);

    @Override
    public ExpressionValue.KindCase operandType() {
        return this.operandType;
    }

    @Override
    @Nullable
    public BaseFunction getFunction(ExpressionValue.KindCase operandType, String functionName) {
        return operandType == this.operandType() ? (BaseFunction)this.functionMap.get(functionName) : null;
    }
}

